/* GSMD5.h - GSCrypt: Class GSMD5
   Copyright (C) 2000 Free Software Foundation, Inc.
   
   Written by:	Manuel Guesdon <mguesdon@orange-concept.com>
   Date: 	Mar 2000
   
   Modified by: Ludovic Marcotte <ludovic@Sophos.ca>
   Date:        Dec 2001

   This file is part of the GNUstep GSCrypt Library.
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <Foundation/Foundation.h>

#ifndef BYTE_DEFINED
typedef unsigned char BYTE;
#define BYTE_DEFINED
#endif
#ifndef UINTs_DEFINED
typedef unsigned int UINT;
typedef unsigned char UINT8;
typedef unsigned short UINT16;
typedef unsigned int UINT32;
#define UINTs_DEFINED
#endif

#define OBJ_METHOD_FOR_SEL(_obj, _sel) [(NSObject*)_obj methodForSelector:@selector(_sel)]

NSString* DataToHexString(NSData *theData);

@interface GSMD5: NSObject
{
  NSData* digest;

  UINT32 ctxBuf[4];
  UINT32 ctxBits[2];
  BYTE ctxIn[64];

  BOOL done;
}

- (id) init;
- (void) updateWithData: (NSData *) theData;
- (void) calculateDigest;
+ (UINT) digestSize;

- (void) transform;

- (NSData * ) digest;

- (void) updateWithString: (NSString *) theString
            usingEncoding: (NSStringEncoding) theEncoding;

@end
