#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <glib.h>

#include <gmime/md5-utils.h>

#include <pan/base/acache.h>
#include <pan/base/article.h>
#include <pan/base/base-prefs.h>
#include <pan/base/decode.h>
#include <pan/base/group.h>
#include <pan/base/server.h>
#include <pan/base/status-item.h>
#include <pan/base/util-file.h>

static void
check_md5 (const gchar * filename, const guchar * expected_sum)
{
	gint i;
	gchar * full_filename;
	guchar sum [16];
	guchar sum_hex [33];

	/* init */
	memset (sum, '\0', 16);
	memset (sum_hex, '\0', 33);

	/* get the md5sum */
	full_filename = g_strdup_printf ("%s/%s", download_dir, filename);
	pan_normalize_filename_inplace (full_filename);
	g_message ("md5 check for `%s'", full_filename);
	md5_get_digest_from_file (full_filename, sum);
	unlink (full_filename);
	g_free (full_filename);
	for (i=0; i<16; ++i)
		sprintf (sum_hex+(i*2), "%02x", sum[i]);
	sum_hex[32] = '\0';
	g_message ("expected checksum [%s]", expected_sum);
	g_message (" decoded checksum [%s]", sum_hex);

	/* compare */
	if (memcmp(expected_sum, sum_hex, 32)) {
		g_message ("File `%s' failed md5sum test", filename);
		exit (1);
	}

	return;
}

static gchar*
my_status_item_describe (const StatusItem * item)
{
	return g_strdup ("decode_test");
}

static void
init_pan (void)
{
	gchar * base;
	gchar * data_dir;

	base = getenv ("srcdir");
	base = g_strdup_printf ("%s/", base!=NULL ? base : getenv("PWD"));
	data_dir = g_strdup_printf ("%s/data/", base);
	base_prefs_init (data_dir, g_get_tmp_dir(), 100, FALSE, FALSE);

	g_free (data_dir);
}

extern int server_saving_enabled;

int
main (void)
{
	decode_data dd;
	Server * server;
	Group * group;
	GPtrArray * a;
	StatusItem * status;

	g_thread_init (NULL);
	init_pan ();
	server_saving_enabled = FALSE;

	server = server_new ();
	server->name = g_strdup ("Server");
	group = group_new (server, "alt.test");
	group_ref_articles (group, NULL);

	server_add_groups (server, &group, 1, NULL, NULL);
	a = g_ptr_array_new ();
	status = status_item_new (my_status_item_describe);

	/**
	***  Two UU Attachments
	**/

	if (1)
	{
		GSList * sl = NULL;
		gchar * text = "<two_uu_attachments>";
		Article * article = article_new (group);
		article_set_header (article, HEADER_SUBJECT, text, DO_CHUNK);
		article_set_header (article, HEADER_MESSAGE_ID, text, DO_CHUNK);
		article->part = 1;
		article->parts = 1;
		article->number = 1;
		sl = g_slist_append (sl, article);

		dd.server = server;
		dd.group = group;
		dd.articles = sl;
		dd.path = download_dir;
		dd.filename = NULL;
		dd.item = status;
		decode_article (&dd);
		g_slist_free (sl);
		sl = NULL;

		check_md5 ("foo_01.txt", "b673788512ff1e2d2db02a522c712964");
		check_md5 ("foo_02.txt", "9c22e248d30256891e2f0d61b67bc287");
		g_message ("PASS: two uu attachments in message");
	}

	/**
	***  Mime Attachment
	**/

	if (1)
	{
		GSList * sl = NULL;
		gchar * text = "<two_mime_attachments>";
		Article * article = article_new (group);
		article_set_header (article, HEADER_SUBJECT, text, DO_CHUNK);
		article_set_header (article, HEADER_MESSAGE_ID, text, DO_CHUNK);
		article->part = 1;
		article->parts = 1;
		article->number = 1;
		sl = g_slist_append (sl, article);

		dd.server = server;
		dd.group = group;
		dd.articles = sl;
		dd.path = download_dir;
		dd.filename = NULL;
		dd.item = status;
		decode_article (&dd);
		g_slist_free (sl);
		sl = NULL;

		check_md5 ("Down-We-Go-1.JPG", "b4bfe57389edb1051f0eb48accbea989");
		check_md5 ("The-Only-Answer-1.JPG", "857f7f9e1fce68414cdf6a110a4ad2d2");
		g_message ("PASS: two mime attachments in message");
	}

	/**
	***  Filename collision - should rename the second one
	**/

	if (1)
	{
		GSList * sl = NULL;
		gchar * text = "<collision>";
		Article * article = article_new (group);
		article_set_header (article, HEADER_SUBJECT, text, DO_CHUNK);
		article_set_header (article, HEADER_MESSAGE_ID, text, DO_CHUNK);
		article->part = 1;
		article->parts = 1;
		article->number = 1;
		sl = g_slist_append (sl, article);

		dd.server = server;
		dd.group = group;
		dd.articles = sl;
		dd.path = download_dir;
		dd.filename = NULL;
		dd.item = status;
		decode_article (&dd);
		g_slist_free (sl);
		sl = NULL;

		check_md5 ("collision",   "da32d55e3e524200b59d064384449db2");
		check_md5 ("collision_2", "9b6f6037c580d3cc8bdf3da972ea39d9");
		check_md5 ("collision_3", "25246baff3f46d51e18d6bbb5398560e");
		g_message ("PASS: filenamename collision avoided");
	}

	/**
	***  UUEncoded,  in Filename
	**/

	if (1)
	{
		GSList * sl = NULL;
		gchar * text = "<micro>";
		Article * article = article_new (group);
		article_set_header (article, HEADER_SUBJECT, text, DO_CHUNK);
		article_set_header (article, HEADER_MESSAGE_ID, text, DO_CHUNK);
		article->part = 1;
		article->parts = 1;
		article->number = 1;
		sl = g_slist_append (sl, article);

		dd.server = server;
		dd.group = group;
		dd.articles = sl;
		dd.path = download_dir;
		dd.filename = NULL;
		dd.item = status;
		decode_article (&dd);
		g_slist_free (sl);
		sl = NULL;

		check_md5 ("micro.txt", "39c14a46362de0f4764faef78e1a77b7");
		g_message ("PASS: filename with ");
	}

	/**
	***  UUEncoded, in Apostrophe Filename
	**/

	if (1)
	{
		GSList * sl = NULL;
		gchar * text = "<apostrophe>";
		Article * article = article_new (group);
		article_set_header (article, HEADER_SUBJECT, text, DO_CHUNK);
		article_set_header (article, HEADER_MESSAGE_ID, text, DO_CHUNK);
		article->part = 1;
		article->parts = 1;
		article->number = 1;
		sl = g_slist_append (sl, article);

		dd.server = server;
		dd.group = group;
		dd.articles = sl;
		dd.path = download_dir;
		dd.filename = NULL;
		dd.item = status;
		decode_article (&dd);
		g_slist_free (sl);
		sl = NULL;

		check_md5 ("ap'str'ph'.txt", "ddcfb039ae385314aa5d8155196bb550");
		g_message ("PASS: filenames with apostrophes");
	}


	/**
	*** "Cut Here"
	*** I hate those posts.
	**/

	if (1)
	{
		const gint parts = 2;
		GSList * sl = NULL;
		guint i;

		for (i=0; i<parts; ++i)
		{
			gchar * text = g_strdup_printf ("<noisy_%d_2>", i+1);
			Article * article = article_new (group);
			article_set_header (article, HEADER_SUBJECT, text, DO_CHUNK);
			article_set_header (article, HEADER_MESSAGE_ID, text, DO_CHUNK);
			article->part = i+1;
			article->parts = parts;
			article->number = 1;
			sl = g_slist_append (sl, article);
			g_free (text);
		}

		dd.server = server;
		dd.group = group;
		dd.articles = sl;
		dd.path = download_dir;
		dd.filename = NULL;
		dd.item = status;
		decode_article (&dd);
		g_slist_free (sl);
		sl = NULL;

		check_md5 ("chessboard.gif", "9fa22e8183029f23bff2a85da3c2a034");
		g_message ("PASS: noisy message with `cut here' and end-of-message sig noise");
	}

	/**
	***  This one's so noisy there's even crap INSIDE the encoded text
	**/

	if (1)
	{
		const gint parts = 2;
		GSList * sl = NULL;
		guint i;

		for (i=0; i<parts; ++i)
		{
			gchar * text = g_strdup_printf ("<penguin_%d_%d>", i+1, parts);
			Article * article = article_new (group);
			article_set_header (article, HEADER_SUBJECT, text, DO_CHUNK);
			article_set_header (article, HEADER_MESSAGE_ID, text, DO_CHUNK);
			article->part = i+1;
			article->parts = parts;
			article->number = 1;
			sl = g_slist_append (sl, article);
			g_free (text);
		}

		dd.server = server;
		dd.group = group;
		dd.articles = sl;
		dd.path = download_dir;
		dd.filename = NULL;
		dd.item = status;
		decode_article (&dd);
		g_slist_free (sl);
		sl = NULL;

		check_md5 ("sit3-shine.7.gif", "b2934b889f259ed4e44d4c934e995c00");
		g_message ("PASS: bluespace");
	}

	g_message ("All decode tests passed");
	return 0;
}
