/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Author: Charles Kerr <charles@rebelbase.com>
 *
 * Copyright (C) 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __PAN_STATUS_ITEM__H__
#define __PAN_STATUS_ITEM__H__

#include <glib.h>
#include <pan/base/pan-callback.h>
#include <pan/base/pan-object.h>

/**
***  STATUS ITEM CLASS DEFINITION
**/

#define STATUS_ITEM(a) ((StatusItem *)a)

typedef struct _StatusItem StatusItem;
typedef char* (*StatusItemDescribeFunc)(const StatusItem*);

struct _StatusItem
{
	/*Parent*/
	PanObject     parent;         /* parent object */

	/*Callbacks*/
	PanCallback * progress;       /* obj arg is int [0...100] */
	PanCallback * status;         /* obj arg is const char* (don't free) */
	PanCallback * error;          /* obj arg is const char* (don't free) */
	PanCallback * done;           /* obj arg is status int */

	/*Fields*/
	gchar       * description;    /* overrides the describe() function */
	gchar       * status_text;    /* the last status text emitted, or NULL */
	GSList      * errors;         /* the emitted error strings */
	gint          progress_val;   /* value is [0...100] */
	gint          steps;          /* number of steps for progress */
	gint          step;           /* number of steps so far. [0..steps] */

	/* virtual functions */
	StatusItemDescribeFunc describe;
};

/**
***  PROTECTED
**/

void status_item_constructor    (StatusItem               * item,
                                 PanObjectDestructor        dtor,
                                 StatusItemDescribeFunc     describe);

void status_item_destructor     (PanObject                * object);


/**
***  PUBLIC - STATIC
**/

PanCallback*  status_item_get_active_callback  (void);

/**
***  PUBLIC
**/


StatusItem*   status_item_new                  (StatusItemDescribeFunc);

StatusItem*   status_item_new_with_description (const gchar      * description);

gchar*        status_item_describe             (const StatusItem * item);

void          status_item_emit_status          (StatusItem       * item,
                                                const gchar      * status);

void          status_item_emit_status_va       (StatusItem       * item,
                                                const gchar      * fmt,
                                                ...);

void          status_item_emit_error           (StatusItem       * item,
                                                const gchar      * error);

void          status_item_emit_error_va        (StatusItem       * item,
                                                const gchar      * fmt,
                                                ...);

void          status_item_emit_progress        (StatusItem       * item,
                                                gint               out_of_100);

void          status_item_emit_init_steps      (StatusItem       * item,
                                                gint               steps);

void          status_item_emit_next_step       (StatusItem       * item);

void          status_item_emit_inc_step        (StatusItem       * item,
                                                gint               inc);

void          status_item_emit_set_step        (StatusItem       * item,
                                                gint               step);

void          status_item_emit_activity        (StatusItem       * item,
                                                gint               n);

void          status_item_emit_done            (StatusItem       * item,
                                                gint               status);

void          status_item_set_active           (StatusItem       * item,
                                                gboolean           active);

gint          status_item_get_progress_of_100  (const StatusItem * item);


#endif /* __PAN_STATUS_ITEM__H__ */
