/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team (pan@rebelbase.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __ARTICLE_LIST_H__
#define __ARTICLE_LIST_H__

#include <gdk/gdk.h>
#include <gtk/gtkstyle.h>
#include <gtk/gtkctree.h>

#include <pan/base/article.h>
#include <pan/base/group.h>
#include <pan/base/pan-callback.h>
#include <pan/base/status-item.h>

#include <pan/filters/filter.h>

extern GdkColor thread_normal_color;
extern GdkColor thread_read_color;


extern GdkColor killfile_color;
extern GdkColor watched_color;

/****
***** 
****/



/**
***  State Info
**/

void           articlelist_set_filter                   (const Filter*, FilterShow);
Group*         articlelist_get_group                    (void);
void           articlelist_set_threaded                 (gboolean threaded_on);
GtkCTreeNode*  articlelist_get_selected_node            (void);
Article*       articlelist_get_selected_article_nolock  (void);
GPtrArray*     articlelist_get_selected_articles_nolock (void);

/**
***  Stepping Through the Articles
**/

GtkCTreeNode* articlelist_node_next (GtkCTreeNode*);
GtkCTreeNode* articlelist_node_prev (GtkCTreeNode*, gboolean sibling_only);
void articlelist_set_selected_nodes_nolock (GtkCTreeNode**, int qty);

void articlelist_reset_style_nolock        (void);

void articlelist_read_next                 (gboolean cached_only, gboolean read);
void articlelist_read_next_unread          (void);
void articlelist_read_next_thread          (void);
void articlelist_read_next_unread_thread   (void);
void articlelist_read_prev                 (void);
void articlelist_read_prev_thread          (void);
void articlelist_read_top_of_thread        (void);
void articlelist_read_parent               (void);
void articlelist_read_message_id           (const gchar * message_id);

/**
***  Contents
**/

void articlelist_set_group_nolock (Group*);
void articlelist_refresh (void);
void articlelist_read_selected (void);

/**
***  Perform Operations on Articles
**/

void articlelist_expand_selected_threads (void);
void articlelist_collapse_selected_threads (void);
void articlelist_expand_all_threads (void);
void articlelist_collapse_all_threads (void);

void articlelist_select_all_nolock (void);
void articlelist_deselect_all_nolock (void);
void articlelist_add_replies_to_selection_nolock (void);
void articlelist_add_thread_to_selection_nolock (void);

/**
***  Life Cycle
**/

GtkWidget* create_articlelist_ctree (void);


/****
*****  CALLBACKS
****/

/**
 * called whenever the article tree's active group changes.
 *
 * @param call_object the article ctree
 * @param call_arg the new active group
 */
PanCallback* articlelist_get_group_changed_callback (void);

/**
 * called whenever the article tree's selection state changes.
 *
 * @param call_object the article ctree
 * @param call_arg article of the selected article, or NULL if none
 */
extern PanCallback* articlelist_selection_changed;

#endif /* __ARTICLE_LIST_H__ */
