#!/usr/bin/perl -w
# creates the release, assuming build application

sub evaluateArguments();


evaluateArguments();
print "Please enter a version string: ";
my $version = <STDIN>;
chomp($version);

if ($debian)
{
	print "Did you remember to run dch -v $version and commit the changes? (y/n)?\n";
	my $decide = <STDIN>;
	if ( $decide =~ /n/ )
	{
		system("dch -v $version");
		system("svn commit debian/changelog");
	}
}

my $headmodule = "packagesearch";	# toplevel module
my $projectname = "packagesearch";	# the sourceforge name of the project
my $releasename = "packagesearch";	# the base name the release file 

my $releaseDir = "../packagesearch-release";
my $returnFromReleaseDir = "../packagesearch";


mkdir("$releaseDir");
chomp($date =`date +\%Y-\%m-\%d`);	# get the current date
my $src_filename = "$releasename-v$version-$date-src.tar.bz2";

print "Changing directory to release\n";
chdir("$releaseDir");
if ($source)
{
	print "Getting the svn version\n";
	(system("svn export https://packagesearch.svn.sourceforge.net/svnroot/packagesearch/trunk/packagesearch $headmodule-$version")==0)
		|| die("Could not get svn version.\n");
	print "creating source tarball\n";
	(system("tar cjf $src_filename $headmodule-$version\/\n")==0) || die("could not create archive.\n");
	print "source tarball $src_filename created\n";
}

if ($debian)
{
	print "creating debian package\n";
	chdir("$headmodule-$version");
	(system("pdebuild")==0) || die("could not create archive.\n");
	chdir("$returnFromReleaseDir");
	# `lintian -i ${headmodule}_${version}-*_i386.changes`;	# we don't know the revision here, so try a star
	print "Press any key to continue";
	my $dummy = <STDIN>;
}

sub evaluateArguments()
{
	if (@ARGV==0)	# no argument
	{
		print "usage: make_release.pl [source] [binary] [debian]\n";
		exit;
	}
	$source = 0;
	foreach(@ARGV)
	{
		if ($_ eq "debian")
		{
			$debian = 1;
		}
		elsif ($_ eq "source")
		{
			$source = 1;
		}
		else	# not one of the keywords
		{
			print "usage: make_release.pl [source] [debian]\n";
			exit;
		}
	}
}
