//
// C++ Interface: singleton
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __EPTINSTANCE_H_2006_08_17
#define __EPTINSTANCE_H_2006_08_17

namespace ept {
class Aggregator;
}

/** @brief This class provides the point of access to all Ept functionality
  * 
  * It is implemented using the Singleton pattern, with static access methods
  * to access the main ept parts.
  *
  * @author Benjamin Mesing
  */
class EptInstance
{
	typedef ept::Aggregator Aggregator;

	static Aggregator* _pAggregator;
public:
	/** This gets the instance managed by the singleton. */
 	static Aggregator* aggregator();
};

#endif	// __SINGLETON_H_2004_07_03
