//
// C++ Implementation: emptytagfilter
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "emptytagfilter.h"


#include <QVariant>

#include <ept/debtags/debtags.h>
#include "eptinstance.h"
#include "aggregator.h"


// NTagModel
#include "vocabularymodel.h"
#include "vocabularymodelrole.h"

namespace NTagModel {

EmptyTagFilter::EmptyTagFilter(const VocabularyModel* pModel, QObject* pParent)
 : QSortFilterProxyModel(pParent)
{
	// initialization of the companion tags (do not simply set all tags to filter
	// out tags which do not have any packages tagged with those
// 	_companionTags = _pContainer->collection()->getCompanionTags(set<Tag>());
	_pVocabularyModel = pModel;
// 	qDebug("[Collection Tags] %lu", _pContainer->collection()->getAllTagsAsVector().size());
// 	qDebug("[Companion Tags] %lu", _pContainer->collection()->getCompanionTags(_pVocabularyModel->selectedTags()).size());
	connect(_pVocabularyModel, SIGNAL(dataChanged(QModelIndex, QModelIndex)), SLOT(tagSelectionChanged()));
}


EmptyTagFilter::~EmptyTagFilter()
{
}


bool EmptyTagFilter::filterAcceptsRow(int sourceRow, const QModelIndex& sourceParent) const
{
	// tree filtering -> if a child is shown, also show the facet
	QModelIndex current = sourceModel()->index(sourceRow, 0, sourceParent);
	if (!current.isValid())
	{
		qDebug("[EmptyTagFilter::filterAcceptsRow] Invalid model index!");
		return false;
	}
	for( int i = 0; i < sourceModel()->rowCount(current); ++i )
	{
		const QModelIndex child = current.child(i, 0);
		if (filterAcceptsRow(i, current))
			return true;
	}
	
	// [DEBUG] always show facets [/DEBUG]
	// facets without tags will not be shown
	if (sourceModel()->data(current, TypeRole).toInt() == FacetTypeItem)
// 		return true;
		return false;
	
 	Tag tag = sourceModel()->data(current, TagRole).value<TagWrapper>().tag;
 	// if no tags are selected, the companion tags are useless -> show only those tags
 	// which have a cardinality > 0
 	if (_pVocabularyModel->selectedTags().empty())
 		return EptInstance::aggregator()->debtags().getCardinality(tag) > 0;
	
	set<Tag> companionTags = EptInstance::aggregator()->debtags().getCompanionTags(_pVocabularyModel->selectedTags());
/*	if (companionTags.find(tag) == companionTags.end())
		qDebug("Tag " + toQString(tag.fullname()) + " is hidden as non-companion");
	else 
		qDebug("Tag " + toQString(tag.fullname()) + " is shown as companion");*/
	return companionTags.find(tag) != companionTags.end();
}


void EmptyTagFilter::tagSelectionChanged()
{
	filterChanged();
}

}	// NTagModel 

#undef emit	
#include <ept/debtags/debtags.tcc>
