//
// C++ Interface: debtagshelper
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __NUTIL_DEBTAGSHELPER_H_2005_09_24
#define __NUTIL_DEBTAGSHELPER_H_2005_09_24

#include <string>

#include <ept/cache/apt/packages.h>
#include <ept/cache/package.h>
#include <ept/cache/relation.h>
#include <ept/cache/tag.h>
#include <ept/cache/debtags/vocabulary.h>

#include "eptinstance.h"

#if 0
#include <tagcoll/OpSet.h>
#include <apt-front/cache/entity/package.h>
#include <apt-front/cache/entity/tag.h>
#include <apt-front/cache/cache.h>
#include <apt-front/cache/component/tags.h>
#endif

using namespace std;

//using namespace aptFront::cache;

namespace NUtil
{

typedef ept::configuration::apt::cache::Package Package;
typedef ept::configuration::apt::cache::Tag Tag;
typedef ept::configuration::apt::cache::TagMap TagMap;
typedef ept::configuration::apt::cache::Vocabulary Vocabulary;


inline std::set<string> packagesToStrings(const set<Package>& packages)
{
	std::set<string> result;
	for (set<Package>::const_iterator it = packages.begin(); it != packages.end(); ++it)
	{
		result.insert(it->name());
	}
	return result;
}


inline std::set<string> tagsToStrings(const set<Tag>& tags)
{
	std::set<string> result;
	for (set<Tag>::const_iterator it = tags.begin(); it != tags.end(); ++it)
	{
		result.insert(it->fullname());
	}
	return result;
}

inline std::set<Tag> stringsToTags(const set<string>& tags)
{
	std::set<Tag> result;
	const Vocabulary& tagsComponent = EptInstance::aggregator()->vocabulary();
	for (set<string>::const_iterator it = tags.begin(); it != tags.end(); ++it)
	{
		result.insert(tagsComponent.tagByName(*it));
	}
	return result;
}

/** Returns the entity::Package with this package name. */
inline Package getPackageByName(const string package)
{
	return EptInstance::aggregator()->index().packageByName(package);
}


}

#endif //  __NUTIL_DEBTAGSHELPER_H_2005_09_24
