//
// C++ Interface: runcommandinxterm
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __RUNCOMMANDINXTERM_H_2004_05_12
#define __RUNCOMMANDINXTERM_H_2004_05_12

#include <list>

#include "extalgorithm.h"
#include "runcommand.h"


using namespace std;

class QProcess;

namespace NApplication 
{

/** This class runs a command in an XTerm. The XTerm is closes as soon as the started program is active.
  * @author Benjamin Mesing
  */
class RunCommandInXterm : public RunCommand
{
	list<QString> _arguments;
	/** The process currently executed. Is 0 if no process is currently executed.  */
	QProcess* _pProcess;
private slots:
	void onProcessExited();
public:
	RunCommandInXterm();
	~RunCommandInXterm();
	virtual void addArgument(const QString& arg);
	virtual bool start();
	/** This returns allways true as I do not see a way to get hold of the exit status using an xterm. */
	virtual bool processExitedSuccessful() const	{ return true; };
};

};	// namespace NApplication

#endif	//  __RUNCOMMANDINXTERM_H_2004_05_12
