/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/


void ColumnControlDlg::setContent(const QStringList & shown, const QStringList & hidden)
{
   _pShownList->insertStringList(shown);
   _pHiddenList->insertStringList(hidden);
}



QStringList ColumnControlDlg::getShown()
{
   QStringList result;
   for (uint i=0; i<_pShownList->count(); ++i)
      result.push_back(_pShownList->text(i));
   return result;
}


QStringList ColumnControlDlg::getHidden()
{
   QStringList result;
   for (uint i=0; i<_pHiddenList->count(); ++i)
      result.push_back(_pHiddenList->text(i));
   return result;
}

void ColumnControlDlg::onHideButton()
{
   QListBoxItem* pItem = _pShownList->selectedItem();
   // if nothing is selected
   if (pItem == 0)
      return;
   QListBoxItem* pPrev = pItem->prev();
   _pHiddenList->insertItem(pItem->text());
   _pShownList->removeItem(_pShownList->index(pItem));
	if (pPrev)
		_pShownList->setSelected(pPrev, true);
	else
		_pShownList->setSelected(0, true);

}

void ColumnControlDlg::onShowButton()
{
   QListBoxItem* pItem = _pHiddenList->selectedItem();
   // if nothing is selected
	if (pItem == 0)
      return;
   QListBoxItem* pPrev = pItem->prev();
   _pShownList->insertItem(pItem->text());
   _pHiddenList->removeItem(_pHiddenList->index(pItem));
	if (pPrev)
		_pHiddenList->setSelected(pPrev, true);
	else
		_pHiddenList->setSelected(0, true);
}


void ColumnControlDlg::onUpButton()
{
   QListBoxItem* pItem = _pShownList->selectedItem();
   if (!pItem)
		return;
	int index = _pShownList->index(pItem);
	QString text = pItem->text();
   // if it is already the first item
	if (index==0)
      return;
   _pShownList->removeItem(index);
   _pShownList->insertItem(text, index-1);
	_pShownList->setSelected(index-1, true);
}

void ColumnControlDlg::onDownButton()
{
   QListBoxItem* pItem = _pShownList->selectedItem();
   if (!pItem)
		return;
   int index = _pShownList->index(pItem);
	QString text = pItem->text();
	// if it is already the last item
   if (index==_pShownList->count()-1)
      return;
   _pShownList->removeItem(index);
   _pShownList->insertItem(text, index+1);
	_pShownList->setSelected(index+1, true);
}
