
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: x11.h,v 1.7 2005/11/24 09:33:49 mschwerin Exp $
 *
 */

#ifndef HAVE_X11_H
#define HAVE_X11_H

#include "odk_plugin.h"

/*
 * X11 window driver constructor
 */
odk_window_t *x11_construct (xine_t * xine, const char *driver);

/*
 * X11 window driver plugin description
 */
window_plugin_desc_t x11_plugin_desc[] = {
    {"x11", "X video extention output", "xv", x11_construct},
    {"x11", "X shared memory output", "xshm", x11_construct},
    {"x11", "X window sdl output", "sdl", x11_construct},
    {"x11", "X window opengl output", "opengl", x11_construct},
    {"x11", "autodetected X window output", "auto", x11_construct},
    {NULL, NULL, NULL, NULL}
};
#endif
