
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: playlist_menu.c,v 1.15 2006/01/17 13:55:53 mschwerin Exp $
 *
 */
#include "config.h"

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include "disc.h"
#include "environment.h"
#include "filelist_menu.h"
#include "gui_utils.h"
#include "heap.h"
#include "i18n.h"
#include "logger.h"
#include "main_menu.h"
#include "oxine.h"
#include "playlist_menu.h"
#include "playlist_m3u.h"

static otk_widget_t *playlist_widget;
static void update_playlist_widget (void *oxine_p);

static void
playlist_select_cb (void *list_cb_data, void *entry_cb_data)
{
    oxine_t *oxine = (oxine_t *) list_cb_data;
    playitem_t *playitem = (playitem_t *) entry_cb_data;

    playlist_play_item (oxine, playitem);
}

static void
playlist_remove_cb (void *list_cb_data, void *entry_cb_data)
{
    oxine_t *oxine = (oxine_t *) list_cb_data;
    playitem_t *item = (playitem_t *) entry_cb_data;

    playlist_remove (oxine->playlist, item);
}

static void
update_playlist_widget (void *oxine_p)
{
    oxine_t *oxine = (oxine_t *) oxine_p;

    if (playlist_widget) {
        otk_clear_list (playlist_widget);

        playitem_t *cur = playlist_first (oxine->playlist);
        while (cur) {
            otk_listentry_new (playlist_widget, cur->title,
                               playlist_select_cb, cur, playlist_remove_cb,
                               cur);
            cur = playlist_next (oxine->playlist, cur);
        }

        otk_widget_set_focus (playlist_widget);
    }
}

static void
playlist_clear_cb (void *oxine_p)
{
    oxine_t *oxine = (oxine_t *) oxine_p;

    playlist_clear (oxine->playlist);

    update_playlist_widget (oxine);
    otk_draw (oxine->otk);
}

static void
playlist_remove_selected_cb (void *oxine_p)
{
    oxine_t *oxine = (oxine_t *) oxine_p;
    int num_selected;

    playitem_t **playitems =
        (playitem_t **) otk_list_get_selected (playlist_widget,
                                               &num_selected);

    if (num_selected != 1)
        return;

    playlist_remove (oxine->playlist, playitems[0]);
    ho_free (playitems);
    update_playlist_widget (oxine);
    otk_draw (oxine->otk);
}

static void
playlist_move_up_selected_cb (void *oxine_p)
{
    oxine_t *oxine = (oxine_t *) oxine_p;
    int num_selected;

    playitem_t **playitems =
        (playitem_t **) otk_list_get_selected (playlist_widget,
                                               &num_selected);
    int *positions =
        otk_list_get_selected_pos (playlist_widget, &num_selected);

    if (num_selected != 1)
        return;

    playlist_move_up (oxine->playlist, playitems[0]);
    update_playlist_widget (oxine);
    otk_list_set_selected (playlist_widget, positions[0] - 1, 1);
    ho_free (playitems);
    ho_free (positions);
    otk_draw (oxine->otk);
}

static void
playlist_move_down_selected_cb (void *oxine_p)
{
    oxine_t *oxine = (oxine_t *) oxine_p;
    int num_selected;

    playitem_t **playitems =
        (playitem_t **) otk_list_get_selected (playlist_widget,
                                               &num_selected);
    int *positions =
        otk_list_get_selected_pos (playlist_widget, &num_selected);

    if (num_selected != 1)
        return;

    playlist_move_down (oxine->playlist, playitems[0]);
    update_playlist_widget (oxine);
    otk_list_set_selected (playlist_widget, positions[0] + 1, 1);
    ho_free (playitems);
    ho_free (positions);
    otk_draw (oxine->otk);
}

static void
playlist_play_cb (void *oxine_p)
{
    oxine_t *oxine = (oxine_t *) oxine_p;

    playlist_play_first (oxine);
}

static void
playlist_save_cb (void *oxine_p)
{
    oxine_t *oxine = (oxine_t *) oxine_p;

    if (playlist_length (oxine->playlist) > 0) {
        char mrl[1024];
        snprintf (mrl, 1023, "%s/oxine-saved-playlist.m3u", get_dir_home ());

        m3u_save (oxine->playlist, mrl);

        clean_otk_stuff (oxine);
        otk_window_new (oxine->otk, 0, 0, 800, 600, 0, 0);
        otk_border_new (oxine->otk, 100, 200, 600, 200);
        show_clock (oxine);

        otk_widget_t *l;
        l = otk_label_new (oxine->otk, 400, 250,
                           OTK_ALIGN_CENTER | OTK_ALIGN_BOTTOM,
                           _("Saved playlist to file"));
        otk_label_set_max_width (l, 560);
        l = otk_label_new (oxine->otk, 400, 290,
                           OTK_ALIGN_CENTER | OTK_ALIGN_BOTTOM, mrl);
        otk_label_set_max_width (l, 560);

        otk_widget_t *b;
        b = otk_button_new (oxine->otk, 320, 320, 160, 40, "OK",
                            show_playlist_menu_cb, oxine);
        otk_widget_set_alignment (b, OTK_ALIGN_CENTER);
        otk_widget_set_focus (b);

        otk_draw (oxine->otk);
    }
}

void
show_playlist_menu_cb (void *oxine_p)
{
    oxine_t *oxine = (oxine_t *) oxine_p;

    clean_otk_stuff (oxine);
    show_background (oxine, OXINE_DATADIR "/playlistmenu.mpg");

    otk_window_new (oxine->otk, 0, 0, 800, 600, 0, 0);

    show_clock (oxine);

    int x = 20;
    int y = 100;
    otk_button_new (oxine->otk, x, y, 180, 35, _("Play"),
                    playlist_play_cb, oxine);
    y += 40;
    otk_button_new (oxine->otk, x, y, 180, 35, _("Add"),
                    oxine->filelist_menu, oxine);
    y += 40;
    otk_button_new (oxine->otk, x, y, 180, 35, _("Delete"),
                    playlist_remove_selected_cb, oxine);
    y += 40;
    otk_button_new (oxine->otk, x, y, 180, 35, _("Delete All"),
                    playlist_clear_cb, oxine);
    y += 40;
    otk_button_new (oxine->otk, x, y, 180, 35, _("Move Up"),
                    playlist_move_up_selected_cb, oxine);
    y += 40;
    otk_button_new (oxine->otk, x, y, 180, 35, _("Move Down"),
                    playlist_move_down_selected_cb, oxine);
    y += 40;
    otk_button_new (oxine->otk, x, y, 180, 35, _("Save"),
                    playlist_save_cb, oxine);
    y += 40;
    otk_button_new (oxine->otk, x, y, 180, 35, _("Eject"), eject_cb, oxine);
    y += 40;
    otk_button_new (oxine->otk, x, y, 180, 35, _("Mainmenu"),
                    show_main_menu_cb, oxine);

    playlist_widget = otk_list_new (oxine->otk, 220, 100, 560, 480,
                                    OTK_LIST_SINGLE_SELECTION, TRUE, oxine);
    update_playlist_widget (oxine);

    otk_draw (oxine->otk);

    oxine->repaint_menu = show_playlist_menu_cb;
    oxine->playback_ended_menu = show_playlist_menu_cb;
    oxine->backto_menu = oxine->filelist_menu;
}
