
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: otk.h,v 1.34 2005/12/14 12:54:09 mschwerin Exp $
 *
 */

#ifndef HAVE_OTK_H
#define HAVE_OTK_H



#include "event.h"
#include "odk.h"

/*
 * alignments for text and buttons
 */
#define OTK_ALIGN_LEFT     0x001
#define OTK_ALIGN_CENTER   0x002
#define OTK_ALIGN_RIGHT    0x004
#define OTK_ALIGN_TOP      0x008
#define OTK_ALIGN_VCENTER  0x010
#define OTK_ALIGN_BOTTOM   0x020

/*
 * opaque data types
 */
typedef struct otk_s otk_t;
typedef struct otk_widget_s otk_widget_t;

/*
 * user contributed callbacks
 */
typedef void (*otk_cb_t) (void *user_data);

typedef void (*otk_button_cb_t) (void *user_data);

typedef void (*otk_list_cb_t) (void *list_cb_data, void *entry_cb_data);

typedef int (*otk_slider_data_cb_t) (void *user_data);

typedef void (*otk_slider_cb_t) (void *user_data, int position);

typedef void (*otk_scrollbar_cb_t) (void *user_data, int position);

typedef void (*otk_label_uc_t) (void *user_data, otk_widget_t * widget);

typedef void (*otk_selector_cb_t) (void *user_data, int position);


/*
 * ***********************************************************************************
 * Button-Widget 
 * ***********************************************************************************
 */
otk_widget_t *otk_button_new (otk_t * otk, int x, int y, int w, int h,
                              char *text, otk_button_cb_t cb, void *cb_data);
otk_widget_t *otk_pixmap_button_new (otk_t * otk, int x, int y,
                                     int w, int h, uint8_t * pixmap,
                                     otk_button_cb_t cb, void *cb_data);
void otk_button_set_text (otk_widget_t * widget, const char *text);

/*
 * ***********************************************************************************
 * Slider-Widget 
 * ***********************************************************************************
 */

#define OTK_SLIDER_VERTICAL     (0)
#define OTK_SLIDER_HORIZONTAL   (1)

otk_widget_t *otk_slider_new (otk_t * otk, int x, int y, int w, int h,
                              int direction,
                              otk_slider_data_cb_t get_value_cb,
                              void *get_value_cb_data, otk_slider_cb_t cb,
                              void *cb_data);

/*
 * ***********************************************************************************
 * Checkbox-Widget 
 * ***********************************************************************************
 */
otk_widget_t *otk_checkbox_new (otk_t * otk, int x, int y,
                                int is_checked, otk_button_cb_t cb,
                                void *cb_data);

/*
 * ***********************************************************************************
 * ListEntry-Widget
 * ***********************************************************************************
 */
otk_widget_t *otk_listentry_new (otk_widget_t * list, const char *text,
                                 otk_list_cb_t select_cb,
                                 void *select_cb_data,
                                 otk_list_cb_t remove_cb,
                                 void *remove_cb_data);

/*
 * ***********************************************************************************
 * List-Widget
 * ***********************************************************************************
 */
#define OTK_LIST_NO_SELECTION (0)
#define OTK_LIST_SINGLE_SELECTION (1)
#define OTK_LIST_MULTIPLE_SELECTION (2)

otk_widget_t *otk_list_new (otk_t * otk, int x, int y, int w,
                            int h, int allow_select, int allow_remove,
                            void *cb_data);

void otk_clear_list (otk_widget_t * list);
int otk_list_get_pos (otk_widget_t * list);
void otk_list_set_pos (otk_widget_t * list, int pos);
int otk_list_get_focus (otk_widget_t * list);
void otk_list_set_focus (otk_widget_t * list, int pos);

int *otk_list_get_selected_pos (otk_widget_t * list, int *num_selected);
void **otk_list_get_selected (otk_widget_t * list, int *num_selected);
void otk_list_set_selected (otk_widget_t * list, int pos, int selected);
void otk_list_clear_selection (otk_widget_t * list);
int otk_list_get_selected_count (otk_widget_t * list);

/*
 * ***********************************************************************************
 * Selector-Widget
 * ***********************************************************************************
 * This is a list, that only shows one entry.
 * ***********************************************************************************
 * The callback can be used to inform the application, that the visible entry
 * has changed.
 * ***********************************************************************************
 */
otk_widget_t *otk_selector_new (otk_t * otk, int x, int y, int w,
                                otk_selector_cb_t cb, void *cb_data);

/*
 * ***********************************************************************************
 * Label-Widget
 * ***********************************************************************************
 */
otk_widget_t *otk_label_new (otk_t * otk, int x, int y,
                             int alignment, const char *text);

void otk_label_set_text (otk_widget_t * widget, const char *text);
void otk_label_set_max_width (otk_widget_t * widget, int max_text_width);
void otk_label_set_upcall (otk_widget_t * widget, otk_label_uc_t upcall,
                           void *data);

/*
 * ***********************************************************************************
 * Scrollbar-Widget
 * ***********************************************************************************
 */
otk_widget_t *otk_scrollbar_new (otk_t * otk, int x, int y, int w, int h,
                                 otk_scrollbar_cb_t cb_click,
                                 otk_button_cb_t cb_up,
                                 otk_button_cb_t cb_down, void *cb_data);
void otk_scrollbar_set (otk_widget_t * scrollbar_p, int position, int length);

/*
 * ***********************************************************************************
 * Border-Widget
 * ***********************************************************************************
 */
otk_widget_t *otk_border_new (otk_t * otk, int x, int y, int w, int h);

/*
 * ***********************************************************************************
 * Window-Widget
 * ***********************************************************************************
 */
otk_widget_t *otk_window_new (otk_t * otk, int x, int y, int w, int h,
                              int border, int fill);
void otk_window_set_current (otk_t * otk, otk_widget_t * window);
void otk_window_keep (otk_widget_t * window, int keep);
void otk_window_destroy (otk_widget_t * window);

/*
 * ***********************************************************************************
 * Global Functions
 * ***********************************************************************************
 */
void otk_draw (otk_t * otk);
void otk_clear (otk_t * otk);

/* on 1, update this widget continously (every 100 ms) */
void otk_widget_set_focus (otk_widget_t * widget);
void otk_widget_set_focus_callbacks (otk_widget_t * widget, otk_cb_t enter_cb,
                                     void *enter_cb_data, otk_cb_t leave_cb,
                                     void *leave_cb_data);

void otk_widget_set_update (otk_widget_t * widget, int update);
void otk_widget_set_font (otk_widget_t * widget, const char *font,
                          int fontsize);
void otk_widget_set_alignment (otk_widget_t * widget, int alignment);

otk_t *otk_init (odk_t * odk);
void otk_free (otk_t * otk);

/*
 * ***********************************************************************************
 * Eventhandlers
 * ***********************************************************************************
 */
void otk_set_event_handler (otk_t * otk,
                            void (*cb) (void *data, oxine_event_t * ev),
                            void *data);
void otk_send_event (otk_t * otk, oxine_event_t * event);

#endif
