
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: meta_info.h,v 1.2 2005/09/22 07:10:24 mschwerin Exp $
 *
 */

#ifndef META_INFO_H
#define META_INFO_H

typedef enum {
    META_INFO_TITLE = XINE_META_INFO_TITLE,
    META_INFO_ARTIST = XINE_META_INFO_ARTIST,
    META_INFO_GENRE = XINE_META_INFO_GENRE,
    META_INFO_ALBUM = XINE_META_INFO_ALBUM,
    META_INFO_YEAR = XINE_META_INFO_YEAR,
    META_INFO_TRACK_NUMBER = XINE_META_INFO_TRACK_NUMBER
} meta_info_t;

char *meta_info_get_from_stream (xine_stream_t * stream, meta_info_t type);
char *meta_info_get_from_mrl (const char *mrl, meta_info_t type);

#endif
