
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: help_menu.c,v 1.5 2006/01/21 17:53:37 mschwerin Exp $
 *
 */
#include "config.h"

#include "filelist_menu.h"
#include "gui_utils.h"
#include "help_menu.h"
#include "i18n.h"
#include "main_menu.h"
#include "otk.h"
#include "oxine.h"
#include "playing_menu.h"

static void
show_help_menu_second_page_cb (void *oxine_p)
{
    oxine_t *oxine = (oxine_t *) oxine_p;

    clean_otk_stuff (oxine);
    if (odk_current_is_logo_mode (oxine->odk)) {
        show_background (oxine, OXINE_DATADIR "/helpmenu.mpg");
    } else {
        oxine->user_interface_is_visible = 1;
    }

    oxine->repaint_menu = show_help_menu_second_page_cb;

    otk_window_new (oxine->otk, 0, 0, 800, 600, 0, 0);

    show_clock (oxine);

    int x0 = 20;
    int x1 = 510;
    int x2 = 540;
    int y = 100;
    int a = OTK_ALIGN_LEFT | OTK_ALIGN_TOP;

    otk_widget_t *label;
    label = otk_label_new (oxine->otk, x0, y, a, _("toggle mute/ unmute"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    otk_label_new (oxine->otk, x1, y, a, "m");

    y += 30;
    label = otk_label_new (oxine->otk, x0, y, a, _("adjust volume"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    otk_label_new (oxine->otk, x1, y, a, "+");
    otk_label_new (oxine->otk, x2, y, a, "/ -");

    y += 50;
    label = otk_label_new (oxine->otk, x0, y, a, _("change audio language"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    otk_label_new (oxine->otk, x1, y, a, "x");
    otk_label_new (oxine->otk, x2, y, a, "/ X");

    y += 30;
    label = otk_label_new (oxine->otk, x0, y, a, _("adjust audio offset"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    otk_label_new (oxine->otk, x1, y, a, "c");
    otk_label_new (oxine->otk, x2, y, a, "/ C");

    y += 50;
    label =
        otk_label_new (oxine->otk, x0, y, a, _("change subtitle language"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    otk_label_new (oxine->otk, x1, y, a, "r");
    otk_label_new (oxine->otk, x2, y, a, "/ R");

    y += 30;
    label = otk_label_new (oxine->otk, x0, y, a, _("adjust subtitle offset"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    otk_label_new (oxine->otk, x1, y, a, "t");
    otk_label_new (oxine->otk, x2, y, a, "/ T");

    y += 50;
    label = otk_label_new (oxine->otk, x0, y, a, _("toggle aspect ratio"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    otk_label_new (oxine->otk, x1, y, a, "a");

    y += 30;
    label = otk_label_new (oxine->otk, x0, y, a, _("toggle deinterlace"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    otk_label_new (oxine->otk, x1, y, a, "i");

    otk_widget_t *button;
    button = otk_button_new (oxine->otk, 20, 540, 180, 40,
                             _("Back"), oxine->backto_menu, oxine);
    otk_widget_set_alignment (button, OTK_ALIGN_CENTER);
    otk_widget_set_focus (button);

    button = otk_button_new (oxine->otk, 210, 540, 180, 40,
                             _("Previous Page"), show_help_menu_cb, oxine);
    otk_widget_set_alignment (button, OTK_ALIGN_CENTER);

    otk_draw (oxine->otk);
}


void
show_help_menu_cb (void *oxine_p)
{
    oxine_t *oxine = (oxine_t *) oxine_p;

    if (filelist_menu_is_current_menu (oxine))
        oxine->backto_menu = oxine->repaint_menu;

    clean_otk_stuff (oxine);

    if (odk_current_is_logo_mode (oxine->odk)) {
        show_background (oxine, OXINE_DATADIR "/helpmenu.mpg");
    } else {
        oxine->user_interface_is_visible = 1;
    }

    oxine->repaint_menu = show_help_menu_cb;

    otk_window_new (oxine->otk, 0, 0, 800, 600, 0, 0);

    show_clock (oxine);

    int x0 = 20;
    int x1 = 510;
    int x2 = 540;
    int y = 100;
    int a = OTK_ALIGN_LEFT | OTK_ALIGN_TOP;

    otk_widget_t *label;
    label = otk_label_new (oxine->otk, x0, y, a, _("navigate the menus"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    label = otk_label_new (oxine->otk, x1, y, a, _("arrows (keypad)"));
    otk_label_set_max_width (label, 780 - x1);

    y += 30;
    label =
        otk_label_new (oxine->otk, x0, y, a,
                       _("activate an item or a button"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    label = otk_label_new (oxine->otk, x1, y, a, _("enter"));
    otk_label_set_max_width (label, 780 - x1);

    y += 30;
    label =
        otk_label_new (oxine->otk, x0, y, a, _("select an item in a list"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    label = otk_label_new (oxine->otk, x1, y, a, _("space"));
    otk_label_set_max_width (label, 780 - x1);

    y += 50;
    label =
        otk_label_new (oxine->otk, x0, y, a,
                       _("jump directly to the main menu"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    label = otk_label_new (oxine->otk, x1, y, a, _("esc"));
    otk_label_set_max_width (label, 780 - x1);

    y += 30;
    label =
        otk_label_new (oxine->otk, x0, y, a,
                       _("jump directly to the DVD menus"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    otk_label_new (oxine->otk, x1, y, a, "F1-F7");

    y += 30;
    label = otk_label_new (oxine->otk, x0, y, a, _("show this help menu"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    otk_label_new (oxine->otk, x1, y, a, "?");

    y += 50;
    label = otk_label_new (oxine->otk, x0, y, a, _("pause/ play"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    label = otk_label_new (oxine->otk, x1, y, a, _("space"));
    otk_label_set_max_width (label, 780 - x1);

    y += 30;
    label = otk_label_new (oxine->otk, x0, y, a, _("stop the stream"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    otk_label_new (oxine->otk, x1, y, a, "s");

    y += 50;
    label = otk_label_new (oxine->otk, x0, y, a, _("seek forward/ backward"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    label = otk_label_new (oxine->otk, x1, y, a, _("arrows left, right"));
    otk_label_set_max_width (label, 780 - x1);

    y += 30;
    label =
        otk_label_new (oxine->otk, x0, y, a, _("increase/ decrease speed"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    label = otk_label_new (oxine->otk, x1, y, a, _("arrows up, down"));
    otk_label_set_max_width (label, 780 - x1);

    y += 30;
    label = otk_label_new (oxine->otk, x0, y, a,
                           _("next/ previous title or chapter"));
    otk_label_set_max_width (label, x1 - x0 - 20);
    otk_label_new (oxine->otk, x1, y, a, "n");
    otk_label_new (oxine->otk, x2, y, a, "/ p");

    otk_widget_t *button;
    button = otk_button_new (oxine->otk, 20, 540, 180, 40,
                             _("Back"), oxine->backto_menu, oxine);
    otk_widget_set_alignment (button, OTK_ALIGN_CENTER);
    otk_widget_set_focus (button);

    button = otk_button_new (oxine->otk, 210, 540, 180, 40,
                             _("Next Page"),
                             show_help_menu_second_page_cb, oxine);
    otk_widget_set_alignment (button, OTK_ALIGN_CENTER);

    otk_draw (oxine->otk);
}
