/*
 * Copyright (C) 2005-2017 Centre National d'Etudes Spatiales (CNES)
 *
 * This file is part of Orfeo Toolbox
 *
 *     https://www.orfeo-toolbox.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if defined(_MSC_VER)
#pragma warning ( disable : 4786 )
#endif

#include "otbWrapperNumericalParameter.h"

int otbWrapperNumericalParameterNew(int itkNotUsed(argc), char * itkNotUsed(argv)[])
{
  typedef otb::Wrapper::NumericalParameter <int> NumericalParameterType;
  NumericalParameterType::Pointer parameter = NumericalParameterType::New();

  return EXIT_SUCCESS;
}


int otbWrapperNumericalParameterTest1(int itkNotUsed(argc), char* argv[])
{
  typedef otb::Wrapper::NumericalParameter <double> NumericalParameterType;
  NumericalParameterType::Pointer numParam = NumericalParameterType::New();

  const double value = atof (argv[1]);
  const std::string key = argv[2];
  const std::string desc = argv[3];

  numParam->SetValue(value);
  numParam->SetKey(key);
  numParam->SetDescription(desc);

  return EXIT_SUCCESS;
}
