/*
 * Copyright (c) 1997-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * Global symbol definitions to be included in all libfdev_freebsd code.
 * These defines mostly add fdev_freebsd_ prefixes to global FreeBSD symbols
 * to ensure namespace cleanliness and prevent linking conflicts.
 * The FreeBSD drivers themselves and the FreeBSD glue code
 * should still continue to use the unprefixed names.
 */
#ifndef _FREEBSD_DEV_GLOBAL_H_
#define _FREEBSD_DEV_GLOBAL_H_

/*
 * Public symbols used internally within the Linux drivers.
 * Produced with the following command:
 *	i586-fluke-nm libfdev_freebsd.a | grep ' [TDRC] ' | \
 *	grep -v "fdev_freebsd" \
 *	awk '{ printf "#define "$3" FDEV_FREEBSD_"$3"\n"; }'|sort >>o/global.h
 */
#define Crtat FDEV_FREEBSD_Crtat
#define DELAY FDEV_FREEBSD_DELAY
#define MCFail FDEV_FREEBSD_MCFail
#define MPFail FDEV_FREEBSD_MPFail
#define acquire_timer2 FDEV_FREEBSD_acquire_timer2
#define add_keyboard_randomness FDEV_FREEBSD_add_keyboard_randomness
#define b_to_q FDEV_FREEBSD_b_to_q
#define bcd2bin_data FDEV_FREEBSD_bcd2bin_data
#define bcmp FDEV_FREEBSD_bcmp
#define bin2bcd_data FDEV_FREEBSD_bin2bcd_data
#define boothowto FDEV_FREEBSD_boothowto
#define boottime FDEV_FREEBSD_boottime
#define bootverbose FDEV_FREEBSD_bootverbose
#define bsd_hardclock FDEV_FREEBSD_bsd_hardclock
#define bucket FDEV_FREEBSD_bucket
#define bufhashtbl FDEV_FREEBSD_bufhashtbl
#define bufqueues FDEV_FREEBSD_bufqueues
#define callfree FDEV_FREEBSD_callfree
#define callout FDEV_FREEBSD_callout
#define catq FDEV_FREEBSD_catq
#define cdevsw FDEV_FREEBSD_cdevsw
#define cfreecount FDEV_FREEBSD_cfreecount
#define cfreelist FDEV_FREEBSD_cfreelist
#define chan_opt_dflt FDEV_FREEBSD_chan_opt_dflt
#define char_type FDEV_FREEBSD_char_type
#define clist_alloc_cblocks FDEV_FREEBSD_clist_alloc_cblocks
#define clist_free_cblocks FDEV_FREEBSD_clist_free_cblocks
#define clist_init FDEV_FREEBSD_clist_init
#define clock_init FDEV_FREEBSD_clock_init
#define clone FDEV_FREEBSD_clone
#define commit FDEV_FREEBSD_commit
#define constty FDEV_FREEBSD_constty
#define copy_to FDEV_FREEBSD_copy_to
#define copyin FDEV_FREEBSD_copyin
#define copyout FDEV_FREEBSD_copyout
#define crtc_addr FDEV_FREEBSD_crtc_addr
#define cur_console FDEV_FREEBSD_cur_console
#define curproc FDEV_FREEBSD_curproc
#define current_saver FDEV_FREEBSD_current_saver
#define cx_chan_cd FDEV_FREEBSD_cx_chan_cd
#define cx_chan_dsr FDEV_FREEBSD_cx_chan_dsr
#define cx_chan_dtr FDEV_FREEBSD_cx_chan_dtr
#define cx_chan_rts FDEV_FREEBSD_cx_chan_rts
#define cx_clock FDEV_FREEBSD_cx_clock
#define cx_cmd FDEV_FREEBSD_cx_cmd
#define cx_disable_dma FDEV_FREEBSD_cx_disable_dma
#define cx_iftype FDEV_FREEBSD_cx_iftype
#define cx_init FDEV_FREEBSD_cx_init
#define cx_init_board FDEV_FREEBSD_cx_init_board
#define cx_probe_board FDEV_FREEBSD_cx_probe_board
#define cx_reinit_board FDEV_FREEBSD_cx_reinit_board
#define cx_rxbaud FDEV_FREEBSD_cx_rxbaud
#define cx_setup_board FDEV_FREEBSD_cx_setup_board
#define cx_setup_chan FDEV_FREEBSD_cx_setup_chan
#define cx_sync_mode FDEV_FREEBSD_cx_sync_mode
#define cx_tty FDEV_FREEBSD_cx_tty
#define cx_txbaud FDEV_FREEBSD_cx_txbaud
#define cx_univ_mode FDEV_FREEBSD_cx_univ_mode
#define cxattach FDEV_FREEBSD_cxattach
#define cxboard FDEV_FREEBSD_cxboard
#define cxchan FDEV_FREEBSD_cxchan
#define cxclose FDEV_FREEBSD_cxclose
#define cxdevtotty FDEV_FREEBSD_cxdevtotty
#define cxdown FDEV_FREEBSD_cxdown
#define cxdriver FDEV_FREEBSD_cxdriver
#define cxinit FDEV_FREEBSD_cxinit
#define cxinput FDEV_FREEBSD_cxinput
#define cxintr FDEV_FREEBSD_cxintr
#define cxioctl FDEV_FREEBSD_cxioctl
#define cxmint FDEV_FREEBSD_cxmint
#define cxopen FDEV_FREEBSD_cxopen
#define cxoproc FDEV_FREEBSD_cxoproc
#define cxout FDEV_FREEBSD_cxout
#define cxparam FDEV_FREEBSD_cxparam
#define cxprobe FDEV_FREEBSD_cxprobe
#define cxput FDEV_FREEBSD_cxput
#define cxread FDEV_FREEBSD_cxread
#define cxrinta FDEV_FREEBSD_cxrinta
#define cxrinth FDEV_FREEBSD_cxrinth
#define cxselect FDEV_FREEBSD_cxselect
#define cxsend FDEV_FREEBSD_cxsend
#define cxsioctl FDEV_FREEBSD_cxsioctl
#define cxstart FDEV_FREEBSD_cxstart
#define cxstop FDEV_FREEBSD_cxstop
#define cxswitch FDEV_FREEBSD_cxswitch
#define cxtimeout FDEV_FREEBSD_cxtimeout
#define cxtinta FDEV_FREEBSD_cxtinta
#define cxtinth FDEV_FREEBSD_cxtinth
#define cxup FDEV_FREEBSD_cxup
#define cxwatchdog FDEV_FREEBSD_cxwatchdog
#define cxwrite FDEV_FREEBSD_cxwrite
#define cyclose FDEV_FREEBSD_cyclose
#define cydevtotty FDEV_FREEBSD_cydevtotty
#define cydriver FDEV_FREEBSD_cydriver
#define cyintr FDEV_FREEBSD_cyintr
#define cyintrts FDEV_FREEBSD_cyintrts
#define cyioctl FDEV_FREEBSD_cyioctl
#define cyopen FDEV_FREEBSD_cyopen
#define cypoll FDEV_FREEBSD_cypoll
#define cyread FDEV_FREEBSD_cyread
#define cystop FDEV_FREEBSD_cystop
#define cywrite FDEV_FREEBSD_cywrite
#define dc_list FDEV_FREEBSD_dc_list
#define dev_attach FDEV_FREEBSD_dev_attach
#define dev_detach FDEV_FREEBSD_dev_detach
#define dev_shutdownall FDEV_FREEBSD_dev_shutdownall
#define dev_sysctl FDEV_FREEBSD_dev_sysctl
#define domain_set FDEV_FREEBSD_domain_set
#define domaininit FDEV_FREEBSD_domaininit
#define domains FDEV_FREEBSD_domains
#define endtsleep FDEV_FREEBSD_endtsleep
#define enodev FDEV_FREEBSD_enodev
#define enoioctl FDEV_FREEBSD_enoioctl
#define enosys FDEV_FREEBSD_enosys
#define enxio FDEV_FREEBSD_enxio
#define eopnotsupp FDEV_FREEBSD_eopnotsupp
#define fillw FDEV_FREEBSD_fillw
#define fkey_tab FDEV_FREEBSD_fkey_tab
#define free FDEV_FREEBSD_free
#define getc FDEV_FREEBSD_getc
#define gsignal FDEV_FREEBSD_gsignal
#define hashinit FDEV_FREEBSD_hashinit
#define hz FDEV_FREEBSD_hz
#define hzto FDEV_FREEBSD_hzto
#define if_attach FDEV_FREEBSD_if_attach
#define ifunit FDEV_FREEBSD_ifunit
#define inet_ntoa FDEV_FREEBSD_inet_ntoa
#define inittodr FDEV_FREEBSD_inittodr
#define invalhash FDEV_FREEBSD_invalhash
#define isa_devtab_tty FDEV_FREEBSD_isa_devtab_tty
#define isa_generic_externalize FDEV_FREEBSD_isa_generic_externalize
#define isa_irq_pending FDEV_FREEBSD_isa_irq_pending
#define kdc_cx FDEV_FREEBSD_kdc_cx
#define kdc_isa0 FDEV_FREEBSD_kdc_isa0
#define kernel_map FDEV_FREEBSD_kernel_map
#define key_map FDEV_FREEBSD_key_map
#define kmem_alloc FDEV_FREEBSD_kmem_alloc
#define kmem_free FDEV_FREEBSD_kmem_free
#define kmem_malloc FDEV_FREEBSD_kmem_malloc
#define kmem_map FDEV_FREEBSD_kmem_map
#define kmem_suballoc FDEV_FREEBSD_kmem_suballoc
#define kmembase FDEV_FREEBSD_kmembase
#define kmemlimit FDEV_FREEBSD_kmemlimit
#define kmemstats FDEV_FREEBSD_kmemstats
#define kmemusage FDEV_FREEBSD_kmemusage
#define lbolt FDEV_FREEBSD_lbolt
#define ldisc_deregister FDEV_FREEBSD_ldisc_deregister
#define ldisc_register FDEV_FREEBSD_ldisc_register
#define linesw FDEV_FREEBSD_linesw
#define load_palette FDEV_FREEBSD_load_palette
#define localdomain FDEV_FREEBSD_localdomain
#define lock_region FDEV_FREEBSD_lock_region
#define log FDEV_FREEBSD_log
#define lptclose FDEV_FREEBSD_lptclose
#define lptdriver FDEV_FREEBSD_lptdriver
#define lptflag FDEV_FREEBSD_lptflag
#define lptintr FDEV_FREEBSD_lptintr
#define lptioctl FDEV_FREEBSD_lptioctl
#define lptopen FDEV_FREEBSD_lptopen
#define lptwrite FDEV_FREEBSD_lptwrite
#define m_adj FDEV_FREEBSD_m_adj
#define m_cat FDEV_FREEBSD_m_cat
#define m_clalloc FDEV_FREEBSD_m_clalloc
#define m_copyback FDEV_FREEBSD_m_copyback
#define m_copydata FDEV_FREEBSD_m_copydata
#define m_copym FDEV_FREEBSD_m_copym
#define m_devget FDEV_FREEBSD_m_devget
#define m_free FDEV_FREEBSD_m_free
#define m_freem FDEV_FREEBSD_m_freem
#define m_get FDEV_FREEBSD_m_get
#define m_getclr FDEV_FREEBSD_m_getclr
#define m_gethdr FDEV_FREEBSD_m_gethdr
#define m_prepend FDEV_FREEBSD_m_prepend
#define m_pullup FDEV_FREEBSD_m_pullup
#define m_reclaim FDEV_FREEBSD_m_reclaim
#define m_retry FDEV_FREEBSD_m_retry
#define m_retryhdr FDEV_FREEBSD_m_retryhdr
#define m_split FDEV_FREEBSD_m_split
#define malloc FDEV_FREEBSD_malloc
#define max_datalen FDEV_FREEBSD_max_datalen
#define max_hdr FDEV_FREEBSD_max_hdr
#define max_linkhdr FDEV_FREEBSD_max_linkhdr
#define max_protohdr FDEV_FREEBSD_max_protohdr
#define mb_map FDEV_FREEBSD_mb_map
#define mb_map_full FDEV_FREEBSD_mb_map_full
#define mbinit FDEV_FREEBSD_mbinit
#define mbstat FDEV_FREEBSD_mbstat
#define mbtypes FDEV_FREEBSD_mbtypes
#define mbutl FDEV_FREEBSD_mbutl
#define mclfree FDEV_FREEBSD_mclfree
#define mclrefcnt FDEV_FREEBSD_mclrefcnt
#define memcmp FDEV_FREEBSD_memcmp
#define memname FDEV_FREEBSD_memname
#define microtime FDEV_FREEBSD_microtime
#define mono_time FDEV_FREEBSD_mono_time
#define mse_sc FDEV_FREEBSD_mse_sc
#define mse_types FDEV_FREEBSD_mse_types
#define mseclose FDEV_FREEBSD_mseclose
#define msedriver FDEV_FREEBSD_msedriver
#define mseintr FDEV_FREEBSD_mseintr
#define mseopen FDEV_FREEBSD_mseopen
#define mseread FDEV_FREEBSD_mseread
#define mseselect FDEV_FREEBSD_mseselect
#define ncallout FDEV_FREEBSD_ncallout
#define nchrdev FDEV_FREEBSD_nchrdev
#define ndflush FDEV_FREEBSD_ndflush
#define net_sysctl FDEV_FREEBSD_net_sysctl
#define netcls FDEV_FREEBSD_netcls
#define netcon FDEV_FREEBSD_netcon
#define netio FDEV_FREEBSD_netio
#define nextc FDEV_FREEBSD_nextc
#define nlinesw FDEV_FREEBSD_nlinesw
#define nmbclusters FDEV_FREEBSD_nmbclusters
#define none_saver FDEV_FREEBSD_none_saver
#define nrc_tty FDEV_FREEBSD_nrc_tty
#define nsccons FDEV_FREEBSD_nsccons
#define nullioctl FDEV_FREEBSD_nullioctl
#define nullop FDEV_FREEBSD_nullop
#define ops FDEV_FREEBSD_ops
#define opt_async_dflt FDEV_FREEBSD_opt_async_dflt
#define opt_bisync_dflt FDEV_FREEBSD_opt_bisync_dflt
#define opt_hdlc_dflt FDEV_FREEBSD_opt_hdlc_dflt
#define opt_x21_dflt FDEV_FREEBSD_opt_x21_dflt
#define oskit_cpl FDEV_FREEBSD_oskit_cpl
#define palette FDEV_FREEBSD_palette
#define pccncheckc FDEV_FREEBSD_pccncheckc
#define pccngetc FDEV_FREEBSD_pccngetc
#define pccninit FDEV_FREEBSD_pccninit
#define pccnprobe FDEV_FREEBSD_pccnprobe
#define pccnputc FDEV_FREEBSD_pccnputc
#define pfctlinput FDEV_FREEBSD_pfctlinput
#define pffasttimo FDEV_FREEBSD_pffasttimo
#define pffindproto FDEV_FREEBSD_pffindproto
#define pffindtype FDEV_FREEBSD_pffindtype
#define pfind FDEV_FREEBSD_pfind
#define pfslowtimo FDEV_FREEBSD_pfslowtimo
#define pgsignal FDEV_FREEBSD_pgsignal
#define phashinit FDEV_FREEBSD_phashinit
#define proc0 FDEV_FREEBSD_proc0
#define psignal FDEV_FREEBSD_psignal
#define psm_poll_status FDEV_FREEBSD_psm_poll_status
#define psmattach FDEV_FREEBSD_psmattach
#define psmclose FDEV_FREEBSD_psmclose
#define psmdriver FDEV_FREEBSD_psmdriver
#define psmintr FDEV_FREEBSD_psmintr
#define psmioctl FDEV_FREEBSD_psmioctl
#define psmopen FDEV_FREEBSD_psmopen
#define psmprobe FDEV_FREEBSD_psmprobe
#define psmread FDEV_FREEBSD_psmread
#define psmselect FDEV_FREEBSD_psmselect
#define putc FDEV_FREEBSD_putc
#define q_to_b FDEV_FREEBSD_q_to_b
#define random FDEV_FREEBSD_random
#define rc_tty FDEV_FREEBSD_rc_tty
#define rcattach FDEV_FREEBSD_rcattach
#define rcclose FDEV_FREEBSD_rcclose
#define rcdevtotty FDEV_FREEBSD_rcdevtotty
#define rcdriver FDEV_FREEBSD_rcdriver
#define rcintr FDEV_FREEBSD_rcintr
#define rcioctl FDEV_FREEBSD_rcioctl
#define rcopen FDEV_FREEBSD_rcopen
#define rcpoll FDEV_FREEBSD_rcpoll
#define rcprobe FDEV_FREEBSD_rcprobe
#define rcread FDEV_FREEBSD_rcread
#define rcstop FDEV_FREEBSD_rcstop
#define rcwrite FDEV_FREEBSD_rcwrite
#define release_timer2 FDEV_FREEBSD_release_timer2
#define resettodr FDEV_FREEBSD_resettodr
#define revert FDEV_FREEBSD_revert
#define route_cb FDEV_FREEBSD_route_cb
#define rt_tables FDEV_FREEBSD_rt_tables
#define rtstat FDEV_FREEBSD_rtstat
#define safepri FDEV_FREEBSD_safepri
#define sb_efficiency FDEV_FREEBSD_sb_efficiency
#define sb_lock FDEV_FREEBSD_sb_lock
#define sb_max FDEV_FREEBSD_sb_max
#define sbappend FDEV_FREEBSD_sbappend
#define sbappendaddr FDEV_FREEBSD_sbappendaddr
#define sbappendcontrol FDEV_FREEBSD_sbappendcontrol
#define sbappendrecord FDEV_FREEBSD_sbappendrecord
#define sbcompress FDEV_FREEBSD_sbcompress
#define sbdrop FDEV_FREEBSD_sbdrop
#define sbdroprecord FDEV_FREEBSD_sbdroprecord
#define sbflush FDEV_FREEBSD_sbflush
#define sbinsertoob FDEV_FREEBSD_sbinsertoob
#define sbrelease FDEV_FREEBSD_sbrelease
#define sbreserve FDEV_FREEBSD_sbreserve
#define sbwait FDEV_FREEBSD_sbwait
#define scanc FDEV_FREEBSD_scanc
#define scattach FDEV_FREEBSD_scattach
#define scclose FDEV_FREEBSD_scclose
#define sccons FDEV_FREEBSD_sccons
#define scdevtotty FDEV_FREEBSD_scdevtotty
#define scdriver FDEV_FREEBSD_scdriver
#define schedcpu FDEV_FREEBSD_schedcpu
#define scintr FDEV_FREEBSD_scintr
#define scioctl FDEV_FREEBSD_scioctl
#define scmmap FDEV_FREEBSD_scmmap
#define scopen FDEV_FREEBSD_scopen
#define scparam FDEV_FREEBSD_scparam
#define scprobe FDEV_FREEBSD_scprobe
#define scr_map FDEV_FREEBSD_scr_map
#define scread FDEV_FREEBSD_scread
#define scrn_blanked FDEV_FREEBSD_scrn_blanked
#define scstart FDEV_FREEBSD_scstart
#define scwrite FDEV_FREEBSD_scwrite
#define securelevel FDEV_FREEBSD_securelevel
#define seek FDEV_FREEBSD_seek
#define selrecord FDEV_FREEBSD_selrecord
#define selwakeup FDEV_FREEBSD_selwakeup
#define set_border FDEV_FREEBSD_set_border
#define setsize FDEV_FREEBSD_setsize
#define shutdown_nice FDEV_FREEBSD_shutdown_nice
#define si_download FDEV_FREEBSD_si_download
#define si_dsize FDEV_FREEBSD_si_dsize
#define si_registerdev FDEV_FREEBSD_si_registerdev
#define si_softc FDEV_FREEBSD_si_softc
#define siattach FDEV_FREEBSD_siattach
#define siclose FDEV_FREEBSD_siclose
#define sidevtotty FDEV_FREEBSD_sidevtotty
#define sidriver FDEV_FREEBSD_sidriver
#define siintr FDEV_FREEBSD_siintr
#define siioctl FDEV_FREEBSD_siioctl
#define sioclose FDEV_FREEBSD_sioclose
#define siocncheckc FDEV_FREEBSD_siocncheckc
#define siocngetc FDEV_FREEBSD_siocngetc
#define siocninit FDEV_FREEBSD_siocninit
#define siocnprobe FDEV_FREEBSD_siocnprobe
#define siocnputc FDEV_FREEBSD_siocnputc
#define siodevtotty FDEV_FREEBSD_siodevtotty
#define siodriver FDEV_FREEBSD_siodriver
#define siointr FDEV_FREEBSD_siointr
#define siointrts FDEV_FREEBSD_siointrts
#define sioioctl FDEV_FREEBSD_sioioctl
#define sioopen FDEV_FREEBSD_sioopen
#define siopen FDEV_FREEBSD_siopen
#define siopoll FDEV_FREEBSD_siopoll
#define sioread FDEV_FREEBSD_sioread
#define siostop FDEV_FREEBSD_siostop
#define siowrite FDEV_FREEBSD_siowrite
#define siparam FDEV_FREEBSD_siparam
#define siprobe FDEV_FREEBSD_siprobe
#define siread FDEV_FREEBSD_siread
#define sistop FDEV_FREEBSD_sistop
#define siwrite FDEV_FREEBSD_siwrite
#define slpque FDEV_FREEBSD_slpque
#define soabort FDEV_FREEBSD_soabort
#define soaccept FDEV_FREEBSD_soaccept
#define sobind FDEV_FREEBSD_sobind
#define socantrcvmore FDEV_FREEBSD_socantrcvmore
#define socantsendmore FDEV_FREEBSD_socantsendmore
#define socketops FDEV_FREEBSD_socketops
#define soclose FDEV_FREEBSD_soclose
#define soconnect FDEV_FREEBSD_soconnect
#define soconnect2 FDEV_FREEBSD_soconnect2
#define socreate FDEV_FREEBSD_socreate
#define sodisconnect FDEV_FREEBSD_sodisconnect
#define sofree FDEV_FREEBSD_sofree
#define softclock FDEV_FREEBSD_softclock
#define sogetopt FDEV_FREEBSD_sogetopt
#define sohasoutofband FDEV_FREEBSD_sohasoutofband
#define soisconnected FDEV_FREEBSD_soisconnected
#define soisconnecting FDEV_FREEBSD_soisconnecting
#define soisdisconnected FDEV_FREEBSD_soisdisconnected
#define soisdisconnecting FDEV_FREEBSD_soisdisconnecting
#define solisten FDEV_FREEBSD_solisten
#define somaxconn FDEV_FREEBSD_somaxconn
#define sominqueue FDEV_FREEBSD_sominqueue
#define sonewconn1 FDEV_FREEBSD_sonewconn1
#define soo_close FDEV_FREEBSD_soo_close
#define soo_ioctl FDEV_FREEBSD_soo_ioctl
#define soo_read FDEV_FREEBSD_soo_read
#define soo_select FDEV_FREEBSD_soo_select
#define soo_stat FDEV_FREEBSD_soo_stat
#define soo_write FDEV_FREEBSD_soo_write
#define soqinsque FDEV_FREEBSD_soqinsque
#define soqremque FDEV_FREEBSD_soqremque
#define soreceive FDEV_FREEBSD_soreceive
#define soreserve FDEV_FREEBSD_soreserve
#define sorflush FDEV_FREEBSD_sorflush
#define sosend FDEV_FREEBSD_sosend
#define sosetopt FDEV_FREEBSD_sosetopt
#define soshutdown FDEV_FREEBSD_soshutdown
#define sowakeup FDEV_FREEBSD_sowakeup
#define spin_n_seconds FDEV_FREEBSD_spin_n_seconds
#define sppp_attach FDEV_FREEBSD_sppp_attach
#define sppp_dequeue FDEV_FREEBSD_sppp_dequeue
#define sppp_detach FDEV_FREEBSD_sppp_detach
#define sppp_flush FDEV_FREEBSD_sppp_flush
#define sppp_input FDEV_FREEBSD_sppp_input
#define sppp_ioctl FDEV_FREEBSD_sppp_ioctl
#define sppp_isempty FDEV_FREEBSD_sppp_isempty
#define sppp_output FDEV_FREEBSD_sppp_output
#define stat FDEV_FREEBSD_stat
#define subyte FDEV_FREEBSD_subyte
#define suibyte FDEV_FREEBSD_suibyte
#define suser FDEV_FREEBSD_suser
#define sysbeep FDEV_FREEBSD_sysbeep
#define sysctl_int FDEV_FREEBSD_sysctl_int
#define sysctl_rdint FDEV_FREEBSD_sysctl_rdint
#define sysctl_rdstruct FDEV_FREEBSD_sysctl_rdstruct
#define termioschars FDEV_FREEBSD_termioschars
#define tick FDEV_FREEBSD_tick
#define ticks FDEV_FREEBSD_ticks
#define time FDEV_FREEBSD_time
#define timeout FDEV_FREEBSD_timeout
#define tk_cancc FDEV_FREEBSD_tk_cancc
#define tk_nin FDEV_FREEBSD_tk_nin
#define tk_nout FDEV_FREEBSD_tk_nout
#define tk_rawcc FDEV_FREEBSD_tk_rawcc
#define tputchar FDEV_FREEBSD_tputchar
#define tsleep FDEV_FREEBSD_tsleep
#define ttioctl FDEV_FREEBSD_ttioctl
#define ttread FDEV_FREEBSD_ttread
#define ttrstrt FDEV_FREEBSD_ttrstrt
#define ttselect FDEV_FREEBSD_ttselect
#define ttsetwater FDEV_FREEBSD_ttsetwater
#define ttspeedtab FDEV_FREEBSD_ttspeedtab
#define ttstart FDEV_FREEBSD_ttstart
#define ttwakeup FDEV_FREEBSD_ttwakeup
#define ttwrite FDEV_FREEBSD_ttwrite
#define ttwwakeup FDEV_FREEBSD_ttwwakeup
#define ttyblock FDEV_FREEBSD_ttyblock
#define ttychars FDEV_FREEBSD_ttychars
#define ttyclose FDEV_FREEBSD_ttyclose
#define ttyflush FDEV_FREEBSD_ttyflush
#define ttyinfo FDEV_FREEBSD_ttyinfo
#define ttyinput FDEV_FREEBSD_ttyinput
#define ttylclose FDEV_FREEBSD_ttylclose
#define ttymalloc FDEV_FREEBSD_ttymalloc
#define ttymodem FDEV_FREEBSD_ttymodem
#define ttyopen FDEV_FREEBSD_ttyopen
#define ttyselect FDEV_FREEBSD_ttyselect
#define ttysleep FDEV_FREEBSD_ttysleep
#define ttywait FDEV_FREEBSD_ttywait
#define ttywflush FDEV_FREEBSD_ttywflush
#define uiomove FDEV_FREEBSD_uiomove
#define unlock_region FDEV_FREEBSD_unlock_region
#define unputc FDEV_FREEBSD_unputc
#define unsleep FDEV_FREEBSD_unsleep
#define untimeout FDEV_FREEBSD_untimeout
#define ureadc FDEV_FREEBSD_ureadc
#define wakeup FDEV_FREEBSD_wakeup
#define register_swi FDEV_FREEBSD_register_swi
#define swi_dispatcher FDEV_FREEBSD_swi_dispatcher
#define swi_check FDEV_FREEBSD_swi_check
#define ttyconds FDEV_FREEBSD_ttyconds

#endif /* _FREEBSD_DEV_GLOBAL_H_ */
