/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.demos;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.javagroups.ChannelFactory;
import org.javagroups.JChannelFactory;
import org.javagroups.blocks.DistributedQueue;
import org.javagroups.log.Trace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DistributedQueueDemo
extends Frame
implements WindowListener,
ActionListener,
DistributedQueue.Notification {
    DistributedQueue h;
    JButton add;
    JButton quit;
    JButton get_all;
    JButton remove;
    JLabel value;
    JLabel err_msg;
    JTextField value_field;
    List listbox;
    final Font default_font;

    private final void showMsg(String msg) {
        this.err_msg.setText(msg);
        this.err_msg.setVisible(true);
    }

    private final void clearMsg() {
        this.err_msg.setVisible(false);
    }

    private final void removeItem() {
        this.h.remove();
    }

    private final void showAll() {
        if (this.listbox.getItemCount() > 0) {
            this.listbox.removeAll();
        }
        if (this.h.size() == 0) {
            return;
        }
        this.clearMsg();
        Vector v = this.h.getContents();
        int i = 0;
        while (i < v.size()) {
            this.listbox.add((String)v.elementAt(i));
            ++i;
        }
    }

    public void start(String groupname, ChannelFactory factory, String props) {
        Trace.init();
        this.h = new DistributedQueue(groupname, factory, props, 10000L);
        this.h.addNotifier(this);
        this.setLayout(null);
        this.setSize(400, 300);
        this.setFont(this.default_font);
        this.value.setBounds(new Rectangle(10, 60, 60, 30));
        this.value_field.setBounds(new Rectangle(100, 60, 100, 30));
        this.listbox.setBounds(new Rectangle(210, 30, 150, 160));
        this.err_msg.setBounds(new Rectangle(10, 200, 350, 30));
        this.err_msg.setFont(new Font("Helvetica", 2, 12));
        this.err_msg.setForeground(Color.red);
        this.err_msg.setVisible(false);
        this.add.setBounds(new Rectangle(60, 250, 60, 30));
        this.quit.setBounds(new Rectangle(130, 250, 70, 30));
        this.get_all.setBounds(new Rectangle(210, 250, 60, 30));
        this.remove.setBounds(new Rectangle(280, 250, 90, 30));
        this.add.addActionListener(this);
        this.quit.addActionListener(this);
        this.get_all.addActionListener(this);
        this.remove.addActionListener(this);
        this.add(this.value);
        this.add(this.value_field);
        this.add(this.err_msg);
        this.add(this.add);
        this.add(this.quit);
        this.add(this.get_all);
        this.add(this.remove);
        this.add(this.listbox);
        this.setTitle("DistributedQueue Demo");
        this.showAll();
        this.pack();
        this.setVisible(true);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        try {
            if (command == "Add") {
                String value_name = this.value_field.getText();
                if (value_name == null || value_name.length() == 0) {
                    this.showMsg("Value is empty !");
                    return;
                }
                this.showMsg("Adding value " + value_name + ':');
                this.h.add(value_name);
            } else if (command == "All") {
                this.showAll();
            } else if (command == "Quit") {
                this.setVisible(false);
                System.exit(0);
            } else if (command == "Remove") {
                this.removeItem();
            } else {
                System.out.println("Unknown action");
            }
        }
        catch (Exception ex) {
            this.value_field.setText("");
            this.showMsg(ex.toString());
        }
    }

    public void entryAdd(Object value) {
        this.showAll();
    }

    public void entryRemoved(Object key) {
        this.showAll();
    }

    public void viewChange(Vector joined, Vector left) {
        System.out.println("New members: " + joined + ", left members: " + left);
    }

    public static void main(String[] args) {
        String groupname = "QueueDemo";
        DistributedQueueDemo client = new DistributedQueueDemo();
        JChannelFactory factory = new JChannelFactory();
        boolean trace = false;
        boolean persist = false;
        String props = "UDP(mcast_addr=228.8.8.8;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):UNICAST(timeout=5000):FRAG(frag_size=8192;down_thread=false;up_thread=false):TOTAL_TOKEN(block_sending=50;unblock_sending=10):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):STATE_TRANSFER:QUEUE";
        try {
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.equals("-trace")) {
                    trace = true;
                } else if (args[i].equals("-groupname")) {
                    groupname = args[++i];
                } else {
                    DistributedQueueDemo.help();
                    return;
                }
                ++i;
            }
        }
        catch (Exception e) {
            DistributedQueueDemo.help();
            return;
        }
        client.start(groupname, factory, props);
    }

    static void help() {
        System.out.println("DistributedQueueDemo [-help]");
    }

    private final /* synthetic */ void this() {
        this.h = null;
        this.add = new JButton("Add");
        this.quit = new JButton("Quit");
        this.get_all = new JButton("All");
        this.remove = new JButton("Remove");
        this.value = new JLabel("Value");
        this.err_msg = new JLabel("Error");
        this.value_field = new JTextField();
        this.listbox = new List();
        this.default_font = new Font("Helvetica", 0, 12);
    }

    public DistributedQueueDemo() {
        this.this();
        this.addWindowListener(this);
    }
}

