#ifndef __SCHEMATIC_VIEW_UI_H
#define __SCHEMATIC_VIEW_UI_H

/*
 * File menu.
 */
static GnomeUIInfo schematic_menu_file [] = {
        GNOMEUIINFO_MENU_NEW_ITEM(N_("_New"), N_("Create a new schematic"), new_cmd, NULL), 
	GNOMEUIINFO_MENU_OPEN_ITEM(open_cmd, NULL), 
	GNOMEUIINFO_MENU_SAVE_ITEM(save_cmd, NULL), 
	GNOMEUIINFO_MENU_SAVE_AS_ITEM(save_as_cmd, NULL), 

	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_MENU_PRINT_ITEM(print_cmd, NULL), 

	{ GNOME_APP_UI_ITEM, 
	  N_("Print Preview"),
	  N_("Preview the schematic before printing"), 
	  print_preview_cmd, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT,
	  0, 0, NULL },


	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("Schematic _Properties..."),
	  N_("Modify the schematic's properties"), 
	  NULL, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_MENU_CLOSE_ITEM(close_cmd, NULL), 
	GNOMEUIINFO_MENU_EXIT_ITEM(quit_cmd, NULL),
	GNOMEUIINFO_END
};

/*
 * Edit menu.
 */
static GnomeUIInfo schematic_menu_edit [] = {

	GNOMEUIINFO_MENU_UNDO_ITEM(NULL, NULL),
	GNOMEUIINFO_MENU_REDO_ITEM(NULL, NULL),

	GNOMEUIINFO_SEPARATOR,

        GNOMEUIINFO_MENU_CUT_ITEM(cut_cmd, NULL),
	GNOMEUIINFO_MENU_COPY_ITEM(copy_cmd, NULL),
	GNOMEUIINFO_MENU_PASTE_ITEM(paste_cmd, NULL),

	GNOMEUIINFO_SEPARATOR,

        { GNOME_APP_UI_ITEM, 
	  N_("_Delete"),
	  N_("Delete the selection"), 
	  delete_cmd, NULL, NULL, 
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLEAR, 
	  'd', GDK_CONTROL_MASK, NULL },

        { GNOME_APP_UI_ITEM, 
	  N_("_Rotate"),
	  N_("Rotate the selection clockwise"), 
	  rotate_cmd, NULL, NULL, 
	  GNOME_APP_PIXMAP_STOCK, STOCK_PIXMAP_ROTATE, 
	  'r', GDK_CONTROL_MASK, NULL },
        
        { GNOME_APP_UI_ITEM, 
	  N_("_Flip horizontally"),
	  N_("Flip the selection horizontally"), 
	  flip_horizontal_cmd, NULL, NULL, 
	  GNOME_APP_PIXMAP_STOCK, STOCK_PIXMAP_ROTATE, 
	  'f', GDK_CONTROL_MASK, NULL },

        { GNOME_APP_UI_ITEM, 
	  N_("_Flip vertically"),
	  N_("Flip the selection vertically"), 
	  flip_vertical_cmd, NULL, NULL, 
	  GNOME_APP_PIXMAP_STOCK, STOCK_PIXMAP_ROTATE, 
	  'f', GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
        
	GNOMEUIINFO_SEPARATOR,

        { GNOME_APP_UI_ITEM, 
	  N_("Select _all"),
	  N_("Select all objects on the sheet"), 
	  select_all_cmd, NULL, NULL, 
	  GNOME_APP_PIXMAP_NONE, NULL,
	  'a', GDK_CONTROL_MASK, NULL },

        { GNOME_APP_UI_ITEM, 
	  N_("_Deselect all"),
	  N_("Deselect the selected objects"), 
	  deselect_all_cmd, NULL, NULL, 
	  GNOME_APP_PIXMAP_NONE, NULL,
	  'a', GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("Object _Properties..."),
	  N_("Modify the object's properties"), 
	  object_properties_cmd, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP,
	  'e', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_END
};

/* 
 * Tools.
 */
static GnomeUIInfo schematic_menu_tools [] = {

	{ GNOME_APP_UI_ITEM, 
	  N_("_Simulate"),
	  N_("Run a simulation"), 
	  simulate_cmd, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXEC,
	  GDK_F10, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, N_("_Generate netlist"),
	  N_("Generate a netlist"), netlist_cmd, NULL, 
	  NULL, 0, 0, 0, 0 },

	GNOMEUIINFO_END
};

/*
 * Zoom subtree.
 */
static GnomeUIInfo schematic_menu_zoom [] = {
	GNOMEUIINFO_ITEM_NONE(N_("50%"), N_("Set the zoom factor to 50%"), zoom_50_cmd),
	GNOMEUIINFO_ITEM_NONE(N_("75%"), N_("Set the zoom factor to 75%"), zoom_75_cmd),
	{ GNOME_APP_UI_ITEM, N_("100%"), N_("Set the zoom factor to 100%"), zoom_100_cmd, NULL, NULL, 0, 0, '1', 0 },
	GNOMEUIINFO_ITEM_NONE(N_("125%"), N_("Set the zoom factor to 125%"), zoom_125_cmd),
	GNOMEUIINFO_ITEM_NONE(N_("150%"), N_("Set the zoom factor to 150%"), zoom_150_cmd),
/*	GNOMEUIINFO_ITEM_NONE(N_("Custom..."), N_("Set the zoom factor to a custom value"), zoom_custom_cmd),*/
	GNOMEUIINFO_END
};

/* 
 * View menu.
 */
static GnomeUIInfo schematic_menu_view [] = {
	{ GNOME_APP_UI_SUBTREE, N_("Zoom"), NULL, schematic_menu_zoom, NULL, NULL, \
	  GNOME_APP_PIXMAP_DATA, menu_zoom_xpm, 0, (GdkModifierType) 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_ITEM (N_("_Log"), N_("View the latest simulation log"), log_cmd, log_xpm),

	GNOMEUIINFO_ITEM (N_("_Plot"), N_("View the latest plot"), NULL, plot_xpm),

	{ GNOME_APP_UI_ITEM, N_("_Netlist"),
	  N_("View the latest simulated netlist"), NULL, NULL, 
	  NULL, 0, 0, 0, 0 },

	GNOMEUIINFO_END
};

/*
 * Settings menu.
 */
static GnomeUIInfo schematic_menu_settings [] = {
	GNOMEUIINFO_MENU_PREFERENCES_ITEM (settings_show, NULL),

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, N_("Simulation S_ettings..."),
	  N_("Edit the simulation settings"), sim_settings_show, NULL,
	  NULL, 0, 0, 0, 0 },

	GNOMEUIINFO_END
};

/*
 * Help menu.
 */
static GnomeUIInfo schematic_menu_help [] = {
	GNOMEUIINFO_HELP ("oregano"),
	GNOMEUIINFO_SEPARATOR,
        GNOMEUIINFO_MENU_ABOUT_ITEM(about_cmd, NULL),
	GNOMEUIINFO_END
};

/*
 * Main menu structure.
 */
static GnomeUIInfo schematic_menu [] = {
        GNOMEUIINFO_MENU_FILE_TREE(schematic_menu_file),
	GNOMEUIINFO_MENU_EDIT_TREE(schematic_menu_edit),
	GNOMEUIINFO_MENU_VIEW_TREE(schematic_menu_view),
	GNOMEUIINFO_SUBTREE(N_("_Tools"), schematic_menu_tools),
	GNOMEUIINFO_MENU_SETTINGS_TREE(schematic_menu_settings),
	GNOMEUIINFO_MENU_HELP_TREE(schematic_menu_help),
	GNOMEUIINFO_END
};

/*
 *  Toolbars.
 */
static GnomeUIInfo schematic_standard_toolbar [] = {
	GNOMEUIINFO_ITEM_STOCK (
		N_("New"), N_("Create a new schematic"),
		new_cmd, GNOME_STOCK_PIXMAP_NEW),
	GNOMEUIINFO_ITEM_STOCK (
		N_("Open"), N_("Open an existing schematic"),
		open_cmd, GNOME_STOCK_PIXMAP_OPEN),
	GNOMEUIINFO_ITEM_STOCK (
		N_("Save"), N_("Save the schematic"),
		save_cmd, GNOME_STOCK_PIXMAP_SAVE),

	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_ITEM_STOCK (
		N_("Undo"), N_("Undo"),
		NULL, GNOME_STOCK_PIXMAP_UNDO),
	GNOMEUIINFO_ITEM_STOCK (
		N_("Redo"), N_("Redo"),
		NULL, GNOME_STOCK_PIXMAP_REDO),

	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_ITEM_STOCK (
		N_("Cut"), N_("Cut the selection to the clipboard"),
		cut_cmd, GNOME_STOCK_PIXMAP_CUT),
	GNOMEUIINFO_ITEM_STOCK (
		N_("Copy"), N_("Copy the selection to the clipboard"),
		copy_cmd, GNOME_STOCK_PIXMAP_COPY),
	GNOMEUIINFO_ITEM_STOCK (
		N_("Paste"), N_("Paste the clipboard"),
		paste_cmd, GNOME_STOCK_PIXMAP_PASTE),

	GNOMEUIINFO_END
};


static GnomeUIInfo tools_group [] = {

	{ GNOME_APP_UI_ITEM, 
	  N_("Arrow"), 
	  N_("Select, move and modify objects"), 
	  arrow_cmd, NULL, NULL, 
	  GNOME_APP_PIXMAP_STOCK, STOCK_PIXMAP_ARROW },

	{ GNOME_APP_UI_ITEM, 
	  N_("Text"), 
	  N_("Put text on the schematic"), 
	  text_cmd, NULL, NULL, 
	  GNOME_APP_PIXMAP_STOCK, STOCK_PIXMAP_TEXT },

	{ GNOME_APP_UI_ITEM, 
	  N_("Wires"), 
	  N_("Draw wires"), 
	  wire_cmd, NULL, NULL, 
	  GNOME_APP_PIXMAP_STOCK, STOCK_PIXMAP_WIRE },
	
	GNOMEUIINFO_END
};

static GnomeUIInfo schematic_tools_toolbar [] = {

	GNOMEUIINFO_RADIOLIST(tools_group),

	GNOMEUIINFO_END
};

static GnomeUIInfo schematic_simulation_toolbar [] = {

	GNOMEUIINFO_ITEM_STOCK (
		N_("Simulate"), 
		N_("Run a simulation for the current schematic"), 
		simulate_cmd,
		GNOME_STOCK_PIXMAP_EXEC),

	GNOMEUIINFO_ITEM_STOCK (
		N_("Simulation settings"), 
		N_("Simulation settings"), 
		sim_settings_show,
	        STOCK_PIXMAP_SIM_SETTINGS),

	GNOMEUIINFO_ITEM_STOCK (
		N_("View plot"), 
		N_("View plot "),
		NULL,
		STOCK_PIXMAP_PLOT),

	GNOMEUIINFO_END
};

static GnomeUIInfo schematic_view_toolbar [] = {

	GNOMEUIINFO_ITEM_STOCK (
		N_("Parts"), 
		N_("Show or hide the part browser"), 
		part_browser_cmd,
		STOCK_PIXMAP_PART_BROWSER),

	{ GNOME_APP_UI_TOGGLEITEM, 
	  N_("Grid"), 
	  N_("Turn on/off the grid"), 
	  grid_toggle_snap_cmd, NULL, NULL, 
	  GNOME_APP_PIXMAP_STOCK, STOCK_PIXMAP_GRID },

	GNOMEUIINFO_ITEM_STOCK (
		N_("Zoom in"), 
		N_("Zoom in"), 
		zoom_in_cmd,
		STOCK_PIXMAP_ZOOM_IN),

	GNOMEUIINFO_ITEM_STOCK (
		N_("Zoom out"), 
		N_("Zoom out"), 
		zoom_out_cmd,
		STOCK_PIXMAP_ZOOM_OUT),

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_TOGGLEITEM, 
	  N_("Voltmeters"), 
	  N_("Enable/disable voltmeters"), 
	  voltmeter_cmd, NULL, NULL, 
	  GNOME_APP_PIXMAP_STOCK, STOCK_PIXMAP_VOLTMETER },	

	GNOMEUIINFO_END
};

/*
 * Right click context menu for the sheet.
 */
static GnomeUIInfo sheet_context_menu [] = {
	{ GNOME_APP_UI_ITEM, N_("Paste"), N_("Paste the contents of the clipboard to the sheet"), paste_cmd, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PASTE, 0, 0 },

	GNOMEUIINFO_END
};

#endif
