###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_winamp_genff_bof_vuln.nasl 2479 2009-06-01 13:26:38Z june $
#
# Winamp gen_ff.dll Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900552);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1831");
  script_bugtraq_id(35052);
  script_name("Winamp gen_ff.dll Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is installed with Winamp and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  The vulnerability exists in the gen_ff.dll file which is prone to integer
  overflow due to an incorrect type cast error while processing malicious
  .maki file.

  Impact:
  Attackers may leverage this issue by executing arbitrary codes in the
  context of the affected application via specially crafted .maki files
  and can cause denial of service.

  Impact Level: System/Application

  Affected Software/OS:
  Winamp version 5.55 and prior on Windows.

  Fix: Upgrade to the version 5.552
  http://www.winamp.com/player

  References:
  http://vrt-sourcefire.blogspot.com/2009/05/winamp-maki-parsing-vulnerability.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High ";

  script_description(desc);
  script_summary("Check for the version of Winamp");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_winamp_detect.nasl");
  script_require_keys("Winamp/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

winampVer = get_kb_item("Winamp/Version");
if(!winampVer){
  exit(0);
}

# Check for version 5.55 => 5.5.5.2405 and prior
if(version_is_less_equal(version:winampVer, test_version:"5.5.5.2405"))
{
  winPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                "\App Paths\winamp.exe", item:"Path");
  if(!winPath){
    exit(0);
  }

  winPath =  winPath + "\Plugins\gen_ff.dll";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:winPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:winPath);
  dllSize = get_file_size(share:share, file:file);
  if(dllSize){
    security_hole(0);
  }
}
