###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_wmp_int_overflow_vuln.nasl 1829 2009-04-20 13:48:24Z apr $
#
# Microsoft Windows Media Player MID File Integer Overflow Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900336);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1331");
  script_name("Microsoft Windows Media Player MID File Integer Overflow Vulnerability");
  desc = "

  Overview: The host is installed with Windows Media Player and is prone to
  integer overflow vulnerability.

  Vulnerability Insight:
  This flaw is due to a boundary checking error while processing mid files
  in Windows Media Player application.

  Impact:
  Successful exploitation will lets attacker execute arbitrary codes in
  the context of the affected player and can cause denial of service.

  Impact Level: System/Application

  Affected Software/OS:
  Windows Media Player version 11.0.5721.5145 and prior.

  Fix: No solution or patch is available as on 22nd April, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/windows/windowsmedia/default.mspx

  References:
  http://www.milw0rm.com/exploits/8445

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the Version of Windows Media Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_ms_win_media_player_detect_900173.nasl");
  script_require_keys("Win/MediaPlayer/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");

wmplayerVer = get_kb_item("Win/MediaPlayer/Ver");
if(!wmplayerVer){
  exit(0);
}

# Check for Windows Media Player version 11.0.5721.5145 and prior
if(version_is_less_equal(version:wmplayerVer, test_version:"11.0.5721.5145")){
  security_hole(0);
}
