###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for gdm MDKA-2007:116 (gdm)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830136);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDKA", value: "2007:116");
  script_name( "Mandriva Update for gdm MDKA-2007:116 (gdm)");
  desc = "

  Vulnerability Insight:

  A bug in IPv6 handling prevented gdm from connecting properly to
  IPv4 XDMCP server (Mdv bug #35522).  Default language list in gdm was
  not using UTF-8 as default encoding (#35133).  gdmsetup program was
  always outputing debug information (Mdv bug #34304).  Tab key could
  not be used as Enter when typing username (Mdv bug #31589).
  
  The update package fixes those issues, and provides additional
  translations.

  Affected Software/OS:
  gdm on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00046.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gdm");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"gdm", rpm:"gdm~2.20.1~3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gdm-Xnest", rpm:"gdm-Xnest~2.20.1~3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}