#
#VID ff6519ad-18e5-11df-9bdd-001b2134ef46
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID ff6519ad-18e5-11df-9bdd-001b2134ef46
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66848);
 script_cve_id("CVE-2010-0186", "CVE-2010-0187");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("FreeBSD Ports: linux-flashplugin");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   linux-flashplugin
   linux-f8-flashplugin
   linux-f10-flashplugin

CVE-2010-0186
Cross-domain vulnerability in Adobe Flash Player before 10.0.45.2 and
Adobe AIR before 1.5.3.9130 allows remote attackers to bypass intended
sandbox restrictions and make cross-domain requests via unspecified
vectors.

CVE-2010-0187
Adobe Flash Player before 10.0.45.2 and Adobe AIR before 1.5.3.9130
allow remote attackers to cause a denial of service (application
crash) via a modified SWF file.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.adobe.com/support/security/bulletins/apsb10-06.html
http://www.vuxml.org/freebsd/ff6519ad-18e5-11df-9bdd-001b2134ef46.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: linux-flashplugin");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"linux-flashplugin");
if(!isnull(bver) && revcomp(a:bver, b:"9.0r262")<0) {
    security_note(0, data:"Package linux-flashplugin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-f8-flashplugin");
if(!isnull(bver) && revcomp(a:bver, b:"10.0r45")<0) {
    security_note(0, data:"Package linux-f8-flashplugin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-f10-flashplugin");
if(!isnull(bver) && revcomp(a:bver, b:"10.0r45")<0) {
    security_note(0, data:"Package linux-f10-flashplugin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
