# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 111-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53841);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 111-1 (ucd-snmp)";
 script_name(name);

 desc = "The remote host is missing an update to ucd-snmp
announced via advisory DSA 111-1.

The Secure Programming Group of the Oulu University did a study on
SNMP implementations and uncovered multiple problems which can
cause problems ranging from Denial of Service attacks to remote
exploits.

New UCD-SNMP packages have been prepared to fix these problems
as well as a few others. The complete list of fixed problems is:

* When running external programs snmpd used temporary files insecurely
* snmpd did not properly reset supplementary groups after changing
its uid and gid
* Modified most code to use buffers instead of fixed-length strings to
prevent buffer overflows
* The ASN.1 parser did not check for negative lengths
* the IFINDEX response handling in snmpnetstat did not do a sanity check
on its input

(thanks to Caldera for most of the work on those patches)

The new version is 4.1.1-2.1 and we recommend you upgrade your
snmp packages immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20111-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 111-1 (ucd-snmp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libsnmp4.1-dev", ver:"4.1.1-2.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsnmp4.1", ver:"4.1.1-2.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"snmp", ver:"4.1.1-2.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"snmpd", ver:"4.1.1-2.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
