###############################################################################
# OpenVAS Vulnerability Test
# $Id: AfterLogic_WebMail_Pro_36605.nasl 8097 2010-06-21 13:15:26Z mime $
#
# AfterLogic WebMail Pro Multiple Cross Site Scripting Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100314);
 script_tag(name:"cvss_base", value:"4.3");
 script_cve_id("CVE-2009-4743");
 script_bugtraq_id(36605);
 script_version ("1.0-$Revision: 8097 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("AfterLogic WebMail Pro Multiple Cross Site Scripting Vulnerabilities");

desc = "Overview:
AfterLogic WebMail Pro is prone to multiple cross-site scripting
vulnerabilities because the application fails to sufficiently sanitize
user-supplied data.

Attacker-supplied HTML or JavaScript code could run in the context of
the affected site, potentially allowing the attacker to steal cookie-
based authentication credentials; other attacks are also possible.

AfterLogic WebMail Pro 4.7.10 and prior versions are affected.

Solution:
Reports indicate that the vendor addressed these issues in WebMail Pro
4.7.11, but Symantec has not confirmed this. Please contact the vendor
for more information.

References:
http://www.securityfocus.com/bid/36605
http://www.afterlogic.com/

Risk factor : Low";

 script_description(desc);
 script_summary("Determine if AfterLogic WebMail Pro version is < 4.7.10");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("AfterLogic_WebMail_Pro_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);
if(!can_host_asp(port:port) && !can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/AfterLogicWebMailPro")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "4.7.10")) {
      security_warning(port:port);
      exit(0);
  }
}

exit(0);
