// SWIG file statistics_module.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2012-01-04 12:26:21 +0100 (Wed, 04 Jan 2012) $
// Id : $Id: statistics_module.i 2302 2012-01-04 11:26:21Z schueller $

%module(package="openturns", docstring="Statistical classes.") statistics
%feature("autodoc","1");

%pythoncode %{
def getCorrelationMatrixFromMap(Vars,Map):
  """
  getCorrelationMatrixFromMap(Vars,Map) transform a two-dimension dict whose keys
  are listed in Vars into a CorrelationMatrix. The values are numerical.
  No need to define all the elements in the map since CorrelationMatrix is symmetric.
  Example:
    Vars=['X','Y','Z']
    Map={}
    Map['X']={}
    Map['X']['Y']= 0.1
    Map['X']['Z']= 0.7
    Map['Y']={}
    Map['Y']['Z']= 0.8
    R = getCorrelationMatrixFromMap(Vars,Map)
  """
  Corr = CorrelationMatrix( len(Vars) )
  i=0
  for first in Vars:
    j=0
    for second in Vars:
      if Map.has_key(first) and Map[first].has_key(second):
        Corr[i,j] = Map[first][second]
      j+=1
    i+=1
  return Corr
%}


%{
#include "OTconfig.hxx"
#include "OTCommon.hxx"
#include "OTType.hxx"
#include "OTStat.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

/* Base/Common */
%import common_module.i

/* Wrapper */
%import wrapper_module.i
%import BaseWrapperTemplateDefs.i

/* Base/Type */
%import typ_module.i
%import BaseTypTemplateDefs.i

/* Base/Func */
%import func_module.i
%import BaseFuncTemplateDefs.i

/* Base/Graph */
%import graph_module.i
%import BaseGraphTemplateDefs.i

/* Base / Algo */
%import algo_module.i

/* Base/Stat */
%include CovarianceMatrix.i
%include CorrelationMatrix.i 
%include IdentityMatrix.i 
%include NumericalSample.i 
%include HistoryStrategyImplementation.i 
%include HistoryStrategy.i 
%include Compact.i  
%include Full.i  
%include Last.i  
%include Null.i  
%include ConfidenceInterval.i
%include LinearModel.i  
%include LinearModelFactory.i  
%include TestResult.i  
%include RandomGenerator.i
%include LowDiscrepancySequenceImplementation.i 
%include LowDiscrepancySequence.i 
%include SobolSequence.i 
%include FaureSequence.i 
%include HaltonSequence.i 
%include HaselgroveSequence.i 
%include ReverseHaltonSequence.i 
%include CorrelationAnalysis.i 
%include SensitivityAnalysis.i 
%include TimeSeries.i 
%include ProcessSample.i 
%include FilteringWindowsImplementation.i
%include FilteringWindows.i
%include Hamming.i
%include Hanning.i
%include SpectralModelImplementation.i
%include SpectralModel.i
%include CovarianceModelImplementation.i
%include CovarianceModel.i
%include StationaryCovarianceModel.i
%include SecondOrderModelImplementation.i 
%include ExponentialCauchy.i 
%include SecondOrderModel.i 
%include SpectralModelFactoryImplementation.i
%include SpectralModelFactory.i 
%include UserDefinedSpectralModel.i
%include WelchFactory.i
%include ExponentialModel.i
%include CauchyModel.i

/* At last we include template definitions */
%include BaseStatisticsTemplateDefs.i
