//                                               -*- C++ -*-
/**
 *  @file  UserDefinedFactory.cxx
 *  @brief Factory for UserDefined distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: UserDefinedFactory.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include "UserDefinedFactory.hxx"

BEGIN_NAMESPACE_OPENTURNS


typedef Collection<UserDefinedPair> UserDefinedPairCollection;

/* Default constructor */
UserDefinedFactory::UserDefinedFactory():
  DistributionImplementationFactory()
{
  // Nothing to do
}

/* Virtual constructor */
UserDefinedFactory * UserDefinedFactory::clone() const
{
  return new UserDefinedFactory(*this);
}


/* Here is the interface that all derived class must implement */

UserDefined * UserDefinedFactory::build(const NumericalSample & sample) const
{
  const UnsignedLong size(sample.getSize());
  if (size == 0) throw InvalidArgumentException(HERE) << "Error: cannot build a UserDefined distribution from an empty sample";
  const NumericalScalar p(1.0 / NumericalScalar(size));
  UserDefinedPairCollection support(size);
  for (UnsignedLong i = 0; i < size; ++i)
    {
      support[i].setX(sample[i]);
      support[i].setP(p);
    }
  return UserDefined(support).clone();
}

UserDefined * UserDefinedFactory::build() const
{
  return UserDefined().clone();
}


END_NAMESPACE_OPENTURNS
