//                                               -*- C++ -*-
/**
 *  @file  InverseNatafEllipticalDistributionGradient.cxx
 *  @brief Class for the InverseNataf transformation gradient for elliptical
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: InverseNatafEllipticalDistributionGradient.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include "OTprivate.hxx"
#include "InverseNatafEllipticalDistributionGradient.hxx"
#include "PersistentObjectFactory.hxx"

BEGIN_NAMESPACE_OPENTURNS

/*
 * @class InverseNatafEllipticalDistributionGradient
 *
 * This class offers an interface for the InverseNataf function for elliptical distributions
 */

CLASSNAMEINIT(InverseNatafEllipticalDistributionGradient);

static Factory<InverseNatafEllipticalDistributionGradient> RegisteredFactory("InverseNatafEllipticalDistributionGradient");

/* Default constructor */
InverseNatafEllipticalDistributionGradient::InverseNatafEllipticalDistributionGradient():
  ConstantNumericalMathGradientImplementation()
{
  // Nothing to do
}

/* Parameter constructor */
InverseNatafEllipticalDistributionGradient::InverseNatafEllipticalDistributionGradient(const SquareMatrix & cholesky):
  ConstantNumericalMathGradientImplementation(cholesky.transpose())
{
  // Nothing to do
}

/* String converter */
String InverseNatafEllipticalDistributionGradient::__repr__() const
{
  return OSS() << "class=" << InverseNatafEllipticalDistributionGradient::GetClassName()
               << " cholesky=" << getConstant().transpose();
}

/* Method save() stores the object through the StorageManager */
void InverseNatafEllipticalDistributionGradient::save(Advocate & adv) const
{
  ConstantNumericalMathGradientImplementation::save(adv);
}

/* Method load() reloads the object from the StorageManager */
void InverseNatafEllipticalDistributionGradient::load(Advocate & adv)
{
  ConstantNumericalMathGradientImplementation::load(adv);
}

END_NAMESPACE_OPENTURNS
