//                                               -*- C++ -*-
/**
 *  @file  NonCenteredFiniteDifferenceGradient.hxx
 *  @brief Class for the creation of a numerical math gradient implementation
 *         form a numerical math evaluation implementation by using noncentered
 *         finite difference formula.
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: NonCenteredFiniteDifferenceGradient.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_NONCENTEREDFINITEDIFFERENCEGRADIENT_HXX
#define OPENTURNS_NONCENTEREDFINITEDIFFERENCEGRADIENT_HXX

#include "FiniteDifferenceGradient.hxx"
#include "NumericalMathEvaluationImplementation.hxx"
#include "Pointer.hxx"

BEGIN_NAMESPACE_OPENTURNS




/**
 * @class NonCenteredFiniteDifferenceGradient
 * @brief This class is for the creation of a numerical math gradient implementation
 * @ingroup Function
 *
 * This class is for the creation of a numerical math gradient implementation
 * form a numerical math evaluation implementation by using noncentered
 * finite difference formula
 */
class NonCenteredFiniteDifferenceGradient
  : public FiniteDifferenceGradient
{
  CLASSNAME;
public:

  typedef Pointer<NumericalMathEvaluationImplementation>        EvaluationImplementation;

  /** Default constructor */
  NonCenteredFiniteDifferenceGradient();

  /** Parameter constructor */
  NonCenteredFiniteDifferenceGradient(const NumericalPoint & epsilon,
                                      const EvaluationImplementation & p_evaluation);

  /** Second parameter constructor */
  NonCenteredFiniteDifferenceGradient(const NumericalScalar epsilon,
                                      const EvaluationImplementation & p_evaluation);

  /** Constructor from finite difference step */
  NonCenteredFiniteDifferenceGradient(const FiniteDifferenceStep & step,
                                      const EvaluationImplementation & p_evaluation);

  /** Virtual constructor */
  virtual NonCenteredFiniteDifferenceGradient * clone() const;

  /** String converter */
  virtual String __repr__() const;
  virtual String __str__(const String & offset = "") const;



  /* Here is the interface that all derived class must implement */

  /** This method computes the gradient at some point
   * @param in The point where the gradient is computed
   * @result A matrix constructed with the dF_i/dx_j values (Jacobian transposed)
   */
  virtual Matrix gradient(const NumericalPoint & inP) const;

protected:


private:

}; /* class NonCenteredFiniteDifferenceGradient */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_NONCENTEREDFINITEDIFFERENCEGRADIENT_HXX */
