//                                               -*- C++ -*-
/**
 *  @file  OTCommon.hxx
 *  @brief The external header file of Open TURNS for subdir Common
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-02-11 16:49:59 +0100 (Wed, 11 Feb 2009) $
 *  Id:      $Id: OTCommon.hxx 1129 2009-02-11 15:49:59Z dutka $
 */

#ifndef OPENTURNS_OTCOMMON_HXX
#define OPENTURNS_OTCOMMON_HXX

#include "AtomicFunctions.hxx"
//#include "BinaryStorageManager.hxx"
#include "Catalog.hxx"
#include "ComparisonOperator.hxx"
#include "ComparisonOperatorImplementation.hxx"
#include "Equal.hxx"
#include "Exception.hxx"
#include "Greater.hxx"
#include "GreaterOrEqual.hxx"
#include "IdFactory.hxx"
#include "InterfaceObject.hxx"
#include "Less.hxx"
#include "LessOrEqual.hxx"
#include "Lockable.hxx"
#include "Log.hxx"
#include "Memory.hxx"
#include "MPI.hxx"
#include "Os.hxx"
#include "OSS.hxx"
#include "Object.hxx"
#include "Path.hxx"
#include "PersistentObject.hxx"
#include "PersistentObjectFactory.hxx"
#include "PlatformInfo.hxx"
#include "Pointer.hxx"
#include "ResourceMap.hxx"
#include "SharedPointer.hxx"
#include "StorageManager.hxx"
#include "Study.hxx"
#include "Thread.hxx"
#include "ThreadStatus.hxx"
#include "Threadable.hxx"
#include "TypedCollectionInterfaceObject.hxx"
#include "TypedInterfaceObject.hxx"
//#include "WrapperCommonFunctions.hxx"
#ifdef HAVE_LIBXML2
#include "XMLStorageManager.hxx"
#include "XMLToolbox.hxx"
#include "XMLchar_traits.hxx"
#endif

#endif /* OPENTURNS_OTCOMMON_HXX */
