# - Find Rpy2
# A simple and efficient access to R from Python
# http://rpy.sourceforge.net/rpy2.html
#
# The module defines the following variables:
#  RPY2_FOUND - the system has rpy2
#  RPY2_VERSION_STRING - version (ex. 1.2.3)
#  RPY2_MAJOR_VERSION - major version (ex. 1)
#  RPY2_MINOR_VERSION - minor version (ex. 2)
#  RPY2_PATCH_VERSION - patch version (ex. 3)

#=============================================================================
# Copyright 2005-2012 EDF-EADS-Phimeca
#
# Distributed under the OSI-approved BSD License (the "License");
# see accompanying file Copyright.txt for details.
#
# This software is distributed WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the License for more information.
#=============================================================================
# (To distributed this file outside of CMake, substitute the full
#  License text for the above reference.)

# version
if ( PYTHONINTERP_FOUND )
  execute_process ( COMMAND ${PYTHON_EXECUTABLE} -c "import rpy2; print rpy2.__version__"
                    OUTPUT_VARIABLE RPY2_VERSION_STRING
                    ERROR_QUIET
                    OUTPUT_STRIP_TRAILING_WHITESPACE )

  if ( RPY2_VERSION_STRING )
    string ( REGEX REPLACE "([0-9]+)\\..*" "\\1" RPY2_MAJOR_VERSION ${RPY2_VERSION_STRING} )
    string ( REGEX REPLACE "[0-9]+\\.([0-9]+).*" "\\1" RPY2_MINOR_VERSION ${RPY2_VERSION_STRING} )
    string ( REGEX REPLACE "[0-9]+\\.[0-9]+\\.([0-9]+).*" "\\1" RPY2_PATCH_VERSION ${RPY2_VERSION_STRING} )
  endif ()

endif ()

# check version
set ( _RPY2_VERSION_MATCH TRUE )
if ( Rpy2_FIND_VERSION AND RPY2_VERSION )
  if ( Rpy2_FIND_VERSION_EXACT )
    if ( Rpy2_FIND_VERSION VERSION_EQUAL RPY2_VERSION_STRING )
    else()
      set ( _RPY2_VERSION_MATCH FALSE)
    endif ()
  else ()
    if ( Rpy2_FIND_VERSION VERSION_GREATER RPY2_VERSION_STRING )
      set ( _RPY2_VERSION_MATCH FALSE )
    endif ()
  endif ()
endif ()

# handle REQUIRED and QUIET options
include ( FindPackageHandleStandardArgs )
find_package_handle_standard_args ( Rpy2 DEFAULT_MSG
  RPY2_VERSION_STRING
  _RPY2_VERSION_MATCH
)

mark_as_advanced (
  RPY2_VERSION_STRING
  RPY2_MAJOR_VERSION
  RPY2_MINOR_VERSION
  RPY2_PATCH_VERSION
)
