/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: CntUnoDataContainer.java,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:58:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package mod._cnt;

import java.io.PrintWriter;

import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;

import com.sun.star.container.XIndexContainer;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;

/**
* Test for object which is represented by service
* <code>com.sun.star.cnt.CntUnoDataContainer</code>. <p>
* Object implements the following interfaces :
* <ul>
*  <li> <code>com::sun::star::io::XActiveDataSink</code></li>
*  <li> <code>com::sun::star::container::XIndexContainer</code></li>
*  <li> <code>com::sun::star::ucb::XDataContainer</code></li>
*  <li> <code>com::sun::star::container::XIndexAccess</code></li>
*  <li> <code>com::sun::star::container::XElementAccess</code></li>
*  <li> <code>com::sun::star::container::XIndexReplace</code></li>
* </ul>
* This object test <b> is NOT </b> designed to be run in several
* threads concurently.
* @see com.sun.star.io.XActiveDataSink
* @see com.sun.star.container.XIndexContainer
* @see com.sun.star.ucb.XDataContainer
* @see com.sun.star.container.XIndexAccess
* @see com.sun.star.container.XElementAccess
* @see com.sun.star.container.XIndexReplace
* @see ifc.io._XActiveDataSink
* @see ifc.container._XIndexContainer
* @see ifc.ucb._XDataContainer
* @see ifc.container._XIndexAccess
* @see ifc.container._XElementAccess
* @see ifc.container._XIndexReplace
*/
public class CntUnoDataContainer extends TestCase {

    /**
    * Creating a Testenvironment for the interfaces to be tested.
    * Creates an instance of the service
    * <code>com.sun.star.cnt.CntUnoDataContainer</code> and adds
    * to it one <code>CntUnoDataContainer</code> instance. <p>
    *     Object relations created :
    * <ul>
    *  <li> <code>'INSTANCE1'</code> for
    *      {@link ifc.container._XIndexContainer},
    *      {@link ifc.container._XIndexReplace} : for this object
    *      elements contained in it are <code>CntUnoDataContainer</code>
    *      instances. (only one relation for one interface thread is now
    *      passed).</li>
    *  <li> <code>'InputStream'</code> for
    *      {@link ifc.io._XActiveDataSink} : a stream to set and get.
    *       </li>
    * </ul>
    */
    protected TestEnvironment createTestEnvironment(
                                    TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        Object oInterface = null;
        XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
        Object relationContainer = null ;
        Object xIn = null;

        try {
            oInterface = xMSF.createInstance
                ( "com.sun.star.ucb.DataContainer" );

            // adding one child container
            XIndexContainer xIC = (XIndexContainer) UnoRuntime.queryInterface
                (XIndexContainer.class, oInterface) ;

            Object child = xMSF.createInstance
                ( "com.sun.star.ucb.DataContainer" );
            xIC.insertByIndex(0, child) ;

            relationContainer = xMSF.createInstance
                ( "com.sun.star.ucb.DataContainer" );

            xIn = xMSF.createInstance
                ( "com.sun.star.io.DataInputStream" );
        }
        catch( com.sun.star.uno.Exception e ) {
            log.println("Can't create an object." );
            throw new StatusException( "Can't create an object", e );
        }

        oObj = (XInterface) oInterface;

        TestEnvironment tEnv = new TestEnvironment( oObj );

        tEnv.addObjRelation("INSTANCE1", relationContainer) ;
        tEnv.addObjRelation("InputStream", xIn) ;

        return tEnv;
    } // finish method getTestEnvironment

}    // finish class BreakIterator

