/*************************************************************************
 *
 *  $RCSfile: rmtlid.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:29:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCPRMT_RMTLID_HXX_
#include <rmtlid.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_ANY_H_ 
#include <com/sun/star/uno/Any.h>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_ 
#include <cppuhelper/typeprovider.hxx>
#endif
#ifndef _OSL_DIAGNOSE_H_ 
#include <osl/diagnose.h>
#endif

#ifndef _UCPRMT_RMTCONN_HXX_
#include <rmtconn.hxx>
#endif

using namespace com::sun;
using namespace com::sun::star;
using namespace ucprmt;

//============================================================================
//
//  LocalContentIdentifier
//
//============================================================================

LocalContentIdentifier::LocalContentIdentifier(
	rtl::Reference< Connection > const & rTheConnection,
	rtl::OUString const & rTheURI,
	uno::Reference< star::ucb::XContentIdentifier > const &
	    rTheRemoteIdentifier):
	ContentIdentifier(rTheURI),
	m_xConnection(rTheConnection),
	m_xRemoteIdentifier(rTheRemoteIdentifier)
{
	OSL_ASSERT(m_xConnection.is());
}

//============================================================================
// virtual
uno::Any SAL_CALL
LocalContentIdentifier::queryInterface(uno::Type const & rType)
	throw (uno::RuntimeException)
{
	uno::Any
		aRet(cppu::queryInterface(rType,
								  static_cast< lang::XUnoTunnel * >(this)));
	return aRet.hasValue() ? aRet : ContentIdentifier::queryInterface(rType);
}

//============================================================================
// virtual
void SAL_CALL LocalContentIdentifier::acquire() throw ()
{
	ContentIdentifier::acquire();
}

//============================================================================
// virtual
void SAL_CALL LocalContentIdentifier::release() throw ()
{
	ContentIdentifier::release();
}

//============================================================================
// virtual
sal_Int64 SAL_CALL
LocalContentIdentifier::getSomething(uno::Sequence< sal_Int8 > const &
									     rIdentifier)
	throw (uno::RuntimeException)
{
	return m_xConnection->isUUID(rIdentifier) ? 1 : 0;
}

