/*************************************************************************
 *
 *  $RCSfile: svdedtv3.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#error Dieses Source entfaellt nun
/*******************************************************************************
#*
#*    Letzte Aenderung  $Author: hr $ $Date: 2000/09/18 17:01:24 $
#*    $Revision: 1.1.1.1 $
#*
#******************************************************************************/

#include <segmentc.hxx>

#include "svdedtv.hxx"
#include "svdundo.hxx"
#include "svdpagv.hxx"
#include "svdpage.hxx"

#include "svdopath.hxx"

#include "svdstr.hrc"   // Namen aus der Resource
#include "svdglob.hxx"  // StringCache

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  @@@@@ @@@@@  @@ @@@@@@  @@ @@ @@ @@@@@ @@   @@
//  @@    @@  @@ @@   @@    @@ @@ @@ @@    @@   @@
//  @@    @@  @@ @@   @@    @@ @@ @@ @@    @@ @ @@
//  @@@@  @@  @@ @@   @@    @@@@@ @@ @@@@  @@@@@@@
//  @@    @@  @@ @@   @@     @@@  @@ @@    @@@@@@@
//  @@    @@  @@ @@   @@     @@@  @@ @@    @@@ @@@
//  @@@@@ @@@@@  @@   @@      @   @@ @@@@@ @@   @@
//
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  ####  #   # #   # #   # ##### ####  #####  ###  ####  ####  ##### # ##### #   # #   #  ####
//  #   # #   # ##  # #  #    #   #   # #     #   # #   # #   # #     #   #   #   # ##  # #
//  ####  #   # # # # # #     #   ####  ####  ##### ####  ####  ####  #   #   #   # # # # #  ##
//  #     #   # #  ## ## #    #   #   # #     #   # #   # #   # #     #   #   #   # #  ## #   #
//  #      ###  #   # #   #   #   ####  ##### #   # #   # ####  ##### #   #    ###  #   #  ####
//
////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma SEG_FUNCDEF(svdedtv3_01)

void SdrEditView::DeleteMarkedPoints()
{
	if (pMarkedObj!=NULL && HasMarkedPoints()) {
		XubString aStr;
		if (GetMarkedPointCount()!=1) {
			ImpTakeDescriptionStr(STR_EditDeletePoints,aStr,GetMarkedPointCount());
		} else {
			ImpTakeDescriptionStr(STR_EditDeletePoint,aStr);
		}
		BegUndo(aStr);
		AddUndo(new SdrUndoGeoObj(*pMarkedObj));
		USHORT nMax=GetMarkablePointCount();
		USHORT i=nMax;
		BOOL bDel=FALSE;
		while (i>0 && !bDel) {
			i--;
			if (IsPointMarked(i)) { // Punkte sind nicht sortiert, deshalb alle abklappern
				bDel=!pMarkedObj->DelPoint(i);
			}
		}
		if (bDel) DeleteMarked();
		UnMarkAllPoints();
		EndUndo();
		if (bDel) MarkListHasChanged();
	}
}

#pragma SEG_FUNCDEF(svdedtv3_02)

void SdrEditView::RipUpAtMarkedPoints()
{
	if (pMarkedObj!=NULL && HasMarkedPoints()) {
		XubString aStr;
		if (GetMarkedPointCount()!=1) {
			ImpTakeDescriptionStr(STR_EditRipUpPoints,aStr,GetMarkedPointCount());
		} else {
			ImpTakeDescriptionStr(STR_EditRipUpPoint,aStr);
		}
		BegUndo(aStr);
		AddUndo(new SdrUndoGeoObj(*pMarkedObj));
		USHORT nMax=GetMarkablePointCount();
		USHORT i;
		BOOL bKorregFlag=FALSE;
		BOOL bInsAny=FALSE;
		for (i=nMax; i>0;) {
			i--;
			if (IsPointMarked(i)) { // Punkte sind nicht sortiert, deshalb alle abklappern
				USHORT nNewPt0Idx=0;
				SdrObject* pNeuObj=pMarkedObj->RipPoint(i,nNewPt0Idx);
				if (pNeuObj!=NULL) {
					bInsAny=TRUE;
					pMarkedPV->GetObjList()->InsertObject(pNeuObj,pMarkedObj->GetOrdNum()+1);
					AddUndo(new SdrUndoNewObj(*pNeuObj));
					MarkObj(pNeuObj,pMarkedPV,FALSE,TRUE);
				}
				if (nNewPt0Idx!=0) { // Korrektur notwendig?
					DBG_ASSERT(nNewPt0Idx<nMax,"SdrEditView::RipUp()/Indexkorrektur: nNewPt0Idx>=nMax");
					DBG_ASSERT(bKorregFlag==FALSE,"Mehrfache Indexkorrektur bei SdrEditView::RipUp()");
					if (!bKorregFlag) {
						bKorregFlag=TRUE;
						for (ULONG nBla=0; nBla<GetMarkedPointCount(); nBla++) {
							USHORT nPntNum=aMarkedPoints.GetObject(nBla);
							nPntNum+=nNewPt0Idx;
							if (nPntNum>=nMax) nPntNum-=nMax;
							aMarkedPoints.Replace(nPntNum,nBla);
						}
						i=nMax; // ... und nochmal von vorn
					}
				}
			}
		}
		UnMarkAllPoints();
		EndUndo();
		/*if (bInsAny)*/ MarkListHasChanged();
	}
}

#pragma SEG_FUNCDEF(svdedtv3_03)

void SdrEditView::ShutMarkedObjects()
{
	if (HasMarkedObj()) {
		XubString aStr;
		ImpTakeDescriptionStr(STR_EditShut,aStr);
		BegUndo(aStr);
		BOOL bChg=FALSE;
		for (ULONG nm=0; nm<aMark.GetMarkCount(); nm++) {
			SdrMark* pM=aMark.GetMark(nm);
			SdrObject* pO=pM->GetObj();
			if (pO->IsPolyObj()) {
				AddUndo(new SdrUndoGeoObj(*pO));
				pO->Shut();
				bChg=TRUE;
			}
		}
		EndUndo();
		if (bChg) {
			UnMarkAllPoints();
			MarkListHasChanged();
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma SEG_EOFMODULE

