/*************************************************************************
 *
 *  $RCSfile: tbxcust.cxx,v $
 *
 *  $Revision: 1.27 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/15 10:54:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ***************************************************************

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen wg. InfoBox
#include <vcl/msgbox.hxx>
#endif
#include <tools/urlobj.hxx>
#include <svtools/pathoptions.hxx>
#ifndef INCLUDED_SVTOOLS_MISCOPT_HXX
#include <svtools/miscopt.hxx>
#endif
#include "vcl/image.hxx"
#include <hash_map>

#ifndef  _COM_SUN_STAR_UI_DIALOGS_EXECUTABLEDIALOGRESULTS_HPP_
#include <com/sun/star/ui/dialogs/ExecutableDialogResults.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFOLDERPICKER_HPP_
#include <com/sun/star/ui/dialogs/XFolderPicker.hpp>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _UNTOOLS_UCBSTREAMHELPER_HXX
#include <unotools/ucbstreamhelper.hxx>
#endif

// defines copied from dialog.hrc in dialog directory
#define RC_DIALOG_BEGIN             	RID_SFX_DIALOG_START

#define BMP_COLLAPSED               	( RC_DIALOG_BEGIN + 18)
#define BMP_EXPANDED                	( RC_DIALOG_BEGIN + 19)

#ifndef _BASMGR_HXX //autogen
#include <basic/basmgr.hxx>
#endif

#include "cfgmgr.hxx"
#include "msg.hxx"
#include "msgpool.hxx"
#include "resmgr.hxx"
#include "tbxmgr.hxx"
#include "tbxcust.hxx"
#include "tbxcust.hrc"
#include "dispatch.hxx"
#include "tbxchild.hxx"
#include "sfxresid.hxx"
#include "macrconf.hxx"
#include "tbxctrl.hxx"
#include "tbxconf.hxx"
#include "bindings.hxx"
#include "sfxtypes.hxx"
#include "helper.hxx"	// SfxContentHelper::...
#include "workwin.hxx"
#include "objface.hxx"
#include "objsh.hxx"
#include "viewfrm.hxx"

using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::ui::dialogs;
using namespace ::com::sun::star::uno;

// wegen IBM CSet++
//#define LOW_USHORT(l) ((USHORT)(ULONG)(l))

//==========================================================================
//  ctor. Es wird in den customize mode geschaltet.

SfxCustomizeToolBox::SfxCustomizeToolBox( Window* pParent, SfxBindings* pBind, const ResId& rId)
    : ToolBox (pParent, rId), bHelpInitialized( FALSE ), pBindings( pBind )
{
	EnableCustomize();
}

DECL_PTRARRAY(SfxTbxControlArr_Impl, SfxToolBoxControl*, 8, 8 );

class TbxAccess_Impl : public ToolBox
{
public :

	TbxAccess_Impl ( Window *pParent, WinBits nBits )
      : ToolBox(pParent,(USHORT)nBits)
	{}

	inline void CustomizeToolBox (const ToolBoxCustomizeEvent& rCEvt)
		{ Customize(rCEvt); }

};

struct SfxTBData
{
	USHORT				nIndex;
	USHORT				nId;
	USHORT				nDomain;
	String				aName;
	SfxInterface*		pIFace;
	BOOL				bVisible;
	SfxToolBoxManager*	pTbxMgr;

	SfxTBData( USHORT n, USHORT nID, USHORT nPos, String aString, BOOL bVis, SfxInterface* pIF ) :
		nIndex( n ),
		nId( nID ),
		nDomain( nPos ),
		aName( aString ),
		pIFace( pIF ),
		bVisible( bVis ),
		pTbxMgr( 0 )
	{}
};	

// **************************************************************************
//  Ueberschreibt den entsprechenden Toolbox-Handler. Wenn aus dieser Toolbox
//  heraus ein Item in eine andere Toolbox gedraggt wurde, wird der Customize-
//  Handler dieser Toolbox gerufen.

void SfxCustomizeToolBox::Customize( const ToolBoxCustomizeEvent& rCEvt )
{
	USHORT nSourcePos = GetItemPos( rCEvt.GetSourceId() );
	USHORT nTargetPos = rCEvt.GetTargetPos();

	if ( rCEvt.GetTargetBox() == NULL )
	{
		return;                         // nicht auf eine Toolbox gedraggt
	}
	else if ( rCEvt.GetTargetBox() == this )
	{
		return;                         // in diese Toolbox hinein gedraggt
	}
	else
	{
		ToolBox* pTarget = rCEvt.GetTargetBox();
		if ( pTarget )
		{
			USHORT nId = rCEvt.GetSourceId();
			if ( SfxMacroConfig::IsMacroSlot( nId ) )
			{
				ToolBoxCustomizeEvent aEvnt (pTarget, nId, nTargetPos, this);
				((TbxAccess_Impl*)pTarget)->CustomizeToolBox(aEvnt);
				pTarget->SetItemText(nId, GetItemText(nId));
				pTarget->SetHelpText(nId, GetHelpText(nId));
			}
			else
			{
//!MBA  : must be tested !!
                pBindings->GetImageManager()->LockImage(nId, this);
				ToolBoxCustomizeEvent aEvnt (pTarget, nId, nTargetPos, this);
				((TbxAccess_Impl*)pTarget)->CustomizeToolBox(aEvnt);
			}
		}

		return;
	}
}

// **************************************************************************
//  ctor des Dialogs. Das floating window wird zentriert, alle Toolboxen im
//  System sowie der ImageManager werden in den customize mode geschaltet.

SfxToolboxCustomizer::SfxToolboxCustomizer( SfxBindings *pBindings,
		SfxChildWindow *pMgr, Window * pParent, const ResId& rResId) :
	SfxModelessDialog( pBindings, pMgr, pParent, rResId ),
    m_aTbFunctionsFT( this, ResId( FT_TB_FUNCTIONS ) ),
	m_aTbFunctionsTLB( this, ResId( TLB_TB_FUNCTIONS ), pBindings, SFX_SLOT_TOOLBOXCONFIG ),
	m_aTbAddBtn( this, ResId( BTN_TB_ADD ) ),
	m_aTbRemoveBtn( this, ResId( BTN_TB_REMOVE ) ),
	m_aTbToolbarsFT( this, ResId( FT_TB_TOOLBARS ) ),
	m_aTbToolbarsLB( this, ResId( LB_TB_TOOLBARS ) ),
	m_aTbToolbarFT( this, ResId( FT_TB_TOOLBAR ) ),
	m_aTbToolbarTLB( this, ResId( TLB_TB_TOOLBAR ), pBindings ),
	m_aTbOkBtn( this, ResId( BTN_TB_OK ) ),
	m_aTbCancelBtn( this, ResId( BTN_TB_CANCEL ) ),
	m_aTbApplyBtn( this, ResId( BTN_TB_APPLY ) ),
	m_aTbHelpBtn( this, ResId( BTN_TB_HELP ) ),
	m_aTbMoveUpBtn( this, ResId( BTN_TB_MOVEUP ) ),
	m_aTbMoveDownBtn( this, ResId( BTN_TB_MOVEDOWN ) ),
	m_aTbDefaultBtn( this, ResId( BTN_TB_DEFAULT ) ),
	m_aTbIconsBtn( this, ResId( BTN_TB_ICONS ) ),
	m_pBmpDlg(0),
	m_nCurrTbxPos(TOOLBOX_ITEM_NOTFOUND)
{
	FreeResource();

    SfxImageManager *pImgMgr = GetBindings().GetImageManager();

	Size aSize = pParent->GetOutputSizePixel();
	Point aPos = pParent->GetPosPixel();
	aPos.X() += (aSize.Width() - GetSizePixel().Width()) / 2;
	aPos.Y() += (aSize.Height() - GetSizePixel().Height()) / 2;

	if (aPos.X() < 0) aPos.X() = 0;
	if (aPos.Y() < 0) aPos.Y() = 0;

	SetPosPixel(aPos); // center dialog

    SvtMiscOptions aOpt;
    m_nSymbolSet = SfxImageManager::GetCurrentSymbolSet();
    aOpt.AddListener( LINK(this,SfxToolboxCustomizer,SymbolsetChanged));

	Link aToolbarsSelectHdl( LINK( this, SfxToolboxCustomizer, SelectToolbars ) );

	m_aTbToolbarsLB.SetSelectHdl( aToolbarsSelectHdl );
	m_aTbToolbarTLB.SetSelectHdl( LINK( this, SfxToolboxCustomizer, SelectToolbar ));
	m_aTbFunctionsTLB.SetSelectHdl( LINK( this, SfxToolboxCustomizer, SelectFunctions ));

	m_aTbMoveUpBtn.SetClickHdl( LINK( this, SfxToolboxCustomizer, MoveUpButtonHdl ));
	m_aTbMoveDownBtn.SetClickHdl( LINK( this, SfxToolboxCustomizer, MoveDownButtonHdl ));
	m_aTbAddBtn.SetClickHdl( LINK( this, SfxToolboxCustomizer, AddButtonHdl ));
	m_aTbRemoveBtn.SetClickHdl( LINK( this, SfxToolboxCustomizer, RemoveButtonHdl ));
	m_aTbOkBtn.SetClickHdl( LINK( this, SfxToolboxCustomizer, OkButtonHdl ));
	m_aTbCancelBtn.SetClickHdl( LINK( this, SfxToolboxCustomizer, CancelButtonHdl ));

	m_aTbApplyBtn.SetClickHdl( LINK( this, SfxToolboxCustomizer, ApplyButtonHdl ));
	m_aTbIconsBtn.SetClickHdl( LINK( this, SfxToolboxCustomizer, IconsButtonHdl ));
	m_aTbDefaultBtn.SetClickHdl( LINK( this, SfxToolboxCustomizer, DefaultButtonHdl ));
    GetBindings().GetWorkWindow_Impl()->SetObjectBarCustomizeMode_Impl( TRUE );

    GetBindings().ENTERREGISTRATIONS();

	Init(); // Fill up functions tree list box
	m_aTbFunctionsTLB.Init();
	m_aTbToolbarTLB.SetDragSourcePartner( &m_aTbFunctionsTLB );
	m_aTbToolbarsLB.SelectEntryPos( 0, TRUE );
	aToolbarsSelectHdl.Call( this );
	
	// Set changed listener to enable/disable apply button correctly
	m_aTbToolbarTLB.SetChangedListener( LINK( this, SfxToolboxCustomizer, OnTreelistBoxChanged ) ); 

	m_aTbFunctionsTLB.Select( m_aTbFunctionsTLB.GetEntry( 0,0 ) );
	m_aTbFunctionsTLB.GrabFocus();

    GetBindings().GetDispatcher()->Lock(TRUE);
}

// **************************************************************************
//  dtor des Dialogs. Fuer alle Toolboxen im System sowie den ImageManager
//  wird der customize mode ausgeschaltet.

SfxToolboxCustomizer::~SfxToolboxCustomizer()
{
    SvtMiscOptions aOpt;
    aOpt.RemoveListener( LINK(this,SfxToolboxCustomizer,SymbolsetChanged));

    GetBindings().GetWorkWindow_Impl()->SetObjectBarCustomizeMode_Impl( FALSE );

	if ( m_pBmpDlg )
		delete m_pBmpDlg;

	USHORT nCount = m_aTbToolbarsLB.GetEntryCount();
	for ( USHORT nPos = 0; nPos < nCount; nPos++ )
	{
		SfxTBData* pTBData = (SfxTBData*)m_aTbToolbarsLB.GetEntryData( nPos );
		if ( pTBData && pTBData->pTbxMgr )
			delete pTBData->pTbxMgr;
		delete pTBData;
	}

	ClearToolBox();

    // all other configurations are saved with their documents
    SFX_APP()->GetConfigManager_Impl()->StoreConfiguration();

    GetBindings().GetDispatcher()->Lock(FALSE);
    GetBindings().LEAVEREGISTRATIONS();
}

// **************************************************************************
//  Fill the toolbar combobox with all visible toolbars
//  

void SfxToolboxCustomizer::Init()
{
	// Zun"achst Platz f"ur selbstdefinierte Toolboxen schaffen
	SfxInterface			*pIFace;
	USHORT					n=0;        // Interface-Zaehler
	USHORT					nIndex = 0;
	std::hash_map<int,bool>	aToolbarsInserted;

	// Aus allen auffindbaren Interfaces die Toolboxen einsammeln
	SfxSlotPool& rSlotPool = SFX_SLOTPOOL();
	for ( pIFace = rSlotPool.FirstInterface(); pIFace != 0;
		  pIFace = rSlotPool.NextInterface() )
	{
		// Nur Interfaces mit Namen sind anzeigbare Kontexte
		if ( pIFace->HasName() )
		{
			for ( USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++ )
			{
				String aObjectBarName = *(pIFace->GetObjectBarName(nNo));
				std::hash_map<int,bool>::const_iterator aIter = aToolbarsInserted.find( pIFace->GetObjectBarResId(nNo).GetId() );
				// Don't include toolbars with the same id twice. It is possible that a toolbar can be accessed
				// by more than one interface!
				if ( aObjectBarName.Len() && aIter == aToolbarsInserted.end() )
				{
					aToolbarsInserted.insert( std::hash_map<int,bool>::value_type( pIFace->GetObjectBarResId(nNo).GetId(), true ));
					SfxTBData* pTBData = new SfxTBData( nNo,
														pIFace->GetObjectBarResId( nNo ).GetId(),
														pIFace->GetObjectBarPos( nNo ),
														aObjectBarName,
														pIFace->IsObjectBarVisible( nNo ),
														pIFace );
					
					n = m_aTbToolbarsLB.InsertEntry( aObjectBarName );
					m_aTbToolbarsLB.SetEntryData( n, pTBData );
				}
			}
		}
	}

	SfxConfigManager* pMgr = SfxViewFrame::Current()->GetObjectShell()->GetConfigManager();
	USHORT nMask = SFX_VISIBILITY_CLIENT | SFX_VISIBILITY_STANDARD;
	if ( !pMgr )
		pMgr = SFX_APP()->GetConfigManager_Impl();

	SfxToolBoxConfig* pTbxConfig = GetBindings().GetToolBoxConfig();
	for ( USHORT nUser=0; nUser<4; nUser++ )
	{
		USHORT nType = nUser + RID_SFX_TOOLBOX_START + 10;
		if ( pMgr->HasConfigItem( nType ) )
		{
			String aUserDefName = pTbxConfig->GetToolBoxPositionName( SFX_OBJECTBAR_USERDEF1 + nUser );
			SfxTBData* pTBData = new SfxTBData( nUser,
												nType,
												SFX_OBJECTBAR_USERDEF1 + nUser,
												aUserDefName,
												pTbxConfig->IsToolBoxPositionVisible( SFX_OBJECTBAR_USERDEF1 + nUser ),
												NULL );
			
			String aTmp = pTbxConfig->GetToolBoxPositionUserName( SFX_OBJECTBAR_USERDEF1 + nUser );
			if ( aTmp.Len() )
				aUserDefName = aTmp;
			
			n = m_aTbToolbarsLB.InsertEntry( aUserDefName );
			m_aTbToolbarsLB.SetEntryData( n, pTBData );
		}
	}
}


void SfxToolboxCustomizer::ClearToolBox()
{
	m_aTbToolbarTLB.ClearAll();
}


void SfxToolboxCustomizer::SelectToolbar( USHORT nType )
{
	USHORT nPos		= 0;
	USHORT nCount	= m_aTbToolbarsLB.GetEntryCount();
	String aTbxName;
	for ( USHORT n = 0; n < nCount; n++ )
	{
		SfxTBData* pData = (SfxTBData*)m_aTbToolbarsLB.GetEntryData( n );
		if ( pData && pData->nId == nType )
		{
			nPos		= n;
			aTbxName	= m_aTbToolbarsLB.GetEntry( n );
			break;
		}
	}

	if ( aTbxName.Len() > 0 )
	{
		Link aToolbarsSelectHdl( LINK( this, SfxToolboxCustomizer, SelectToolbars ) );
		m_aTbToolbarsLB.SelectEntryPos( nPos, TRUE );
		aToolbarsSelectHdl.Call( this );
	}
}

	
// **************************************************************************
//  The user selected a toolbar from the dropdown box we have to fill
//	our toolbar tree list box with the buttons for that toolbar.
//  

IMPL_LINK( SfxToolboxCustomizer, SelectToolbars, ListBox*, pBox )
{
	SfxBindings& rBindings = GetBindings();
    SfxImageManager *pImgMgr = GetBindings().GetImageManager();
	SfxSlotPool* pSlotPool = &SFX_SLOTPOOL();

	USHORT nPos = m_aTbToolbarsLB.GetSelectEntryPos();
	SfxTBData* pTBData = (SfxTBData*)m_aTbToolbarsLB.GetEntryData( nPos );

	if ( !pTBData->pTbxMgr )
	{
		// create toolbox manager on demand
		SfxToolBoxManager*	pTbxMgr = 0;
		if ( pTBData->pIFace )
		{
			// built in toolbox, create toolbox manager with special config mode
			pTbxMgr = new SfxToolBoxManager( GetParent(), 
											 GetBindings(),
											 pTBData->pIFace->GetObjectBarResId( pTBData->nIndex ),
											 pTBData->pIFace,
											 (pTBData->nDomain & SFX_POSITION_MASK),
											 NULL,
											 TRUE );
			size_t nSize = sizeof( *pTbxMgr );
		}
		else
		{
			// userdefined toolbox, create toolbox manager with special config mode
			ResId aResId( pTBData->nId, 0 );
			pTbxMgr = new SfxToolBoxManager( GetParent(),
											 GetBindings(),
											 aResId,
											 0,
											 pTBData->nIndex,
											 NULL,
											 TRUE );
		}

		// intialize it to read it from configuration
		pTbxMgr->Initialize();
		pTBData->pTbxMgr = pTbxMgr;
	}

	if ( m_nCurrTbxPos != TOOLBOX_ITEM_NOTFOUND )
	{
		// Remove changed listener from old toolbox
		SfxTBData* pTBData = (SfxTBData*)m_aTbToolbarsLB.GetEntryData( m_nCurrTbxPos );
		SfxToolbox& rBox = (SfxToolbox&)pTBData->pTbxMgr->GetToolBox();
		rBox.SetChangedListener( Link() );
	}
		
	// Set changed listener to get notification if toolbox was changed by D&D
	m_nCurrTbxPos = nPos;
	SfxToolBoxManager* pTbxMgr = pTBData->pTbxMgr;
	SfxToolbox& rBox = (SfxToolbox&)pTbxMgr->GetToolBox();
	rBox.SetChangedListener( LINK( this, SfxToolboxCustomizer, OnToolBarChanged ));	
	
	m_aTbToolbarTLB.SetUpdateMode( FALSE );
	ClearToolBox();
	m_aTbToolbarTLB.Init( pTBData->pTbxMgr, pTBData->pIFace, pSlotPool );
	m_aTbToolbarTLB.SetUpdateMode( TRUE );
	m_aTbDefaultBtn.Enable( TRUE );
	
	return 0;
}

IMPL_LINK( SfxToolboxCustomizer, SelectToolbar, Control*, pBox )
{
	SvLBoxEntry* pEntry = m_aTbToolbarTLB.GetCurEntry();
	if ( pEntry )
	{
		SfxToolbarEntryInfo_Impl* pInfo = (SfxToolbarEntryInfo_Impl*)pEntry->GetUserData();
		
		switch ( pInfo->nKind )
		{
			case TOOLBOXITEM_BUTTON:
			{
				m_aTbIconsBtn.Enable( TRUE );
				m_aTbRemoveBtn.Enable( TRUE );
				m_aTbMoveUpBtn.Enable( TRUE );
				m_aTbMoveDownBtn.Enable( TRUE );

				USHORT		nPos		= m_aTbToolbarsLB.GetSelectEntryPos();
				SfxTBData*	pTBData		= (SfxTBData*)m_aTbToolbarsLB.GetEntryData( nPos );
				ToolBox&	rToolBox	= pTBData->pTbxMgr->GetToolBox();
				
				BOOL bEnable = ( rToolBox.GetItemWindow( pInfo->nId ) == 0 );
				m_aTbIconsBtn.Enable( bEnable );
				break;
			}
			
			case TOOLBOXITEM_SEPARATOR:
			case TOOLBOXITEM_BREAK:
			case TOOLBOXITEM_SPACE:
			{
				m_aTbIconsBtn.Enable( FALSE );
				m_aTbRemoveBtn.Enable( TRUE );
				m_aTbMoveUpBtn.Enable( TRUE );
				m_aTbMoveDownBtn.Enable( TRUE );
				break;				
			}

			case TOOLBOXITEM_DONTKNOW:
			{
				break;
			}
		}
		CheckButtonsState();
	}

	pEntry = m_aTbFunctionsTLB.GetCurEntry();
	if ( pEntry )
	{
		SfxCfgGroupInfo_Impl* pInfo = (SfxCfgGroupInfo_Impl*)pEntry->GetUserData();
		if ( pInfo->nKind == SFX_CFGFUNCTION_SLOT ||
			 pInfo->nKind == SFX_CFGFUNCTION_MACRO ||
			 pInfo->nKind == SFX_CFGFUNCTION_SEPARATOR ||
			 pInfo->nKind == SFX_CFGFUNCTION_SPACE )
			m_aTbAddBtn.Enable( TRUE );
		else
			m_aTbAddBtn.Enable( FALSE );
	}
	
	return 0;
}

IMPL_LINK( SfxToolboxCustomizer, SelectFunctions, Control*, pBox )
{
	SvLBoxEntry* pEntry = m_aTbFunctionsTLB.GetCurEntry();
	if ( pEntry )
	{
		SfxCfgGroupInfo_Impl* pInfo = (SfxCfgGroupInfo_Impl*)pEntry->GetUserData();
		if ( pInfo->nKind == SFX_CFGFUNCTION_SLOT ||
			 pInfo->nKind == SFX_CFGFUNCTION_MACRO ||
			 pInfo->nKind == SFX_CFGFUNCTION_SEPARATOR ||
			 pInfo->nKind == SFX_CFGFUNCTION_SPACE )
			m_aTbAddBtn.Enable( TRUE );
		else
			m_aTbAddBtn.Enable( FALSE );
	}
	
	return 0;	
}

struct std::hash< SfxConfigManager* >
{
	size_t operator()(const SfxConfigManager* __s) const { return (size_t)__s; }
};
 
struct SfxConfigManagerPtrEqual
{
	bool operator()(const SfxConfigManager* s1, const SfxConfigManager* s2) const
	{
		return ( s1 == s2 );
	}
};

typedef std::vector< SfxToolBoxManager* > SfxTbxMgrArray;
typedef std::hash_map< SfxConfigManager*, bool, std::hash< SfxConfigManager * >, SfxConfigManagerPtrEqual > SfxCfgMgrMap;

void SfxToolboxCustomizer::StoreToolBoxes( BOOL bPreserveListener )
{
	USHORT				nCount	= m_aTbToolbarsLB.GetEntryCount();
	SfxConfigManager*	pCfgMgr = NULL;
	SfxCfgMgrMap		aCfgMngSet;
	SfxTbxMgrArray		aTbxMgrArray;

	// Check if we have a modified toolbar
	for ( USHORT nPos = 0; nPos < nCount; nPos++ )
	{
		SfxTBData* pTBData = (SfxTBData*)m_aTbToolbarsLB.GetEntryData( nPos );
		if ( pTBData && pTBData->pTbxMgr && pTBData->pTbxMgr->IsModified() )
		{
			// Save all modified toolbars and reinitialize them to apply the changes
			SfxToolBoxManager*	pTbxMgr = pTBData->pTbxMgr;
			
			SfxConfigManager*	pCfgMgr				= pTbxMgr->GetConfigManager();
			SfxToolbox&			rTbx				= (SfxToolbox&)pTbxMgr->GetToolBox();
			Link				aChangedListener	= rTbx.GetChangedListener();

			// Remove changed listener so we don't get this update twice!
			if ( aChangedListener.IsSet() )
				rTbx.SetChangedListener( Link() );
			
			pCfgMgr->StoreConfigItem( *pTbxMgr );			
			aCfgMngSet.insert( SfxCfgMgrMap::value_type( pCfgMgr, true ));
			aTbxMgrArray.push_back( pTbxMgr );

			// Set changed listener so we can get updates again!
			if ( bPreserveListener && aChangedListener.IsSet() )
				rTbx.SetChangedListener( aChangedListener );
		}
	}

	if ( aCfgMngSet.size() > 0 )
	{
		// Store modified configuration manager
		SfxCfgMgrMap::iterator aIterCfgMng = aCfgMngSet.begin();
		while ( aIterCfgMng != aCfgMngSet.end() )
		{
			SfxConfigManager* pCfgMgr = aIterCfgMng->first;	
			pCfgMgr->StoreConfiguration();
			aIterCfgMng++;
		}
		
		// Reinitialize the modified toolbox manager
		SfxTbxMgrArray::iterator aIterTbxMgr = aTbxMgrArray.begin();
		while ( aIterTbxMgr != aTbxMgrArray.end() )
		{
			SfxToolBoxManager*	pTbxMgr = *aIterTbxMgr;
			SfxConfigManager*	pCfgMgr = pTbxMgr->GetConfigManager();
			pCfgMgr->ReInitialize( pTbxMgr->GetType() );
			aIterTbxMgr++;
		}
	}
}

IMPL_LINK( SfxToolboxCustomizer, OkButtonHdl, OKButton*, pButton  )
{
	StoreToolBoxes( FALSE );
	Close();
	return 0;
}

IMPL_LINK( SfxToolboxCustomizer, CancelButtonHdl, CancelButton*, pButton )
{
	USHORT nResult = RET_YES;
	if ( m_aTbApplyBtn.IsEnabled() )
	{
		WarningBox aWarningBox( this, WinBits( WB_YES_NO | WB_DEF_NO | WB_3DLOOK ), 
							String( SfxResId( STR_MODIFIED_TOOLBOXES )) );
		nResult = aWarningBox.Execute();
	}

	if ( nResult == RET_YES )
		Close();
	return 0;
}

// **************************************************************************
//  CloseHandler des Dialogfensters. Der Dialog wird ueber den Dispatcher
//  beendet und zerstoert.

BOOL SfxToolboxCustomizer::Close()
{
	SfxApplication *pSfxApp = SFX_APP();
	GetBindings().GetDispatcher()->Lock(FALSE);
	GetBindings().GetWorkWindow_Impl()->SetObjectBarCustomizeMode_Impl( FALSE );
	return SfxModelessDialog::Close();
}


void SfxToolboxCustomizer::CheckButtonsState()
{
	// Disable up/down buttons if current entry cannot be moved by them
	{
		SvLBoxEntry* pEntry = m_aTbToolbarTLB.GetCurEntry();
		ULONG nPos = 0;
		m_aTbToolbarTLB.GetPos( nPos, pEntry );
		if ( nPos == 0 )
			m_aTbMoveUpBtn.Enable( FALSE );
		else if (( nPos+1 ) == m_aTbToolbarTLB.GetEntryCount() )
			m_aTbMoveDownBtn.Enable( FALSE );
	}
}

long SfxToolboxCustomizer::Notify( NotifyEvent& rEvt )
{
	if ( rEvt.GetType() == EVENT_KEYINPUT &&
		 rEvt.GetKeyEvent()->GetKeyCode() == KEY_INSERT &&
		 m_aTbFunctionsTLB.HasFocus() &&
		 m_aTbAddBtn.IsEnabled() )
	{
		// Insert entry from functions tree list box to toolbar tree list box
		// Precondition: KEY_INSERT pressed, functions tree list box has focus
		// and add button is enabled!
		Link aLink( LINK( this, SfxToolboxCustomizer, AddButtonHdl ) );
		aLink.Call( this );
	}

	// Da per default Notify nur bis zu einem SystemWindow geht
	long nRet = SfxModelessDialog::Notify( rEvt );
	if( !nRet )
		nRet = GetParent()->Notify( rEvt );

	return nRet;
}

IMPL_LINK( SfxToolboxCustomizer, OnTreelistBoxChanged, void*, pVoid )
{
	m_aTbApplyBtn.Enable( TRUE );
	return 0;
}

IMPL_LINK( SfxToolboxCustomizer, OnToolBarChanged, SfxToolBoxManager*, pTbxMgr )
{
	USHORT nPos = m_aTbToolbarsLB.GetSelectEntryPos();
	SfxTBData* pTBData = (SfxTBData*)m_aTbToolbarsLB.GetEntryData( nPos );

	if ( pTbxMgr == pTBData->pTbxMgr )
	{
		// The toolbar we currently display in the right treelistbox was changed by D&D
		// from toolbar to toolbar. We have to reinitialize our treelistbox to display
		// the new entries.
		SfxSlotPool* pSlotPool = &SFX_SLOTPOOL();
		
		m_aTbToolbarTLB.SetUpdateMode( FALSE );
		ClearToolBox();
		m_aTbToolbarTLB.Init( pTBData->pTbxMgr, pTBData->pIFace, pSlotPool );
		m_aTbToolbarTLB.SetUpdateMode( TRUE );
		m_aTbDefaultBtn.Enable( TRUE );

		// Check if we have a modified toolbar or the current was the only one. Depending
		// on this we have to enable/disable the apply button.
		BOOL bEnableApplyButton = FALSE;
		USHORT nCount = m_aTbToolbarsLB.GetEntryCount();
		for ( USHORT nPos = 0; nPos < nCount; nPos++ )
		{
			SfxTBData* pTBData = (SfxTBData*)m_aTbToolbarsLB.GetEntryData( nPos );
			if ( pTBData && pTBData->pTbxMgr && pTBData->pTbxMgr->IsModified() )
			{
				bEnableApplyButton = TRUE;
				break;
			}
		}
		
		m_aTbApplyBtn.Enable( bEnableApplyButton );
	}

	return 0;
}

// **************************************************************************
//  Es wurde bei geoeffnetem floating window das SymbolSet ausgetauscht.

IMPL_LINK( SfxToolboxCustomizer, SymbolsetChanged, void*, pVoid )
{
    if ( m_nSymbolSet != SfxImageManager::GetCurrentSymbolSet() )
	{
        SfxImageManager* pImgMgr = GetBindings().GetImageManager();
        m_nSymbolSet = SfxImageManager::GetCurrentSymbolSet();

		// retrieve and set new symbol set for toolbar tree list box
		SvLBoxEntry *pEntry = m_aTbToolbarTLB.First();
		while ( pEntry )
		{
			SfxToolbarEntryInfo_Impl *pData = (SfxToolbarEntryInfo_Impl*) pEntry->GetUserData();
			if ( pData->nKind == TOOLBOXITEM_BUTTON )
			{
				Image aImage = pImgMgr->SeekImage( pData->nId );
				m_aTbToolbarTLB.SetExpandedEntryBmp( pEntry, aImage );
				m_aTbToolbarTLB.SetCollapsedEntryBmp( pEntry, aImage );
			}
			pEntry = m_aTbToolbarTLB.Next( pEntry );
		}
	}
    
	return 0L;
}

IMPL_LINK( SfxToolboxCustomizer, MoveUpButtonHdl, Button *, pButton )
{
	m_aTbToolbarTLB.MoveUpCurEntry();

	return 0;
}

IMPL_LINK( SfxToolboxCustomizer, MoveDownButtonHdl, Button *, pButton )
{
	m_aTbToolbarTLB.MoveDownCurEntry();
	
	return 0;
}

IMPL_LINK( SfxToolboxCustomizer, AddButtonHdl, Button *, pButton )
{
	SvLBoxEntry* pEntry = m_aTbFunctionsTLB.GetCurEntry();
	if ( pEntry )
	{
		SfxCfgGroupInfo_Impl* pInfo = (SfxCfgGroupInfo_Impl*)pEntry->GetUserData();
		
		// To determine special cases: Add at the front or the bottom!
		BOOL		 bFront		  = FALSE;
		SvLBoxEntry* pTargetEntry = m_aTbToolbarTLB.GetCurEntry();
		if ( !pTargetEntry && m_aTbToolbarTLB.GetEntryCount() == 0 )
			bFront = TRUE; // Add to the front if toolbar tree list box is empty!
		
		BOOL bInserted = TRUE;
		if ( pInfo->nKind == SFX_CFGFUNCTION_SLOT )
			bInserted = m_aTbToolbarTLB.AddFunction( pTargetEntry, pInfo->nKind, pInfo->nOrd, 0, bFront );
		else if ( pInfo->nKind == SFX_CFGFUNCTION_MACRO )
			bInserted = m_aTbToolbarTLB.AddFunction( pTargetEntry, pInfo->nKind, pInfo->nOrd, (SfxMacroInfo*)pInfo->pObject, bFront );
		else if ( pInfo->nKind == SFX_CFGFUNCTION_SEPARATOR )
			m_aTbToolbarTLB.AddSeparator( pTargetEntry, TOOLBOXITEM_SEPARATOR, bFront );
		else if ( pInfo->nKind == SFX_CFGFUNCTION_SPACE )
			m_aTbToolbarTLB.AddSeparator( pTargetEntry, TOOLBOXITEM_SPACE, bFront );
		
		if ( !bInserted )
			InfoBox( this, String( SfxResId( STR_FUNCTION_ALREADY_IN_TOOLBOX ))).Execute();
	}
	
	return 0;
}

IMPL_LINK( SfxToolboxCustomizer, ApplyButtonHdl, Button *, pButton )
{
	StoreToolBoxes( TRUE );
	m_aTbApplyBtn.Enable( FALSE );
	return 0;
}

IMPL_LINK( SfxToolboxCustomizer, RemoveButtonHdl, Button *, pButton )
{
	SvLBoxEntry* pEntry = m_aTbToolbarTLB.GetCurEntry();
	if ( pEntry )
		m_aTbToolbarTLB.RemoveItem( pEntry );
	
	return 0;
}

IMPL_LINK( SfxToolboxCustomizer, IconsButtonHdl, Button *, pButton )
{
	SvLBoxEntry* pEntry = m_aTbToolbarTLB.GetCurEntry();
	if ( pEntry )
	{
		USHORT				nPos		= m_aTbToolbarsLB.GetSelectEntryPos();
		SfxToolBoxManager*	pTbxMgr		= ((SfxTBData*)m_aTbToolbarsLB.GetEntryData( nPos ))->pTbxMgr;
		SfxToolbox&			rToolBox	= (SfxToolbox&)pTbxMgr->GetToolBox();

		// Open connect user bitmap dialog so the user is able to choose a new bitmap
		// for the selected function.
		SfxToolbarEntryInfo_Impl* pInfo = (SfxToolbarEntryInfo_Impl*)pEntry->GetUserData();
		ConnectUserBitmapDialog_Impl( pInfo->nId, pTbxMgr->GetToolBox(), pTbxMgr );

		// Store old image to see if we have to update the configuration after calling BmpDlg
		Image	aOldImage		= rToolBox.GetItemImage( pInfo->nId );
		BOOL	bHadItemText	= rToolBox.HasItemText_Impl( pInfo->nId );

		short nResult = 0;
		if ( m_pBmpDlg )
			nResult = m_pBmpDlg->Execute();
		
		if ( nResult == RET_OK )
		{
			Image	aNewImage		= rToolBox.GetItemImage( pInfo->nId );
			BOOL	bHasItemText	= rToolBox.HasItemText_Impl( pInfo->nId );

			// Check if something was changed by the user
			if ( aNewImage != aOldImage || 
				 bHasItemText || 
				 ( bHadItemText && !bHasItemText ))
			{
				// Set new image for the toolbar tree list box
				m_aTbToolbarTLB.SetExpandedEntryBmp( pEntry, aNewImage );
				m_aTbToolbarTLB.SetCollapsedEntryBmp( pEntry, aNewImage );
				pTbxMgr->SetModified( TRUE );
				m_aTbApplyBtn.Enable( TRUE );
			}
		}
	}
	
	return 0;
}

IMPL_LINK( SfxToolboxCustomizer, DefaultButtonHdl, Button *, pButton )
{
	USHORT nPos = m_aTbToolbarsLB.GetSelectEntryPos();
	SfxTBData* pTBData = (SfxTBData*)m_aTbToolbarsLB.GetEntryData( nPos );

	if ( pTBData->pTbxMgr )
	{
		// Use default icons for the selected toolbox
		SfxSlotPool* pSlotPool = &SFX_SLOTPOOL();
		pTBData->pTbxMgr->UseDefault();
		
		m_aTbToolbarTLB.SetUpdateMode( FALSE );
		ClearToolBox();
		m_aTbToolbarTLB.Init( pTBData->pTbxMgr, pTBData->pIFace, pSlotPool );
		m_aTbToolbarTLB.SetUpdateMode( TRUE );
		pTBData->pTbxMgr->SetModified( TRUE );
		m_aTbApplyBtn.Enable( TRUE );
	}

	return 0;
}

UINT32 getBitmapCount_Impl( const String& rFolder )
{
	const String aBitmapExt( DEFINE_CONST_UNICODE( "bmp" ) );
	Sequence< ::rtl::OUString > aFiles = SfxContentHelper::GetFolderContents( rFolder, sal_False );
	const ::rtl::OUString* pFiles  = aFiles.getConstArray();
	UINT32 i, nBitmapCount = 0, nCount = aFiles.getLength();
	for ( i = 0; i < nCount; i++ )
	{
		if ( aBitmapExt == INetURLObject( pFiles[i] ).getExtension() )
			nBitmapCount++;
	}
	return nBitmapCount;
}

SfxUserBitmapDialog_Impl* SfxToolboxCustomizer::ConnectUserBitmapDialog_Impl
(
	USHORT nId,
	ToolBox& rTbx,
	SfxToolBoxManager* pMgr
)
{
	// the count of bitmaps of the bitmap directory
	String aInName = SvtPathOptions().GetBitmapPath();
	UINT32 nCount = getBitmapCount_Impl( aInName );

	// Ist es leer ?
	if ( !nCount )
	{
        // Dann PathDialog anzeigen
        rtl::OUString aService( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.ui.dialogs.FolderPicker" ) );
        Reference< XMultiServiceFactory > xFactory( ::comphelper::getProcessServiceFactory() );

        Reference < XFolderPicker > xFolderDlg( xFactory->createInstance( aService ), UNO_QUERY );

        xFolderDlg->setTitle( String( SfxResId( STR_TBXCUST_BMPDIR ) ) );
        if ( xFolderDlg->execute() == ExecutableDialogResults::OK )
        {
			// Selektiertes Directory checken
			aInName = xFolderDlg->getDirectory();
			nCount = getBitmapCount_Impl( aInName );

			// Wenn nicht leer, auf jeden Fall neu einlesen
			if ( nCount )
				DELETEZ( m_pBmpDlg );
		}
		else
			return NULL;
	}

	if ( !nCount )
	{
		// Selektierter Pfad ist leer
		String aString( SfxResId( STR_TBXCUST_BITMAPS ) );
		String aBmpDir = SvtPathOptions().GetBitmapPath();
		aString.SearchAndReplaceAscii( "$PATH$", aBmpDir );
		InfoBox( this, aString ).Execute();
//		return 0;
	}

	if ( m_pBmpDlg )
	{
		// Wenn inzwischen die Symbolgr"osse oder der Bitmap-Path
		// ge"andert wurde, muss neu eingelesen werden
        if ( m_pBmpDlg->aSymbolTb.GetItemImage(1).GetSizePixel() != GetBindings().GetImageManager()->GetImageSize() ||
			 m_pBmpDlg->aDirName != aInName )
			DELETEZ(m_pBmpDlg);
	}

    SfxImageManager* pImgMgr = GetBindings().GetImageManager();
    if ( !m_pBmpDlg )
        m_pBmpDlg = new SfxUserBitmapDialog_Impl( this, aInName, rTbx, nId, pMgr, pImgMgr );
	else
	{
		m_pBmpDlg->SetFunctionId( nId );
		m_pBmpDlg->SetToolBox( rTbx );
	}

	return m_pBmpDlg;
}

SfxUserBitmapDialog_Impl::SfxUserBitmapDialog_Impl
(
	Window *pParent,
	const String& rBmpDirName,
	ToolBox& rTbx,
	USHORT nID,
    SfxToolBoxManager* pTbxMgr,
    SfxImageManager* pImgMgr
)
 :  ModalDialog      (pParent, SfxResId(RID_USERDEFBMP)),
	aSymbolTb        (this, ResId(TB_BITMAP)),
	aDescLabelFt     (this, ResId(FT_DESC_LABEL)),
	aDescEdit        (this, ResId(FT_DESC)),
	aOKButton        (this, ResId(BTN_OK)),
	aCancelButton    (this, ResId(BTN_CANCEL)),
	aHelpBtn         (this, ResId(BTN_HELP)),
	aFunctionGb      (this, ResId(GB_FUNCTION)),
	aDefaultBtn		 (this, ResId(BTN_TB_DEFAULTIMAGE)),
	nFuncId 		 (nID),
	aDirName		 (rBmpDirName),
	pToolBox		 (&rTbx),
    pMgr             (pTbxMgr),
    pImageMgr        (pImgMgr),
	bNoDefaultImage  (FALSE),
	bBigImages		 (FALSE),
	nBmpColorConversion(BMP_CONVERSION_4BIT_COLORS),
	nBmpColorDepth(4)
{
	// file name prefixes for standard images
	const sal_Int32 nPrefixLength = 2;
	const char aSmallImagePrefix[] = "s_";
	const char aBigImagePrefix[] = "l_";

	Color aColor( pImageMgr->GetMaskColor() );
	FreeResource();

	aDescEdit.SetText( pToolBox->GetItemText( nFuncId ) );
    EnterWait();

	bBigImages = ( SfxImageManager::GetCurrentSymbolSet() == SFX_SYMBOLS_LARGE );
    
	String	aEmptyStr;
    Size	aSize = pImageMgr->GetImageSize();
    
    // #109421#
    // Get reference bitmap to determine the current color depth. Due to restriction
    // of the ImageList and toolbar implementation we can only use one color depth
    // for all bitmaps in an ImageList. Reference color depth is defined by the bitmaps
    // in our resources.
    Image aRefImage = pImageMgr->GetImage( SID_OPENDOC, BOOL(FALSE), 0 );
    if ( !!aRefImage )
    {
        Bitmap aRefBitmap = aRefImage.GetBitmap();
        USHORT nColorDepth = aRefBitmap.GetBitCount();
        if ( nColorDepth == 1 )
        {
            nBmpColorConversion = BMP_CONVERSION_1BIT_THRESHOLD;
            nBmpColorDepth = 1;
        }
        else if ( nColorDepth <= 4 )
        {
            nBmpColorConversion = BMP_CONVERSION_4BIT_COLORS;
            nBmpColorDepth = 4;
        }
        else if ( nColorDepth <= 8 )
        {
            nBmpColorConversion = BMP_CONVERSION_8BIT_COLORS;
            nBmpColorDepth = 8;
        }
        else
        {
            nBmpColorConversion = BMP_CONVERSION_24BIT;
            nBmpColorDepth = 24;
        }
    }

    // Search the given directory for bitmaps:
    Sequence< rtl::OUString > aUrls(
        SfxContentHelper::GetFolderContents( aDirName, false ));
    USHORT nId = 1;
    ImageList aImages(128, 128); // large growth factor, expecting many entries

	Image aDefaultImage = GetDefaultImage( nFuncId );
	
	// Initially add default image to the front
	aBitmapUrls.push_back( aEmptyStr );
	aSymbolTb.InsertItem( nId, aEmptyStr );
	aImages.AddImage( nId, aDefaultImage );

	++nId;

	// Insert the default image on the first position
    for (sal_Int32 i = 0; i < aUrls.getLength(); ++i)
    {
        rtl::OUString & rUrl = aUrls[i];
        INetURLObject aUrlObj(rUrl);
        if (rtl::OUString(aUrlObj.GetExtension()).equalsAsciiL(
                RTL_CONSTASCII_STRINGPARAM("bmp")))
        {
			rtl::OUString aFileName = aUrlObj.getName();
			
			// Ignore "s_*" files if we show big images and "l_*" files if we show small images!
			sal_Bool bIgnoreFile = bBigImages ? aFileName.matchIgnoreAsciiCaseAsciiL( aSmallImagePrefix, nPrefixLength, 0 ) :
												aFileName.matchIgnoreAsciiCaseAsciiL( aBigImagePrefix, nPrefixLength, 0 );
			if ( !bIgnoreFile )
			{
				Bitmap aBitmap( createBitmap( rUrl ));
				
				// Check if we have a valid bitmap otherwise it can be possible that we can crash!!
				if ( !!aBitmap )
				{
					if ( aBitmap.GetSizePixel() != aSize )
						aBitmap.Scale( aSize, BMP_SCALE_FAST );

					// Add image to the image list which will be used to initialize toolbox
					aBitmapUrls.push_back( rUrl );
					aImages.AddImage( nId, Image( aBitmap, aColor ) );
					aSymbolTb.InsertItem( nId, aUrlObj.getName() );

					if (++nId == 0)
						break;
				}
			}
        }
    }
    
	ImageList*	pOfficeImageList = SfxImageManager::GetGlobalDefaultImageList( 
									bBigImages, pMgr->IsHiContrast() );
	if ( pOfficeImageList )
	{
		for ( sal_Int32 i = 0; i < pOfficeImageList->GetImageCount(); i++ )
		{
            USHORT nImageId = pOfficeImageList->GetImageId(i);
            aSymbolTb.InsertItem( nImageId, aEmptyStr );
            
            aImages.AddImage( nImageId, pOfficeImageList->GetImage( nImageId ));

            if (++nId == 0)
                break;
		}
	}

	// Set imagelist to the toolbox
    aSymbolTb.SetImageList( aImages );

    LeaveWait();
/*
	// Einen Button f"ur reine Textbuttons einf"ugen
	aSymbolTb.InsertItem(nCount+1, "Text");
	aSymbolTb.SetItemImage(nCount+1, Image());
*/
	aOKButton.SetClickHdl( LINK(this,SfxUserBitmapDialog_Impl, OKHdl));
	aSymbolTb.SetSelectHdl(LINK(this,SfxUserBitmapDialog_Impl, SelectHdl));
	aDefaultBtn.SetClickHdl(LINK(this,SfxUserBitmapDialog_Impl, DefaultHdl));
}

SfxUserBitmapDialog_Impl::~SfxUserBitmapDialog_Impl()
{}

void SfxUserBitmapDialog_Impl::ResetToolBoxSelection()
{
	USHORT nCount = aSymbolTb.GetItemCount();
	for (USHORT n=0; n<nCount; n++)
	{
		USHORT nId = aSymbolTb.GetItemId(n);
		if (aSymbolTb.IsItemChecked(nId))
			aSymbolTb.CheckItem(nId, FALSE);
	}
}

Image SfxUserBitmapDialog_Impl::GetDefaultImage( USHORT nFuncId )
{
	String	aEmptyStr;
	Image	aDefaultImage = pImageMgr->GetDefaultImage( nFuncId, 
													  SFX_APP()->GetActiveModule(), 
													  bBigImages, 
													  pMgr->IsHiContrast() );
	if ( !aDefaultImage )
	{
		bNoDefaultImage = TRUE;
		if ( bBigImages )	
			aDefaultImage = Image( SfxResId( IMG_EMPTY_DEFAULT_LARGE ));
		else
			aDefaultImage = Image( SfxResId( IMG_EMPTY_DEFAULT_SMALL ));
	}	

	return aDefaultImage;
}

IMPL_LINK( SfxUserBitmapDialog_Impl, OKHdl, OKButton *, pButton )
{
	BOOL bIdFound = FALSE;

	// Nachsehen, welche Bitmaps selektiert wurde
    USHORT n;
    USHORT nId = 0;
	for (n=0; n<aSymbolTb.GetItemCount(); n++)
	{
		nId = aSymbolTb.GetItemId(n);
		if (aSymbolTb.IsItemChecked(nId))
		{
			bIdFound = TRUE;
			break;
		}
	}

	// If text was changed before write it back. Use the SfxToolBoxManager 
	// to let it write it back to the configuration!
	if ( !bIdFound )
	{
		if ( pToolBox->GetItemText( nFuncId ) != aDescEdit.GetText() )
			pMgr->SetItemText( nFuncId, aDescEdit.GetText() );

		EndDialog(1);
		return 0;
	}

	if ( n == 0 )
	{
		// Special position - means default image!
		pImageMgr->ReplaceImage( nFuncId );
		if ( pToolBox->GetItemText( nFuncId ) != aDescEdit.GetText() )
			pMgr->SetItemText( nFuncId, aDescEdit.GetText() );
	}
	else
	{
		if ( nId >= SID_SFX_START )
		{
			// User selected an internal resource bitmap use it
			// directly from the image list.
			Bitmap aBitmap (aSymbolTb.GetItemImage( nId ).GetBitmap()); 
			pImageMgr->ReplaceImage( nFuncId, &aBitmap );
		}
		else
		{
			Bitmap aBitmap( createBitmap( aBitmapUrls[n] )); 
			
			// Check bitmap before we replace it as it could not be loaded
			if ( !!aBitmap )
				pImageMgr->ReplaceImage( nFuncId, &aBitmap );

			// Change text for this function on this special toolbox
			if ( pToolBox->GetItemText( nFuncId ) != aDescEdit.GetText() )
				pMgr->SetItemText( nFuncId, aDescEdit.GetText() );
		}
	}

	EndDialog(1);
	return 0;
}

IMPL_LINK( SfxUserBitmapDialog_Impl, SelectHdl, ToolBox *, pToolBox )
{
	USHORT nCount = aSymbolTb.GetItemCount();
	for (USHORT n=0; n<nCount; n++)
	{
		USHORT nId = aSymbolTb.GetItemId(n);
		if (aSymbolTb.IsItemChecked(nId))
			aSymbolTb.CheckItem(nId, FALSE);
	}

	USHORT nId = aSymbolTb.GetCurItemId();
	aSymbolTb.CheckItem(nId);
	return 0;
}

IMPL_LINK( SfxUserBitmapDialog_Impl, DefaultHdl, PushButton *, pButton )
{
	// Remove check from old image
	USHORT nId;
	USHORT nCount = aSymbolTb.GetItemCount();
	for (USHORT n=0; n<nCount; n++)
	{
		USHORT nId = aSymbolTb.GetItemId(n);
		if (aSymbolTb.IsItemChecked(nId))
			aSymbolTb.CheckItem(nId, FALSE);
	}

	// Check default image
	nId = 1;
	aSymbolTb.CheckItem(nId);

	SfxSlotPool* pSlotPool = &SFX_SLOTPOOL();
	String		 aItemText;
	const SfxSlot* pSfxSlot = pSlotPool->GetSlot( nFuncId );
	if ( pSfxSlot )
		aItemText = pSlotPool->GetSlotName_Impl( *pSfxSlot );
	else
		aItemText = pToolBox->GetItemText( nFuncId );
	
	aDescEdit.SetText( aItemText );

	return 0;
}

void SfxUserBitmapDialog_Impl::SetFunctionId(USHORT nID)
{
	nFuncId = nID;
	aDescEdit.SetText(pToolBox->GetItemText(nFuncId));
	Image aDefaultImage = GetDefaultImage( nFuncId );

	// Set default image in the imagelist (first pos) and the toolbox
	aSymbolTb.SetItemImage( 1, aDefaultImage );

	ResetToolBoxSelection();
}

void SfxUserBitmapDialog_Impl::SetToolBox(ToolBox& rTbx)
{
	pToolBox = &rTbx;
	aDescEdit.SetText(pToolBox->GetItemText(nFuncId));
}

Bitmap SfxUserBitmapDialog_Impl::createBitmap(rtl::OUString const & rUrl)
{
	SvStream* pStream = utl::UcbStreamHelper::CreateStream( rUrl, STREAM_STD_READ );
    
    Bitmap aBitmap;
	if ( pStream )
	{
		(*pStream) >> aBitmap;
		delete pStream;
	}
	
    // Convert bitmap color depth to match our resource bitmap color depth. Otherwise
    // we will have display problems on the screen. #109421#
    if ( aBitmap.GetBitCount() != nBmpColorDepth )
        aBitmap.Convert( nBmpColorConversion );
    
    return aBitmap;
}

SFX_IMPL_MODELESSDIALOG(SfxToolboxCustomWindow, SID_CUSTOMIZETOOLBOX)

SfxToolboxCustomWindow::SfxToolboxCustomWindow(Window *pParent,
	USHORT nId, SfxBindings *pBindings, SfxChildWinInfo* pInfo) :
	SfxChildWindow(pParent, nId)
{
	pWindow = new SfxToolboxCustomizer( pBindings, this, pParent,
										 SfxResId(RID_TOOLBOXCUSTOMIZE));
	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
	((SfxModelessDialog*)pWindow)->Initialize( pInfo );
}

void SfxToolboxCustomWindow::SelectToolbar( USHORT nType )
{
	((SfxToolboxCustomizer *)pWindow)->SelectToolbar( nType );
}

void SfxToolboxCustomizer::FillInfo( SfxChildWinInfo& rInfo ) const
{
      rInfo.bVisible = FALSE;
}
