/*************************************************************************
 *
 *  $RCSfile: GenericXMLFilter.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: jsc $ $Date: 2001/11/08 16:59:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Martin Gallwey (gallwey@sun.com)
 *
 *
 ************************************************************************/

#ifndef _GENERICXMLFILTER_HXX
#include <GenericXMLFilter.hxx>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_INPUTSOURCE_HPP_
#include <com/sun/star/xml/sax/InputSource.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif

using rtl::OUString;
using com::sun::star::uno::Sequence;
using com::sun::star::uno::Reference;
using com::sun::star::uno::Any;
using com::sun::star::uno::UNO_QUERY;
using com::sun::star::uno::XInterface;
using com::sun::star::uno::Exception;
using com::sun::star::uno::RuntimeException;
using com::sun::star::lang::XMultiServiceFactory;
using com::sun::star::io::XActiveDataSource;
using com::sun::star::io::XOutputStream;
using com::sun::star::beans::PropertyValue;
using com::sun::star::document::XExporter;
using com::sun::star::document::XFilter;

using com::sun::star::io::XInputStream;
using com::sun::star::document::XImporter;
using com::sun::star::xml::sax::InputSource;
using com::sun::star::xml::sax::XDocumentHandler;
using com::sun::star::xml::sax::XParser;

sal_Bool SAL_CALL GenericXMLFilter::importImpl( const Sequence< ::com::sun::star::beans::PropertyValue >& aDescriptor ) 
	throw (RuntimeException)
{
	sal_Int32 nLength = aDescriptor.getLength();
	const PropertyValue * pValue = aDescriptor.getConstArray();
	OUString sFileName;
	Reference < XInputStream > xInputStream;
	for ( sal_Int32 i = 0 ; i < nLength; i++)
	{
		if ( pValue[i].Name.equalsAsciiL ( RTL_CONSTASCII_STRINGPARAM ( "InputStream" ) ) )
			pValue[i].Value >>= xInputStream;
		else if ( pValue[i].Name.equalsAsciiL ( RTL_CONSTASCII_STRINGPARAM ( "FileName" ) ) )
			pValue[i].Value >>= sFileName;
	}
	if ( !xInputStream.is() )
	{
		OSL_ASSERT( 0 );
		return sal_False;
	}
	const OUString sSaxParser ( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.xml.sax.Parser") );
	
	/* The idea is that we could invoke a different export component based on the filter name.
	 * we will default to importing writer documents*/

	OUString sXMLImportService ( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Writer.XMLImporter" ) );

	if ( msFilterName.equalsAsciiL ( RTL_CONSTASCII_STRINGPARAM ( "writer_Flat_XML_File" ) ) )
		sXMLImportService = OUString ( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.Writer.XMLImporter" ) ); 

	/* we might, for example add the following: 
	 
	else if ( msFilterName.equalsAsciiL ( RTL_CONSTASCII_STRINGPARAM ( "calc_Flat_XML_File" ) ) )
		sXMLImportService = OUString ( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.Calc.XMLImporter" ) ); 
	else if ( msFilterName.equalsAsciiL ( RTL_CONSTASCII_STRINGPARAM ( "impress_Flat_XML_File" ) ) )
		sXMLImportService = OUString ( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.Impress.XMLImporter" ) ); 

	  This would allow us to re-use this component for multiple export filters just by changing the TypeDetection
	  file and adding handling for the new filter name here, thus...'GenericXMLFilter' :-> 
	*/

	Reference < XParser > xSaxParser( mxMSF->createInstance( sSaxParser ), UNO_QUERY );
	Reference < XDocumentHandler > xHandler( mxMSF->createInstance( sXMLImportService ), UNO_QUERY );
	Reference < XImporter > xImporter( xHandler, UNO_QUERY );
	xImporter->setTargetDocument ( mxDoc );

	InputSource aInput;
	aInput.sSystemId = sFileName;
	aInput.aInputStream = xInputStream;
	xSaxParser->setDocumentHandler ( xHandler );
	sal_Bool bRet = sal_True;

	try
	{
		xSaxParser->parseStream ( aInput );
	}
	catch( Exception& )
	{
		bRet = sal_False;
	}
	return bRet;
}

sal_Bool SAL_CALL GenericXMLFilter::exportImpl( const Sequence< ::com::sun::star::beans::PropertyValue >& aDescriptor ) 
	throw (RuntimeException)
{
	sal_Int32 nLength = aDescriptor.getLength();
	const PropertyValue * pValue = aDescriptor.getConstArray();
	OUString sFileName;
	Reference < XOutputStream > xOutputStream;
	for ( sal_Int32 i = 0 ; i < nLength; i++)
	{
		if ( pValue[i].Name.equalsAsciiL ( RTL_CONSTASCII_STRINGPARAM ( "OutputStream" ) ) )
		{
			pValue[i].Value >>= xOutputStream;
			break;
		}
	}
	if ( !xOutputStream.is() )
	{
		OSL_ASSERT ( 0 );
		return sal_False;
	}
	const OUString sSaxWriter ( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.xml.sax.Writer") );

	/* The idea is that we could invoke a different export component based on the filter name.
	 * we will default to exporting writer documents*/

	OUString sXMLExportService ( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Writer.XMLExporter" ) );

	if ( msFilterName.equalsAsciiL ( RTL_CONSTASCII_STRINGPARAM ( "writer_Flat_XML_File" ) ) )
		sXMLExportService = OUString ( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.Writer.XMLExporter" ) ); 

	/* we might, for example add the following: 
	 
	else if ( msFilterName.equalsAsciiL ( RTL_CONSTASCII_STRINGPARAM ( "calc_Flat_XML_File" ) ) )
		sXMLExportService = OUString ( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.Calc.XMLExporter" ) ); 
	else if ( msFilterName.equalsAsciiL ( RTL_CONSTASCII_STRINGPARAM ( "impress_Flat_XML_File" ) ) )
		sXMLExportService = OUString ( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.Impress.XMLExporter" ) ); 

	  This would allow us to re-use this component for multiple export filters just by changing the TypeDetection
	  file and adding handling for the new filter name here, thus...'GenericXMLFilter' :-> 
	*/

	Reference < XActiveDataSource > xSaxWriter( mxMSF->createInstance( sSaxWriter ), UNO_QUERY );

	xSaxWriter->setOutputStream( xOutputStream );
	Sequence < Any > aAnys ( 1 );
	aAnys[0] <<= xSaxWriter;
	Reference < XExporter > xExporter( mxMSF->createInstanceWithArguments ( sXMLExportService, aAnys ), UNO_QUERY );
	Reference < XFilter > xFilter( xExporter, UNO_QUERY );
	xExporter->setSourceDocument ( mxDoc );
	return xFilter->filter ( aDescriptor );
}
sal_Bool SAL_CALL GenericXMLFilter::filter( const Sequence< ::com::sun::star::beans::PropertyValue >& aDescriptor ) 
	throw (RuntimeException)
{
	return meType == FILTER_EXPORT ? exportImpl ( aDescriptor ) : importImpl ( aDescriptor );
}
void SAL_CALL GenericXMLFilter::cancel(  ) 
	throw (RuntimeException)
{
}
// XExporter
void SAL_CALL GenericXMLFilter::setSourceDocument( const Reference< ::com::sun::star::lang::XComponent >& xDoc ) 
	throw (::com::sun::star::lang::IllegalArgumentException, RuntimeException)
{
	meType = FILTER_EXPORT;
	mxDoc = xDoc;
}

// XImporter
void SAL_CALL GenericXMLFilter::setTargetDocument( const Reference< ::com::sun::star::lang::XComponent >& xDoc ) 
	throw (::com::sun::star::lang::IllegalArgumentException, RuntimeException)
{
	meType = FILTER_IMPORT;
	mxDoc = xDoc;
}
// XInitialization
void SAL_CALL GenericXMLFilter::initialize( const Sequence< Any >& aArguments ) 
	throw (Exception, RuntimeException)
{
	Sequence < PropertyValue > aAnySeq;
	sal_Int32 nLength = aArguments.getLength();
	if ( nLength && ( aArguments[0] >>= aAnySeq ) )
	{
		const PropertyValue * pValue = aAnySeq.getConstArray();
		nLength = aAnySeq.getLength();
		for ( sal_Int32 i = 0 ; i < nLength; i++)
		{
			if ( pValue[i].Name.equalsAsciiL ( RTL_CONSTASCII_STRINGPARAM ( "Type" ) ) )
			{
				pValue[i].Value >>= msFilterName;
				break;
			}
		}
	}
}
OUString GenericXMLFilter_getImplementationName ()
	throw (RuntimeException)
{
	return OUString ( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.comp.Writer.GenericXMLFilter" ) );
}
#define SERVICE_NAME1 "com.sun.star.document.ExportFilter"
#define SERVICE_NAME2 "com.sun.star.document.ImportFilter"
sal_Bool SAL_CALL GenericXMLFilter_supportsService( const OUString& ServiceName ) 
	throw (RuntimeException)
{
    return ServiceName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM ( SERVICE_NAME1 ) ) ||
    	   ServiceName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM ( SERVICE_NAME2 ) );
}
Sequence< OUString > SAL_CALL GenericXMLFilter_getSupportedServiceNames(  ) 
	throw (RuntimeException)
{
	Sequence < OUString > aRet(2);
    OUString* pArray = aRet.getArray();
    pArray[0] =  OUString ( RTL_CONSTASCII_USTRINGPARAM ( SERVICE_NAME1 ) );
    pArray[1] =  OUString ( RTL_CONSTASCII_USTRINGPARAM ( SERVICE_NAME2 ) );
    return aRet;
}
#undef SERVICE_NAME1
#undef SERVICE_NAME2

Reference< XInterface > SAL_CALL GenericXMLFilter_createInstance( const Reference< XMultiServiceFactory > & rSMgr)
	throw( Exception )
{
	return (cppu::OWeakObject*) new GenericXMLFilter( rSMgr );
}

// XServiceInfo
OUString SAL_CALL GenericXMLFilter::getImplementationName(  ) 
	throw (RuntimeException)
{
	return GenericXMLFilter_getImplementationName();
}
sal_Bool SAL_CALL GenericXMLFilter::supportsService( const OUString& rServiceName ) 
	throw (RuntimeException)
{
    return GenericXMLFilter_supportsService( rServiceName );
}
Sequence< OUString > SAL_CALL GenericXMLFilter::getSupportedServiceNames(  ) 
	throw (RuntimeException)
{
    return GenericXMLFilter_getSupportedServiceNames();
}
