/*************************************************************************
 *
 *  $RCSfile: adrsect.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SV_H
#include <vcl/sv.h>
#endif
#ifndef _SV_CTRL_HXX
#include <vcl/ctrl.hxx>
#endif
#ifndef _SV_DOCKWIN_HXX
#include <vcl/dockwin.hxx>
#endif

#include "adrsect.hxx"

#define SPLIT_HEIGHT	4

long gnLineHeight=0;

AdrSection::AdrSection(const WSString& rName, SvSectionControl* pParent,WinBits nStyle):
		SvSection(rName,pParent,nStyle),
		aScrollBar(this),
		nHeight(0)
{
	if(gnLineHeight==0)
	{
		SvExpander aExpander(this);
		Size aSize=aExpander.GetMinSize();
		gnLineHeight=aSize.Height();
	}

	aScrollBar.SetScrollHdl(LINK( this, AdrSection, ScrollHdl));
	aScrollBar.SetEndScrollHdl(LINK( this, AdrSection, EndScrollHdl));
	aScrollBar.SetLineSize(gnLineHeight);
	aScrollBar.EnableDrag();

	aScrollBar.Show();
}		
		
AdrSection::AdrSection(const WSString& rName, SvSectionControl* pParent, Window* pWin, WinBits nStyle):
		SvSection(rName, pParent, pWin, nStyle),
		aScrollBar(this),
		nHeight(0)
{
	if(gnLineHeight==0)
	{
		SvExpander aExpander(this);
		Size aSize=aExpander.GetMinSize();
		gnLineHeight=aSize.Height();
	}

	aScrollBar.SetScrollHdl(LINK( this, AdrSection, ScrollHdl));
	aScrollBar.SetEndScrollHdl(LINK( this, AdrSection, EndScrollHdl));
	aScrollBar.SetLineSize(gnLineHeight);
	aScrollBar.EnableDrag();

	aScrollBar.Show();
}		


void AdrSection::Resize()
{
	Size aSize=GetOutputSizePixel();
	Size a2Size(aExpander.GetMinSize());
	long nImageWidth=a2Size.Width();
	long nWidth=aSize.Width()-2*nImageWidth;
	long nScrollSize = GetSettings().GetStyleSettings().GetScrollBarSize();
		
	a2Size.Width()=aSize.Width();
	aExpander.SetSizePixel(a2Size);

	ULONG nSpltPos=aSize.Height()-SPLIT_HEIGHT;

   	if(aPrivatSplit.IsVisible())
	{
		aPrivatSplit.SetPosSizePixel(Point(nImageWidth,nSpltPos),
						Size(nWidth,SPLIT_HEIGHT));
		aSize.Height()-=SPLIT_HEIGHT;
	}

	if(GetChildWin()!=NULL)
	{
		long nChildWinHeight = GetMaxHeight() - a2Size.Height()-SPLIT_HEIGHT;
		aScrollBar.SetRange(Range(0,nChildWinHeight));
		long nThumbPos = aScrollBar.GetThumbPos();
		Point aChildWinPos = GetChildWin() -> GetPosPixel();
		aChildWinPos.Y()=-nThumbPos;
		
		if(aChildWinPos != GetChildWin()->GetPosPixel())
			GetChildWin() -> SetPosPixel(aChildWinPos);

		long nScrollHeight = aSize.Height()-a2Size.Height();

		if(nScrollHeight != nChildWinHeight)
		{
			aScrollBar.Show();
			aScrollBar.SetPageSize(nScrollHeight);
			aScrollBar.SetVisibleSize(nScrollHeight);
		
			nWidth -= nScrollSize;

			aScrollBar.SetPosSizePixel(Point(nWidth+nImageWidth,a2Size.Height()),
							Size(nScrollSize,nScrollHeight));
			nWidth -= 3;
		}
		else
		{
			nWidth -= (nScrollSize+3);
			aScrollBar.Hide();
		}
	}

	if(aChildWinContainer.IsVisible())
	{
		aSize.Height()-=aExpander.GetMinSize().Height();
		aSize.Width()=nWidth;
		aChildWinContainer.SetSizePixel(aSize);
		if(GetChildWin()!=NULL)
		{
			Size aChildSize=GetChildWin()->GetSizePixel();
			Size aOldSize(aChildSize);
			if(nWidth + 2*nImageWidth > GetMinWidth()-(nScrollSize+3))
			{
				aChildSize.Width()=aChildWinContainer.GetOutputSizePixel().Width();
			}
			else
			{
				aChildSize.Width()=GetMinWidth()-2*nImageWidth-(nScrollSize+3);
			}

			if(aOldSize != aChildSize)
				GetChildWin()->SetSizePixel(aChildSize);
		}
	}
}

void AdrSection::SetScrollPos(long nPos)
{
	SvSection::SetScrollPos(nPos);
}

long AdrSection::Notify( NotifyEvent& rNEvt )
{
	long nRes = FALSE;

	if(rNEvt.GetType() == EVENT_KEYINPUT)
	{
		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
		
		KeyCode aKeyCode = pKEvt->GetKeyCode();
		USHORT	nKeyCode = aKeyCode.GetCode();

		if ( aKeyCode.IsMod2() )
		{
			if(aScrollBar.IsVisible())
			{
				switch (nKeyCode)
				{
					case KEY_UP:
						nRes = TRUE;
						aScrollBar.DoScrollAction( SCROLL_LINEUP );
						break;
					case KEY_DOWN:
						nRes = TRUE;
						aScrollBar.DoScrollAction( SCROLL_LINEDOWN );
						break;
					case KEY_PAGEUP:
						nRes = TRUE;
						aScrollBar.DoScrollAction( SCROLL_PAGEUP );
						break;

					case KEY_PAGEDOWN:
						nRes = TRUE;
						aScrollBar.DoScrollAction( SCROLL_PAGEDOWN );
						break;
				}
			}
		}
	}

	if(!nRes)
	{
		nRes = SvSection::Notify(rNEvt );
	}
	return nRes;
}

IMPL_LINK( AdrSection, ScrollHdl, ScrollBar*,pSb)
{
	if(pSb!=NULL)
	{
		long nThumbPos = pSb->GetThumbPos();

		if(&aScrollBar==pSb)
		{
			long nDelta=aScrollBar.GetDelta();
			aChildWinContainer.Scroll(0,-nDelta,SCROLL_CHILDREN);
			if(GetChildWin()!=NULL)
			{
				Point aPos= GetChildWin()->GetPosPixel();
				aPos.Y() = -nThumbPos;
				GetChildWin()->SetPosPixel(aPos);
			}
		}
	}
	return 0;
}

IMPL_LINK( AdrSection, EndScrollHdl, ScrollBar*,pSb)
{
	if(pSb!=NULL)
	{
		long nThumbPos = pSb->GetThumbPos();

		if(&aScrollBar==pSb)
		{
			if(nThumbPos==0)
			{
				//nRealHeight= CalcRealHeight();
				Resize();
			}
		}
	}
	return 0;
}

