/*************************************************************************
 *
 *  $RCSfile: layerupdate.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jb $ $Date: 2002/05/28 15:39:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "layerupdate.hxx"

#ifndef CONFIGMGR_BACKEND_UPDATEDATA_HXX
#include "updatedata.hxx"
#endif
#ifndef CONFIGMGR_CONFIGPATH_HXX_
#include "configpath.hxx"
#endif

namespace configmgr
{
// -----------------------------------------------------------------------------
    namespace backend
    {
// -----------------------------------------------------------------------------

LayerUpdate::LayerUpdate()
: m_xContextNode()
{
}
// -----------------------------------------------------------------------------

LayerUpdate::LayerUpdate(LayerUpdate const & _aOther)
: m_xContextNode(_aOther.m_xContextNode)
, m_aContextPath(_aOther.m_aContextPath)
{
}
// -----------------------------------------------------------------------------

LayerUpdate::~LayerUpdate()
{
}
// -----------------------------------------------------------------------------

LayerUpdate & LayerUpdate::operator =(LayerUpdate const & _aOther)
{
    m_xContextNode = _aOther.m_xContextNode;
    return *this;
}
// -----------------------------------------------------------------------------
            
void LayerUpdate::setContextNode(NodeUpdateRef const & _xContextNode)
{
    m_xContextNode = _xContextNode;
    if (_xContextNode.is())
        makeContextPath(_xContextNode->getName());

    else
        m_aContextPath.clear();
}
// -----------------------------------------------------------------------------
            
void LayerUpdate::makeContextPath(OUString const & _aPath)
{
    using configuration::AbsolutePath;
    AbsolutePath const aParsedPath = configuration::AbsolutePath::parse(_aPath);

    m_aContextPath.clear();
    m_aContextPath.reserve( aParsedPath.getDepth() );
    for (AbsolutePath::Iterator it = aParsedPath.begin(); it != aParsedPath.end(); ++it)
    {
        m_aContextPath.push_back( it->getName().toString() );
    }
}
// -----------------------------------------------------------------------------

NodeUpdateRef   LayerUpdate::getContextNode() const 
{ 
    return m_xContextNode; 
}
// -----------------------------------------------------------------------------

LayerUpdate::ContextPath const & LayerUpdate::getContextPath() const
{
    OSL_PRECOND( m_xContextNode.is(), "Cannot get context path without context node" );
    
    return m_aContextPath;
}
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
    } // namespace backend

// -------------------------------------------------------------------------
} // namespace configmgr
