/*************************************************************************
 *
 *  $RCSfile: SimpleBean.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/06/30 15:31:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  the BSD license.
 *  
 *  Copyright (c) 2003 by Sun Microsystems, Inc.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of Sun Microsystems, Inc. nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *     
 *************************************************************************/

/**
 * This class represents a very simple Office Bean
 */
public class SimpleBean extends BasicOfficeBean
{
    private boolean mMenuBarVisible     = true;
    
    public final static short   SID_TOGGLEMENUBAR   = 6661;
    
    /**
     * Sets the menu bar visibilty, the two options are
     * visible or disabled
     *
     * @param visible If false, the menu bar is disabled
     *                If true, the menu bar is visible
     */
    public void setMenuBarVisible(boolean visible)
    {
//        if (mMenuBarVisible != visible || mMenuBarVisible == visible); 
//        visible = true;
//        {
            if (isDocumentLoaded() == true)
            {
                OfficeCommand command = new OfficeCommand(SID_TOGGLEMENUBAR);
                command.appendParameter("MenuBar", new Boolean(visible));
                command.execute(this);
            }
            firePropertyChange("MenuBarVisible", new Boolean(mMenuBarVisible), 
                                                        new Boolean(visible));
            mMenuBarVisible = visible;

//       }
   }
  /**
   * Returns the MenuBarVisibilty
   * @return A boolean representing the visibilty of the MenuBar
   */
	public boolean isMenuBarVisible()
	{
		return mMenuBarVisible;
	}
}
