'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_layout_regression.bas,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: fredrikh $ $Date: 2008/02/18 10:12:22 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Load all files which crashed or looped because of layout problems
'*
'\***********************************************************************

global SourceDocument(200 ) as String

sub main

    use "writer\tools\inc\w_tools.inc"
    use "writer\loadsave\inc\w_layout_regression.inc"

    Dim StartZeit, SourcePath as string
    StartZeit = Now()

    SourcePath = ConvertPath(gtesttoolpath + "sun_writer\regression\input\layout")   
    printlog SourcePath
    if hDirectoryExists(SourcePath) = false then        
        Warnlog "Unable to find document directory! Please adapt 'SourcePath'"
        goto EarlyExit
    endif    
    
    Call hStatusIn ( "writer", "w_layout_regression.bas" )
    Call wSetMacroSecurityLevel(4)
    Call tLoadAllDocuments ( SourcePath )
    Call wSetMacroSecurityLevel(3)
    Call hStatusOut

    EarlyExit:
    Printlog Chr(13) + "End of Import - Test :"
    Printlog "Duration: "+ WieLange ( StartZeit )
    Printlog "Date: " +  Date + "    Time: " + Time

end sub

' **********************************

sub LoadIncludeFiles
    use "global\system\inc\master.inc"
    use "global\system\inc\gvariabl.inc"
    use "global\tools\inc\t_dir.inc"
    use "global\tools\inc\t_lists.inc"
    Call GetUseFiles
    gApplication = "Writer"
end sub




