'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_cell_tools.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: oc $ $Date: 2007/08/22 08:15:50 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : oliver.craemer@sun.com
'*
'* short description : tools for working with cells in calc
'*
'**************************************************************************************************
'*
' #1 fCalcGetCellValue            'Returns the value of a given cell
' #1 fCalcCompareCellValue        'Compares the value of a given cell with a given result
' #1 fCalcCompareCellFormular     'Compares the formular of a cell with a given result
'*
'\************************************************************************************************

function fCalcGetCellValue ( sCelladdress as string ) as string

    '///<b>The function returns the content of a given cell</b>
    '///+The cell is selected by fCalcSelectRange which is located in /spreadsheet/tools/c_select_tools.inc
    '///+The content is copied to the clipboard by slot EditCopy
    '///+   and read out by GetClipboardText which is located in /global/tools/inc/t_tools1.inc
    use "spreadsheet\tools\c_select_tools.inc"
    use "global\tools\inc\t_tools1.inc"
    
    call fCalcSelectRange (sCelladdress)   'Select the given cell
    kontext "DocumentCalc"                 'Setting kontext to Calcdocument
    EditCopy                               'Copy content to clipboard
    fCalcGetCellValue = GetClipboardText   'Returning clipboard to function    

end function

'-------------------------------------------------------------------------

function fCalcCompareCellValue ( sCelladdress as string, sresult as string ) as boolean

    '///<b>The function compares the value of a cell with a given result</b>
    '///+The cellvalue is read by fCalcGetCellValue which is located in /spreadsheet/tools/c_cell_tools.inc
    '///+The value is compared with a given result (input)
    '///+The function returns true if the comparison is correct and false for incorrect    

    if fCalcGetCellValue ( sCelladdress ) = sresult then
        printlog "  The cellvalue is correct"
        fCalcCompareCellValue = true
    else
        warnlog "The cellvalue is " & fCalcGetCellValue ( sCelladdress ) & " but should be " & sresult
        fCalcCompareCellValue = false
    endif

end function

'-------------------------------------------------------------------------

function fCalcCompareCellFormular ( sCelladdress as string, sresult as string ) as boolean

    '///<b>The function compares the formular of a cell with a given result</b>
    '///+The value is compared with a given result (input)
    '///+The function returns true if the comparison is correct and false for incorrect
    
    dim sfunctionwithparameter as string
    
    call fCalcSelectRange (sCelladdress)
    kontext ( "RechenleisteCalc" ) 
    EingabeZeileCalc.TypeKeys ("<f2><mod1 a>")
    editcopy
    sfunctionwithparameter = GetClipboardText ()
    '/// Press twice <ESCAPE> to leave the cell
    'printlog "Press twice <ESCAPE> to leave the cell"
    kontext ( "DocumentCalc" )
    DocumentCalc.TypeKeys "<ESCAPE>" , 2
    if sfunctionwithparameter = sresult then
        printlog "  The function is correct"
        fCalcCompareCellFormular = true
    else
        warnlog "The function is " & sfunctionwithparameter & " instead of " &  sresult
        fCalcCompareCellFormular = false
    endif
    
end function
