'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: NewSortingAlgorithmForJapanese_1.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: tbo $ $Date: 2006/05/09 09:17:43 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : hercule.li@sun.com
'*
'* short description : New Sorting Algorithm For Japanese Test
'*
'************************************************************************
'*
' #1 NewSortingForJapanese_1
' #1 NewSortingForJapanese_2
' #1 NewSortingForJapanese_3
' #1 NewSortingForJapanese_4
' #1 NewSortingForJapanese_5
'*
'\***********************************************************************

testcase NewSortingForJapanese_1

'///Check if editbox "Entry Phonetic Reading " appear or not -- insert/index and tables /entry
  call  hNewDocument

  '/// turn off "Asian Language support" , check if editbox "Entry Phonetic Reading " appear is invisible
  if iSystemSprache <> 81 AND iSystemSprache <> 82 AND iSystemSprache <> 86 AND iSystemSprache <> 88 then
     Call CheckAsianLanguageSupport("Off")
     Sleep 1

      Kontext
      Sleep 3
      InsertIndexesEntry
      Sleep 2
      Kontext "VerzeichniseintragEinfuegen"
      Sleep 1
        Verzeichniseintrag.SetText "test"
        if EntryPhoneticReading.IsVisible = TRUE then warnlog "The Entry Phonetic Reading editbox should NOT be visible!"
      VerzeichniseintragEinfuegen.Close
  end if

  '/// turn on "Asian Language support" , check if editbox "Entry Phonetic Reading " appear is visible
  Call CheckAsianLanguageSupport("On")

   Kontext
   Sleep 3
   InsertIndexesEntry
   Sleep 2
   Kontext "VerzeichniseintragEinfuegen"
   Sleep 1
     Verzeichniseintrag.SetText "test"
     if EntryPhoneticReading.IsVisible <> TRUE then warnlog "The Entry Phonetic Reading editbox should be visible!"
   VerzeichniseintragEinfuegen.Close

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase NewSortingForJapanese_2

'/// Check if editbox "Entry Phonetic Reading " is enabled or not  -- insert/index and tables /entry
  call  hNewDocument

   InsertIndexesEntry
   Sleep 3
   Kontext "VerzeichniseintragEinfuegen"
   Sleep 2
     if EntryPhoneticReading.IsEnabled = TRUE then warnlog "The Entry Phonetic Reading editbox should NOT be enabled!"

     Verzeichniseintrag.SetText "test"

     if EntryPhoneticReading.IsEnabled <> TRUE then warnlog "The Entry Phonetic Reading editbox should be enabled!"
   VerzeichniseintragEinfuegen.Close

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase NewSortingForJapanese_3

  Dim iTypeList , iNumberOfKeyType as Integer
  Dim sJapaneseLocation            as String
  Dim i as integer

  iTypeList         = 2
  iNumberOfKeyType  = 4
  sJapaneseLocation = fGetCountryName(81)

  if Len(sJapaneseLocation) = 0 then Goto endsub

'/// Check the number of key type in sort area when choose japanese language
  call  hNewDocument

'/// Open with Insert/Index and tables/Index and tables / tabpage index/table
    InsertIndexes
    Kontext
    Active.SetPage TabVerzeichnisseVerzeichnis
    Kontext "TabVerzeichnisseVerzeichnis"

'/// choose Alphabetical index in type and choose Japanese Language
    VerzeichnisTyp.Select iTypeList
    try
        SortLanguage.Select (sJapaneseLocation)
    catch
        qaErrorLog "Entry not found: '" + sJapaneseLocation + "' trying english entry: 'Japanese'"
        try
            SortLanguage.Select ("Japanese")
        catch
            warnlog "'Japanese' isn't available either"
            for i = 1 to SortLanguage.getItemCount
                printlog "" + i + ": '" + SortLanguage.getItemText(i) + "'"
            next i
        endcatch
    endcatch
    Sleep 1

'/// Check the number of key type in sort area
    if SortKeyType.GetItemCount <> iNumberOfKeyType then
       warnlog "The number of key type is wrong, hope :" +iNumberOfKeyType + " but get:" +SortKeyType.GetItemCount
    end if
try
    TabVerzeichnisseVerzeichnis.Cancel
catch
warnlog "#135631# crash on canceling Insert Indexes and Tables"
endcatch
  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase NewSortingForJapanese_4

  Dim iNumberOfKeyType   as Integer
  Dim sJapaneseLocation  as String

  iNumberOfKeyType  = 4
  sJapaneseLocation = fGetCountryName(81)

  if Len(sJapaneseLocation) = 0 then Goto endsub

'/// Check the number of key type in data/sort
  call  hNewDocument
  DocumentWriter.TypeKeys "test"
  DocumentWriter.TypeKeys "<Shift Home>"

'/// Open Tools/Sort
  ToolsSort
    Kontext "Sortieren"

'/// choose Alphabetical index in type and choose Japanese Language
    try
        Sprache.Select  sJapaneseLocation
    catch
        qaErrorLog "Entry not found: '" + sJapaneseLocation + "' trying english entry: 'Japanese'"
        try
            Sprache.Select ("Japanese")
        catch
            warnlog "'Japanese' isn't available either"
            for i = 1 to Sprache.getItemCount
                printlog "" + i + ": '" + Sprache.getItemText(i) + "'"
            next i
        endcatch
    endcatch
    Sleep 1

'/// Check the number of key type in sort area
    if Schluesseltyp1.GetItemCount <> iNumberOfKeyType then
       warnlog "The number of key type is wrong, hope :" +iNumberOfKeyType + " but get:" +Schluesseltyp1.GetItemCount
    end if

    Sortieren.Cancel

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase NewSortingForJapanese_5

  Dim iNumberOfOption    as Integer
  Dim sJapaneseLocation  as String

  iNumberOfOption   = 3
  sJapaneseLocation = fGetCountryName(81)

  if Len(sJapaneseLocation) = 0 then Goto endsub

'/// Check the number of key type in data/sort -- Calc
  call  hNewDocument

'/// Open Data/Sort  ,tabpage option
   DataSort
   Kontext
   active.SetPage TabSortierenOptionen
   Kontext "TabSortierenOptionen"

'/// choose Alphabetical index in type and choose Japanese Language
    try
        Sprache.Select  sJapaneseLocation
    catch
        qaErrorLog "Entry not found: '" + sJapaneseLocation + "' trying english entry: 'Japanese'"
        try
            Sprache.Select ("Japanese")
        catch
            warnlog "'Japanese' isn't available either"
            for i = 1 to Sprache.getItemCount
                printlog "" + i + ": '" + Sprache.getItemText(i) + "'"
            next i
        endcatch
    endcatch
    Sleep 1

'/// Check the number of key type in sort area
    if Optionen.GetItemCount <> iNumberOfOption then
       warnlog "The number of option is wrong, hope :" +iNumberOfOption + " but get:" +Optionen.GetItemCount
    end if

    TabSortierenOptionen.Cancel

  Call hCloseDocument

endcase

'-------------------------------------------------------------------------
