'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: help.inc,v $
'*
'*  $Revision: 1.18 $
'*
'*  last change: $Author: jsk $ $Date: 2008/01/03 14:23:30 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : 
'*
'*******************************************************************************
' **
' #1 tHelpRessourceTest  ' travels through the index and loads all pages.
' **
'\******************************************************************************

testcase tHelpRessourceTest( iCurrentAboutItem as integer )

    '///<h1>Ressourcetest for OpenOffice.org help viewer</h1>

    dim iTopicCount as integer
    dim iCurrentTopic as integer
    dim cCurrentTopic as string
    dim cPreviousTopic as string
    dim cCurrentAboutItem as string
    dim brc as boolean
   
    '///<i>help.bas::tHelpRessourceTest</i><br>
    '///<ul>
    '///+<li>Open help</li>
    brc = hOpenHelp()
    if ( not brc ) then
        warnlog( "Help not open, aborting test" )
        goto endsub
    endif

    '///+<li>Switch to the index tabpage</li>
    brc = hSelectHelpTab( "index" )
    if ( not brc ) then
        warnlog( "There was a problem switching to the index tabpage" )
    endif

    '///+<li>Set and printout the current application for which to display the index</li>
    Kontext "IndexPage"
    HelpAbout.select( iCurrentAboutItem )
    sleep( 3 )

    '///+<li>Retrieve the text from the Multilistbox</li>
    cCurrentAboutItem = HelpAbout.getSelText()
    printlog( " " )
    printlog( " * Current Application: " & cCurrentAboutItem )

    '///+<li>Get number of entries in combo-box (help topics)</li>
    iTopicCount = SearchIndex.getItemcount()
    printlog( "For this application " & iTopicCount & " pages will be loaded." )
    printlog( " " )

    '///+<li>Open every item in the index, one by one, give enough time to load</li>
    '///<ul>
    cPreviousTopic = "<not yet set>"
    for iCurrentTopic = 1 to iTopicCount 

        try
            '///+<li>select one item from the list</li>
            SearchIndex.Select( iCurrentTopic )
            
            '///+<li>Retrieve the name of the entry</li>
            cCurrentTopic = SearchIndex.getSelText() 
            'printlog( " - " & cCurrentTopic )    
        catch
            warnlog( "Failed to select entry at " & iCurrentTopic )
            printlog( "Previous entry: " & cPreviousTopic )
            exit for
        endcatch

        try
            '///+<li>Click the "Display" button</li>
            DisplayIndex.click()
            WaitSlot( 5000 )
        catch
            warnlog( "Failed to display index item (fatal):" )
            printlog( " - Index...........: " & iCurrentTopic  )
            printlog( " - Topic (current).: " & cCurrentTopic  )
            printlog( " - Topic (previous): " & cPreviousTopic )
            call ExitRestartTheOffice
            goto endsub
        endcatch
      
       
        cPreviousTopic = cCurrentTopic

    next iCurrentTopic
    '///</ul>

    '///+<li>Close the help-viewer</li>
    brc =  hCloseHelp()
    if ( not brc ) then
        warnlog( "There was a problem closing the help viewer" )
    endif
   
    '///+<li>Exit and restart the office</li>
    call ExitRestartTheOffice()
    '///</ul>
   
endcase


