'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_folders6.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsk $ $Date: 2007/04/05 11:41:25 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog 
'*
'*******************************************************************************
' **
' #1 tUpOneLevel3  ' Jump to filesystem root directly using pathseparator 
' **
'\*****************************************************************************

testcase tUpOneLevel3
    
    '///<h1>Jump to the filesystem root using pathseparator</h1>
    '///+<i>Note that his is performed four times due to a bug that existed in 
    '///+ the past.<br>
    '///+Windows and Unix interpret the pathseparator differently so this test 
    '///+ provides handling of all four combinations (win + /, win + \, unx + / 
    '///+ and unx + \)</i><br>
    '///<ul>
    
    ' We always want to start in a fixed directory structure so the first few dirnames are 
    ' known an can be used for verification
    dim cStartDir as string
        cStartDir = gTesttoolPath & "framework\filedlg\input\filetest\level1\level2\level3"
        cStartDir = convertpath( cStartDir )
        printlog( "Start-Directory is: " & cStartDir )
        
    ' Find out how many items the array for pathnames must hold (do not use gTesttoolPath here)
    dim iDirLevels as integer
        iDirLevels = hGetDirTreeLevel( cStartDir ) + 2
        
    ' Get the list of directories within the path
    dim cPathArray( iDirLevels ) as string
        iDirLevels = DirNameList( cStartDir , cPathArray() ) 
        
    ' Create an array for the two pathseparators - Windows and Unix/Linux
    dim cPathSeparator( 2 ) as string
        cPathSeparator( 1 ) = "\"
        cPathSeparator( 2 ) = "/"
        
    ' Some increment variables
    dim iPathSeparator as integer
    dim iPathRepeat as integer

    ' Variables needed to verify that we are a filesystem root
    dim iFileOpenItemCount as integer
    dim cCurrentPath as string
    dim iObjectPosition as integer
    
    ' Needed for bug (see below)
    const REPEAT_COUNT = 4
        
    '///+<li>Open the FileOpen dialog</li>
    FileOpen
    
    '///+<li>Change to the start-directory: ..framework\filedlg\input\filetest\level1\level2\level3</li>
    kontext "OeffnenDlg"
    DateiName.setText( cStartDir )
    Oeffnen.click()
    
    '///+<li>For both pathseparators (/ and \) do:</li>
    '///<ul>
    for iPathSeparator = 1 to 2
    
        printlog( "" )
        printlog( "Trying: " & cPathSeparator( iPathSeparator ) )
    
        '///<li>Repeat this four times (ancient bug, possible crash)</li>
        '///<ul>
        printlog( "Note: This is repeated four times due to ancient bug" )
        for iPathRepeat = 1 to REPEAT_COUNT
        
            '///+<li>Enter the pathseparator into the filename field</li>
            Dateiname.setText( cPathSeparator( iPathSeparator ) )
        
            '///+<li>Click &quot;open&quot;</li>
            Oeffnen.click()
            
            select case iPathSeparator
            case 1: ' backslash
            
                ' This is Unix, Linux
                if ( gPlatGroup = "unx" ) then
                
                    '///+<li>Handle the messagebox (Unix only)</li>
                    kontext "Active"
                    if ( active.exists() ) then
                        active.ok()
                        printlog( "Messagebox for Unix and \ present." )
                    else
                        warnlog( "Error missing for invalid pathspec." )
                    endif

                    '///+<li>- Verify that the directory has not changed for Unix</li>  
                    ' in the ../level3-directory we look for the file filetest.txt
                    kontext "OeffnenDlg"
                    cCurrentPath = hGetFirstNameFromFileList()
                    if ( cCurrentPath <> "filetest.txt" ) then
                        warnlog( "Path should not have changed." )
                    else
                        printlog( "Still in same directory, ok." )
                    endif
                
                else ' Windows, eComStation
                
                    '///+<li>- Verify that we are a the virtual root (drives list) on windows</li>                    
                    kontext "OeffnenDlg"
                    cCurrentPath = hGetFirstNameFromFileList()
                    if ( cCurrentPath <> "a:\" ) then
                        if ( iPathRepeat = 1 ) then
                            qaerrorlog( "Did not reach virtual root or no drive a:\ present" )
                        else 
                            warnlog( "Did not reach virtual root or no drive a:\ present" )
                        endif
                    else
                        printlog( "Switched to virtual root: a:\ - drive. ok" )
                    endif
                    
                endif
                
            case 2: ' slash
            
                ' Unix/Linux
                if ( gPlatGroup = "unx" ) then
    
                    '///+<li>- Verify that we are at top level of the drive</li>
                    ' Note: cPathArray( 1 ) = / so we need second element
                    '       Additionally we have a trailing slash that must be killed
                    cCurrentPath = left( cPathArray( 2 ) , len( cPathArray( 2 ) ) - 1 )
                    kontext "OeffnenDlg"
                    iObjectPosition = hFindFileObjectViaFileOpen( cCurrentPath )
                    if ( iObjectPosition <> 0 ) then
                        printlog( "Root for gTesttoolPath could be found. Good" )
                    else
                        warnlog( "Top directory of gTesttoolPath could not be found" )
                        printlog( "This probably means we are not at the root dir" )
                    endif
                    
                else ' Windows, eComStation

                    '///+<li>- Verify that we are a the virtual root (drives list) on windows</li>                    
                    kontext "OeffnenDlg"
                    cCurrentPath = hGetFirstNameFromFileList()
                    if ( cCurrentPath <> "a:\" ) then
                        warnlog( "Did not reach virtual root or no drive a:\ present" )
                    else
                        printlog( "Switched to virtual root: a:\ - drive. ok" )
                    endif
                    
                endif
                
            end select
            
        next iPathRepeat
        '///</ul>
        
    next iPathSeparator
    '///</ul>
    
    kontext "OeffnenDlg"
    OeffnenDlg.cancel()
    '///+<li>Cancel the FileOpen dialog</li>
    '///</ul>

endcase


