'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: extras_table_autoformat.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsk $ $Date: 2007/07/30 08:58:55 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Test the autoformat-feature for tables
'*
'*******************************************************************************
'**
' #1 tAutoformatTable ' Test the autoformat-feature for tables in Writer and Calc
'**
'\******************************************************************************

testcase tAutoformatTable( iApp as integer )

    '///<h1>Autoformats for tables in Writer and Calc</h1>
    '///<ul>
    
    dim al_UI_formats( 1000 ) as string
        al_UI_formats( 0 ) = "0"
    
    dim iFormatCount as integer
    dim iCurrentFormat as integer
    dim cCurrentFormat as string
    
    dim irc as integer
    
    dim sFileOut as string
    dim sFile as string
    dim sFileIn as string
        sFileIn = gTesttoolPath & "framework/extras/input/formats"
    
    dim oControl as object
            
    ' Build the filenames         
    select case iApp
    case 1 : sFile = "tables_writer_" & gISOLang & ".txt"
    case 2 : sFile = "tables_calc_" & gISOLang & ".txt"
    case default :  warnlog( "Invalid Application - Writer or Calc allowed" )   
                    goto endsub
    end select
    
    sFileIn = hGetInputPath( sFileIn, sFile )
    sFileOut = hGetWorkPath() & sFile
    
    '///+<li>Open a new document - Writer or Calc</li>
    hCreateDocument()
    
    '///+<li>Depending on the doctype create a table to work on</li>
    select case iApp
    case 1 : kontext "DocumentWriter"
             hTabelleEinfuegen()
    case 2 : kontext "DocumentCalc"
             DocumentCalc.TypeKeys( "<Shift Right>", 5 )
             DocumentCalc.TypeKeys( "<Shift Down>", 3 )
    end select
    
    '///+<li>Open the table autoformat dialog</li>
    FormatAutoformat
    
    select case iApp
    case 1 :    kontext "AutoformatTabelle"
                if ( AutoformatTabelle.exists( 2 ) ) then
                    oControl = FormatBox
                else
                    warnlog( "Unable to access Table Autoformat dialog (Writer)" )
                    goto endsub
                endif
                
    case 2 :    kontext "AutoformatCalc"
                if ( AutoformatCalc.exists( 2 ) ) then
                    oControl = FormatListe
                else
                    warnlog( "Unable to access Table Autoformat dialog (Calc)" )
                    goto endsub
                endif
    end select
    
    '///+<li>Get the number of items from the list</li>
    iFormatCount = oControl.getItemCount()
    
    '///+<li>Compile a list of the autoformat names</li>
    '///<ul>
    for iCurrentFormat = 1 to iFormatCount
    
        '///+<li>Select the (next) format name from the list</li>
        oControl.select( iCurrentFormat )
        
        '///+<li>Retrieve the name of the current item and store it into a list 
        cCurrentFormat = oControl.getSelText()
        ListAppend( al_UI_formats() , cCurrentFormat )
        
    next iCurrentFormat
    '///</ul>
        
    '///+<li>Close the autoformat dialog</li>
    select case iApp
    case 1 : AutoformatTabelle.ok()
    case 2 : AutoformatCalc.ok()
    end select
    
    '///+<li>Close the document</li>
    hDestroyDocument()
    
    '///+<li>Compare the list against the reference file</li>
    irc = hManageComparisionList( sFileIn, sFileOut, al_UI_formats() )
    if ( irc <> 0 ) then
        warnlog( "The list of table autoformats has changed, please review." )
    else
        printlog( "The list of table autoformats is unchanged. Good." )
    endif
    '///</ul>
    
endcase
        
    


