'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: extras_labels.inc,v $
'*
'*  $Revision: 1.7 $
'*
'*  last change: $Author: jsk $ $Date: 2007/07/18 12:59:02 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.co
'*
'*  short description : test names of labels
'*
'*******************************************************************************
'**
' #1 tLabelTypes() ' Verify that all brands and types of labes are present
'**
'\******************************************************************************

testcase tLabelTypes()

    '///<h1>Localization test for labels: Branding and types</h1>
    '///<i>This test opens the labels dialog and compares the list of labels
    '///+ with their brands and associated types agains a reference list.</i><br>
    '///<ul>
    
    dim iBrandCount as integer
    dim iCurrentBrand as integer
    dim cBrandName as string
    
    dim iTypeCount as integer
    dim iCurrentType as integer
    dim cTypeName as string
    
    dim cBrandType as string
    
    dim al_UI_Labels( 1600 ) as string
        al_UI_Labels( 0 ) = "0"
        
    dim irc as integer
    
    dim sFile as string
        sFile = "labels_" & gISOLang & ".txt"

    dim sFileIn as string
        sFileIn = gTesttoolPath & "framework/extras/input/formats"
        sFileIn = hGetInputPath( sFileIn, sFile )

    dim sFileOut as string
        sFileOut = hGetWorkPath() & sFile
       
    
    '///+<li>Open the labels-dialog (suggested way: File->New->Labels)</li>
    hCreateLabels()

    '///+<li>Switch to the Labels-Tab (which is the default)</li>
    kontext
    Active.SetPage TabEtiketten
    
    kontext "TabEtiketten"

    '///+<li>Find out how many brands are listed (might be language dependent)</li>
    iBrandCount = Marke.getItemCount()

    '///+<li>Collect the types for each brand</li>
    '///<ul>
    for iCurrentBrand = 1 to iBrandCount
    
        '///+<li>Select brand</li>
        Marke.select( iCurrentBrand )
        
        '///+<li>Retrieve brand name</li>
        cBrandName = Marke.getSelText()
        
        '///+<li>Count the number of types for the current brand</li>
        iTypeCount = Typ.getItemCount()
        
        '///+<li>Retrieve the list of types</li>
        '///<ul>
        for iCurrentType = 1 to iTypeCount
        
            '///+<li>Select the next type</li>
            Typ.select( iCurrentType )
        
            '///+<li>Get the name of the current type</li>
            cTypeName = Typ.getSelText()
            
            '///+<li>Build the list - format is: &quot;Brand:Type&quot;</li>
            cBrandType = cBrandName & ":" & cTypeName
            ListAppend( al_UI_Labels() , cBrandType )
            
        next iCurrentType
        '///</ul>
    
    next iCurrentBrand
    '///</ul>

    '///+<li>Close the label dialog</li>    
    TabEtiketten.Cancel()

    '///+<li>Compare the list against the reference list</li>
    irc = hManageComparisionList( sFileIn, sFileOut, al_UI_Labels() )
    if ( irc <> 0 ) then
        warnlog( "The list of labels (Brand/Types) has changed, please review." )
    else
        printlog( "The lists of labels are unchanged. Good." )
    endif
    '///</ul>
    
endcase
