'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_modules.inc,v $
'*
'*  $Revision: 1.13 $
'*
'*  last change: $Author: jsk $ $Date: 2007/12/17 09:35:03 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Edit several modules and dialogs in basic ide
'*
'*******************************************************************************
'**
' #1 tMore_Modules_Dialogs  ' create 10 modules, 10 dialogs, delete all new modules/dialogs and delete the last one
'**
'\******************************************************************************


testcase tMore_Modules_Dialogs

    '///<h1>Work with macros - create multiple modules</h1>
    '///<ul>

    dim brc as boolean
    
    dim iCurrentTab as integer

    dim cFile as string 
    cFile = gOfficePath & "user\work\basic" & hGetSuffix( "current" )
    cFile = convertpath( cFile )

    'const iTABCOUNT is the number of dialogs and modules.
    'If iTABCOUNT = 10 then 20 tabs (+ the first one!) = 21 should be created.

    const iTABCOUNT as Integer = 10
    const CMODULE = "TTMODULE"
    
    '///+<li>Delete workfile just in case it was left over by prior testrun</li>
    hDeleteFile( cFile )
    
    '///+<li>Create a new Writer document.</li>
    printlog "open a new writer-doc"
    gApplication = "WRITER"
    hCreateDocument()
    
    '///+<li>Create a new module for the new document (named TTModule)</li>
    brc = hInitBasicIDE( CMODULE )
    
    '///+<li>Insert 10 modules.</li>
    printlog "insert 10 modules"

    for iCurrentTab = 1 to iTABCOUNT
        printlog "   - insert new module : " & iCurrentTab

        kontext "basicide"
        Tabbar.OpenContextMenu
        hMenuSelectNr(1)
        hMenuSelectNr(1)
        brc = hDeleteMacro()
        if ( brc ) then
            EditWindow.TypeKeys "'# " & ( iCurrentTab + 1 ) & ". module in this document"
        endif
    next iCurrentTab

    '///+<li>Insert 10 dialogs</li>
    printlog "insert 10 dialogs"

    for iCurrentTab = 1 to iTABCOUNT
        printlog "   - insert new dialog : " & iCurrentTab
        Tabbar.OpenContextMenu
        hMenuSelectNr(1)
        hMenuSelectNr (2)

        if DialogWindow.Exists (2) <> TRUE then
            warnlog "No dialog window is shown!"
        end if

    next iCurrentTab

    '///+<li>Close the BasicIDE.</li>
    printlog Chr(13) + "- close the BasicIDE"
    hCloseBasicIDE()
    
    '///+<li>Save the document.</li>
    printlog Chr(13) + "- save the document"
    Call hSaveFile( cFile, "current", true, true )
    
    '///+<li>Close the document</li>
    printlog Chr(13) + "- close the document"
    hDestroyDocument()
    
    '///+<li>Open the saved document</li>
    printlog Chr(13) + "- open the saved document"
    hLoadFile ( cFile )

    '///+<li>Open the BASIC Organizer, select the module for the current document</li>
    ToolsMacro_uno
    kontext "Makro"
    hSelectNodeByName( MakroAus , CMODULE )

    '///+<li>Select the last module and open the BASIC IDE.</li>
    Bearbeiten.Click()
    
    '///+<li>Delete all modules and dialogs.</li>
    printlog "delete all modules and dialogs"

    for iCurrentTab = 1 to ( 2 * iTABCOUNT + 1 )

        try
            printlog "delete  - " & iCurrentTab & "/" & ( 2 * iTABCOUNT + 1 )
            UseBindings

            kontext "basicide"
            Tabbar.OpenContextMenu
            
            hMenuSelectNr( 2 )

            kontext "active"

            if Active.Exists then
                Active.Yes
            else
                warnlog "No warning after deleting a dialog!"
            end if

        catch
            QAErrorLog "Deleting  - " & iCurrentTab & "/" & ((2 * iTABCOUNT)+1) & " failed."
        endcatch

    next iCurrentTab

    hDestroyDocument()
    hDestroyDocument()

    '///</ul>

endcase

