'encoding UTF-8  Do not remove or change this line!
'*******************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_library_import.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsk $ $Date: 2007/12/17 12:51:52 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Import BASIC library (flat)
'*
'*******************************************************************************
'**
' #1 tBasicLibraryImport ' Import BASIC library (flat)
'**
'\******************************************************************************

testcase tBasicLibraryImport

    '///<h1>Import a basic library (flat)</h1>
    '///<ul>
    
    use "framework\tools\inc\stringtools.inc"
    
    dim cMsg as string
    dim iCurrentLib as integer

    '///+<li>Open Basic Organizer</li>
    ToolsMacro_uno
    
    '///+<li>Select My Macros</li>
    kontext "Makro"
    MakroAus.Select( 1 )
    
    '///+<li>Open the library Organizer</li>
    Verwalten.click()
    
    '///+<li>Switch to the libraries-tab</li>
    hSelectBasicObjectOrganizerTab( 3 )    
    
    '///+<li>Make sure My Macros is selected</li>
    printlog( "Select My macros" )
    kontext "TabBibliotheken"
    Bibliothek.select( 1 )
    
    '///+<li>Click to import a library</li>
    printlog( "Click to add a library" )
    Hinzufuegen.click()
    
    '///+<li>Enter the name of the library</li>
    printlog( "Enter the name of the library: " & LIBRARY_NAME )
    kontext "OeffnenDlg"
    DateiName.setText( LIBRARY_NAME )
    
    printlog( "Step into the directory" )
    OeffnenDlg.typeKeys( "<RETURN>" )
    
    '///+<li>Enter &quot;dialog.xlb&quot;</li>
    printlog( "Enter &quot;dialog.xlb&quot;" )
    DateiName.setText( "dialog.xlb" )
    
    '///+<li>Open the file</li>
    printlog( "Open dialog.xlb" )
    Oeffnen.click()
    
    '///+<li>Handle failing autocompletion</li>
    kontext "active"
    if ( active.exists( 1 ) ) then
        if ( active.getRT() <> 373 ) then
            cMSG = Active.getText()
            cMsg = hRemoveLineBreaks( cMsg )
            warnlog( "Autocompletion failed: " & cMsg )
            Active.ok()
            Kontext "OeffnenDlg"
            DateiName.setText( "dialog.xlb" )
            Oeffnen.click()
        endif
    endif
    
    '///+<li>Confirm to append libraries, accept defaults</li>
    printlog( "Confirm to append the library" )
    Kontext "AppendLibraries"
    AppendLibraries.ok()
    
    '///+<li>Find the new library, select it</li>
    printlog( "Select the new library" )
    kontext "TabBibliotheken"
    for iCurrentLib = 1 to Bibliotheksliste.getItemCount()
        Bibliotheksliste.select( iCurrentLib )
        if ( Bibliotheksliste.getSelText = LIBRARY_NAME ) then
            exit for
        endif
    next iCurrentLib        
    
    '///+<li>On libraries-tab click delete-button (correct lib must be selected)</li>
    printlog( "Delete the library, confirm with YES" )
    Kontext "TabBibliotheken"
    Loeschen.click()
    
    '///+<li>Confirm deletion with YES</li>
    Kontext "Active"
    if ( Active.exists( 1 ) ) then
        active.yes()
    else 
        warnlog( "Deletion warning for libraries is missing" )
    endif
    
    '///+<li>Close the macro organizer (Libraries Tab)</li>
    printlog( "Close macro/library organizer" )
    kontext "TabBibliotheken"
    TabBibliotheken.cancel()
    
    '///+<li>Close OpenOffice.org Basic Macros dialog</li>
    printlog( "Close macro organizer" )
    kontext "Makro"
    Makro.cancel()
    
    '///+<li>Cleanup: Close the document</li>
    hDestroyDocument()

    '///+<li>Cleanup: Delete the library (directory)</li>    
    hDeleteFile( hGetWorkPath() & LIBRARY_NAME )
    
    '///</ul>

    
endcase

