'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch_tools_common.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsi $ $Date: 2008/02/18 13:36:48 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Chart2 Tool library
'*
'**************************************************************************************************
'*
' #1 fInsertOLE                         ' User Insert / Object / OLE to insert a chart
' #1 fLoadVerySimpleChart               ' Load file with a very simple chart
' #1 fLoadVerySimpleChartAndSaveLocal   ' Load file with a very simple chart and save it loacally
' #1 fConvertChartTo3D                  ' Function to invoke the 'Insert::Titles...' dialog
'*
'\************************************************************************************************

sub fInsertOLE as BOOLEAN
'Insert Chart OLE in Document
    fInsertOLE = FALSE
    '/// Insert / Object / OLE
    InsertObjectOLEObject
    sleep(1)
    Kontext "OLEObjektEinfuegen"
    '/// Check if list box is not empty
    if Objekttyp.getItemcount < 1 then
        warnlog "There are no OLE-Objects in the listbox"
    endif
    '/// Select first entry in listbox (which should be the chart)
    Objekttyp.TypeKeys "<HOME>"
    '/// Quit dialog using OK
    OLEObjektEinfuegen.OK
    sleep(2)
    fInsertOLE = TRUE
end sub
'
'--------------------------------------------------------------------
'
function fLoadVerySimpleChart() as INTEGER
         fLoadVerySimpleChart = 99
'Load file with a very simple chart
'No Input
'Returns error-code:
'+ 0 := Sucess
'+ 1 := Serious problem trying to load the document
'+99 := Unexpected error

   dim sInputFile as string
   sInputFile = convertpath( gtesttoolpath & "chart2/update/input/verySimpleChart.ods" )   
   '/// Load file <i>gTesttoolpath</i>/chart2/update/input/verySimpleChart.ods
   try 
       call hDateiOeffnen ( sInputFile )
       printlog "File with very simple chart loaded"
       fLoadVerySimpleChart = 0
   catch
       qaErrorLog "Loading file with very simple chart seems to fail"
       fLoadVerySimpleChart = 1
   endcatch
end function
'
'--------------------------------------------------------------------
'
function fLoadVerySimpleChartAndSaveLocal() as INTEGER
         fLoadVerySimpleChartAndSaveLocal = 99
'Load file with a very simple chart and save it loacally
'No Input
'Returns error-code:
'+ 0 := Sucess
'+ 1 := Serious problem trying to load the document
'+ 2 := Serious problem trying to save the document

    dim iCheckIsFileLoaded as INTEGER
    dim sOutputFile as STRING
        sOutputFile = convertpath( gOfficepath & "user/work/verySimpleChart.ods" )
    iCheckIsFileLoaded = fLoadVerySimpleChart()
    if iCheckIsFileLoaded > 0 then
        'When loading fails pass error code to current function
        fLoadVerySimpleChartAndSaveLocal = iCheckIsFileLoaded
        exit function
    else
       printlog "File with very simple chart loaded successfully."       
    endif
    '/// Save document local
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<ESCAPE>"
    DocumentCalc.TypeKeys "<MOD1 HOME>"
    if NOT hSpeichernUnterKill (sOutputFile) then
        fLoadVerySimpleChartAndSaveLocal = 2
        qaErrorLog "Saving test document localy failed -> Aborting"
        call hCloseDocument
        exit function
    else
        printlog "File with very simple chart saved successfully."
    endif
    fLoadVerySimpleChartAndSaveLocal = 0
end function
'
'--------------------------------------------------------------------
'
function fConvertChartTo3D() as BOOLEAN
         fConvertChartTo3D = FALSE
'Function to invoke the 'Insert::Titles...' dialog
'No Input
'Returns TRUE on success

   '/// Invoke Format::Chart Type...
   if fInvokeChartTypeDialog() > 0 then
       warnlog "Invoking 'Format::Chart Type...' seems to cause an Error"
       exit function
   endif
   '/// Check 3D box
   if fSetChartType3D ( TRUE ) = 0 then
       fConvertChartTo3D = TRUE
   else
       warnlog "Converting chart to 3D seems to cause an Error"
       exit function
   endif
   '/// Close Chart Type dialog with OK
   if fCloseChartTypeDialogOK() > 0 then
       warnlog "Closing Chart Type dialog seems to cause an Error"
       fConvertChartTo3D = FALSE
   endif
end function

