'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_006_.inc,v $
'*
'*  $Revision: 1.33 $
'*
'*  last change: $Author: jsi $ $Date: 2007/12/05 13:50:50 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Check the toolbar resources for menu item Tools
'*
'************************************************************************************************
'*
' #1 C_006_ ' Initial routine
' #1 tToolsSpellcheck
' #1 tToolsSpellcheckAutomatic
' #1 tToolsThesaurus
' #1 tToolsLanguageChineseTranslation
' #1 tToolsLanguageHangulHanjaConversion
' #1 tToolsAutocorrection
' #1 tToolsTracePrecedents
' #1 tToolsRemovePrecedents
' #1 tToolsTraceDependents
' #1 tToolsRemoveDependents
' #1 tToolsRemoveAllTraces
' #1 tToolsTraceError
' #1 tToolsGoalSeek
' #1 tToolsScenarios
' #1 tToolsProtectDocumentSheet
' #1 tToolsProtectDocumentDocument
' #1 tToolsAutomaticCalculate
' #1 tToolsNeuCalculate
' #1 tToolsAutoInput
' #1 tToolsMacro
' #1 tToolsXMLFilterSettings ' Global routine for all Components delivered by JSI
' #1 tToolsCustomize
' #1 tToolsOptionsTest
'*
'\***********************************************************************************************

sub C_006_

   printLog Chr(13) + "--------- C_006_ ---------"
   
   call ExitRestartTheOffice
   Call tToolsSpellcheck
   Call tToolsSpellcheckAutomatic
   Call tToolsThesaurus
   call tToolsLanguageChineseTranslation
   call tToolsLanguageHangulHanjaConversion
   Call tToolsAutocorrection
   Call tToolsTracePrecedents
   Call tToolsRemovePrecedents
   Call tToolsTraceDependents
   Call tToolsRemoveDependents
   Call tToolsRemoveAllTraces
   Call tToolsTraceError
   Call tToolsGoalSeek
   Call tToolsScenarios
   Call tToolsProtectDocumentSheet
   Call tToolsProtectDocumentDocument
   Call tToolsAutomaticCalculate
   Call tToolsNeuCalculate
   Call tToolsAutoInput
   Call tToolsMacro                        
   printLog Chr(13) + "- Global routines for all Components -"          
   Call tToolsXMLFilterSettings
   Call tToolsCustomize   
   Call tToolsOptionsTest
End Sub

'
'-----------------------------------------------------
'
testcase tToolsSpellcheck

        if left(iSprache,1) <> "8" then
        Call hNewDocument
        DocumentCalc.TypeKeys "<RIGHT>"
	DocumentCalc.TypeKeys "unnown"
	DocumentCalc.TypeKeys "<RETURN>"
	DocumentCalc.TypeKeys "<UP>"
        ToolsSpellcheck
        Kontext "Rechtschreibung"
        DialogTest ( Rechtschreibung )
        Rechtschreibung.Close
        Call hCloseDocument
        else
                printlog "Spellcheck isn't possible for asian languages at this time"
        end if

endcase
'
'-----------------------------------------------------
'
testcase tToolsSpellcheckAutomatic

        Call hNewDocument
    ToolsSpellcheckAutoSpellcheck
    DocumentCalc.TypeKeys "<Right>unnown<Return><Up>"
    wait 2000
    ToolsSpellcheckAutoSpellcheck
    Call hCloseDocument

endcase
'
'-----------------------------------------------------
'
testcase tToolsLanguageChineseTranslation

    Dim bAsianLanguage   as Boolean

    PrintLog "- Tools / Language / Chinese Translation"

    '/// Open a new document
    Call hNewDocument

    '/// Enable 'Asian Language support' ON
    bAsianLanguage = ActiveDeactivateAsianSupport(TRUE)

    '/// Tools / Language / Chinese Translation
    try
        ToolsLanguageChineseTranslation
        Kontext "ChineseTranslation"
        Call DialogTest ( ChineseTranslation )
    catch
        Warnlog "- Tools/language / Chinese Translation is disabled or hidden!"
        Call hCloseDocument
        goto endsub
    endcatch

    '/// Click radiobutton 'Tradtional Chinese to simplified Chinese'
    try
        TChineseToSChinese.Check
    catch
        Warnlog "- Something is wrong in the radio button 'Tradtional Chinese to simplified Chinese' !"
    endcatch

    '/// Click radiobutton 'Simplified Chinese to Tradtional Chinese'
    try
        SChineseToTChinese.Check
    catch
        Warnlog "- Something is wrong in the radio button 'Simplified Chinese to Tradtional Chinese' !"
    endcatch

'    '/// Check and UnCheck checkbox 'Use SAR character variants'
'    try
'        UseSARCharacter.Check
'        UseSARCharacter.UnCheck
'    catch
'        Warnlog "- Something is wrong in checkbox 'Use SAR character variants' !"
'    endcatch

    '/// Check and UnCheck checkbox 'Translate Common Terms'
    try
        TranslateCommonTerms.Check
        TranslateCommonTerms.UnCheck
    catch
        Warnlog "- Something is wrong in checkbox 'Translate Common Terms' !"
    endcatch

    '/// Press 'Edit Terms' button , a new dialog should appear
    try
        EditTerms.Click
        Kontext "ChineseDictionary"
        Call DialogTest ( ChineseDictionary )
    catch
        Warnlog "- Something is wrong in the button 'Edit Terms' !"
        Kontext "ChineseTranslation"
        ChineseTranslation.Cancel
        Call hCloseDocument
        goto endsub
    endcatch

    '/// Click radiobutton 'Tradtional Chinese to simplified Chinese'
    try
        TChineseToSChinese.Check
    catch
        Warnlog "- Something is wrong in the radio button 'Tradtional Chinese to simplified Chinese' !"
    endcatch

    '/// Click radiobutton 'Simplified Chinese to Tradtional Chinese'
    try
        SChineseToTChinese.Check
    catch
        Warnlog "- Something is wrong in the radio button 'Simplified Chinese to Tradtional Chinese' !"
    endcatch

    '/// Check and UnCheck checkbox 'Reverse Mapping'
    try
        ReverseMapping.Check
        ReverseMapping.UnCheck
    catch
        Warnlog "- Something is wrong in checkbox 'Reverse Mapping' !"
    endcatch

    '/// Input something in Term
    try
        Term.SetText "SChinese"
    catch
        Warnlog "- Something is wrong in editbox 'Term' !"
    endcatch

    '/// Input something in Mapping
    try
        Mapping.SetText "TChinese"
    catch
        Warnlog "- Something is wrong in editbox 'Mapping' !"
    endcatch

    '/// Select 1 in property 
    try
        Property.Select 1
    catch
        Warnlog "- Something is wrong in listbox 'Property' !"
    endcatch

    '/// Press Add
    try
        Add.Click
    catch
        Warnlog "- Something is wrong in button 'Add' !"
    endcatch

    '/// Select item in combobox
    try
        Term.SetText    "SChinese2"
        Mapping.SetText "TChinese2"
        Add.Click
        SToTMappingContent.Select 1
        SToTMappingContent.Select 2
    catch
        Warnlog "- Something is wrong in combobox !"
    endcatch
    
    '/// Modify something then Press Modify
    try
        Mapping.SetText "TChinese1"
        Modify.Click
    catch
        Warnlog "- Something is wrong in button 'Modify' !"
    endcatch

    '/// Press Delete
    try
        Delete.Click
        Sleep 2
        Delete.Click
    catch
        Warnlog "- Something is wrong in button 'Delete' !"
    endcatch

    ChineseDictionary.OK

   Kontext "ChineseTranslation"
   ChineseTranslation.Cancel

   '/// Set the 'Asian Language support' to default
   if bAsianLanguage = FALSE then
       Call ActiveDeactivateAsianSupport(FALSE)
   end if

   '/// Close active document
   Call hCloseDocument

endcase
'
' -------------------------------------------
'
testcase tToolsLanguageHangulHanjaConversion

    Dim bAsianLanguage   as Boolean
    Dim sTestFile        as String

    sTestFile = Convertpath (gTesttoolpath + "calc\update\input\c_006\korean.sxc")

    PrintLog "- Tools / HangulHanjaConversion"

    '/// Open a new document
    Call hNewDocument

    '/// Enable 'Asian Language support' ON
    bAsianLanguage = ActiveDeactivateAsianSupport(TRUE)

    '/// Open the test file
    Call hDateiOeffnen(sTestFile)
    cGotoCell("B1")

    '/// Tools / HangulHanjaConversion
    try
        ToolsLanguageHangulHanjaConversion
    catch
        Warnlog "- Format / HangulHanjaConversion is disabled or hidden!"
        bAsianLanguage = ActiveDeactivateAsianSupport(False)
        Call hCloseDocument
        goto endsub
    endcatch

    
    Kontext "HangulHanjaConversion"
    if HangulHanjaConversion.Exists then
        Call DialogTest ( HangulHanjaConversion )
    else
        Warnlog "- Format / HangulHanjaConversion doesn't work. Dialog is not up"
        bAsianLanguage = ActiveDeactivateAsianSupport(False)
        Call hCloseDocument
        goto endsub
    endif
    
    Kontext "HangulHanjaConversion"
    '/// Close HangulHanja dialog     
    try
        HangulHanjaConversion.Close
    catch
        Warnlog "- Something is wrong in the button 'Close' !"
    endcatch
    Sleep 2
   
   '/// Set the 'Asian Language support' to default
    if bAsianLanguage = FALSE then
        Call ActiveDeactivateAsianSupport(FALSE)
    end if

   '/// Close active document
   Call hCloseDocument

endcase
'
'-----------------------------------------------------
'
testcase tToolsThesaurus
  Dim bThesaurusAvailable	as Boolean

  if gOOo then
    select case iSprache
      case 1, 42, 43, 44, 48, 49 :
          bThesaurusAvailable = TRUE
      case else:
          qaErrorLog "- No Thesaurus available in OpenOffice.org, language " & iSprache & "." 
          bThesaurusAvailable = FALSE
    end select
  else
    select case iSprache
      case 03, 07, 30, 35, 36, 37, 42, 47, 48, 51, 55, 81, 82, 86, 88, 90 :
          bThesaurusAvailable = FALSE
          qaErrorLog "- No Thesaurus available in language " & iSprache & "." 
      case else:
          bThesaurusAvailable = TRUE
    end select
  end if
  
  if bThesaurusAvailable then 
    Call hNewDocument
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "Test<Return><Up>"    
    ExtrasThesaurusCalc
    Kontext "Thesaurus"
    DialogTest ( Thesaurus )
    Sprache.Click
    sleep(1)
    Kontext "SpracheAuswaehlen"
    DialogTest ( SpracheAuswaehlen )
    SpracheAuswaehlen.Cancel
    sleep(1)
    Kontext "Thesaurus"
    Thesaurus.Cancel
    Call hCloseDocument
  endif
endcase
'
'-----------------------------------------------------
'
testcase tToolsAutocorrection

        Call hNewDocument

    ToolsAutocorrect
    try
        kontext "Active"
        if Active.exists then
                active.ok
                warnlog "It seems that an unexpected MsgBox is in the way"
        end if
    catch
    endcatch

    Kontext
    active.SetPage TabOptionen
    Kontext "TabOptionen"
    Call DialogTest ( TabOptionen )

    Kontext
    active.SetPage TabErsetzung
    Kontext "TabErsetzung"
    Call DialogTest ( TabErsetzung )

    Kontext
    active.SetPage TabAusnahmen
    Kontext "TabAusnahmen"
    Call DialogTest ( TabAusnahmen )
    Abkuerzungen.settext "Lala"
    AbkuerzungenNeu.click
    AbkuerzungenLoeschen.click
    Woerter.settext "LALA"
    WoerterNeu.click
    WoerterLoeschen.click

    Kontext
    active.SetPage TabTypografisch

    Kontext "TabTypografisch"
    EinfachWortAnfang.Click
    Kontext "Sonderzeichen"
    Call Dialogtest2 ( Sonderzeichen, 1 )
    Sonderzeichen.Cancel

    Kontext "TabTypografisch"
    EinfachWortEnde.Click
    Kontext "Sonderzeichen"
    Call Dialogtest2 ( Sonderzeichen, 2 )
    Sonderzeichen.Cancel

    Kontext "TabTypografisch"
    EinfachStandard.Click

    Kontext "TabTypografisch"
    DoppeltWortAnfang.Click
    Kontext "Sonderzeichen"
    Call Dialogtest2 ( Sonderzeichen, 3 )
    Sonderzeichen.Cancel

    Kontext "TabTypografisch"
    DoppeltWortEnde.Click
    Kontext "Sonderzeichen"
    Call Dialogtest2 ( Sonderzeichen, 4 )
    Sonderzeichen.Cancel

    Kontext "TabTypografisch"
    DoppeltStandard.Click
    TabTypografisch.cancel

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsTracePrecedents

    Call  hNewDocument
    DocumentCalc.Typekeys "<Right>=A1<Return><Up>"
    ToolsDetectiveTracePrecedents
    ToolsDetectiveRemovePrecedents
    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsRemovePrecedents

    Call  hNewDocument
    DocumentCalc.Typekeys "<Right>=A1<Return><Up>"
    ToolsDetectiveTracePrecedents
    ToolsDetectiveRemovePrecedents
    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsTraceDependents

    Call  hNewDocument
    Kontext "DocumentCalc"
    DocumentCalc.Typekeys "<Right>=A1<Return><Up><Left>"
    ToolsDetectiveTraceDependents
    ToolsDetectiveRemoveDependents
    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsRemoveDependents

    Call  hNewDocument
    DocumentCalc.Typekeys "<Right>=A1<Return><Up><Left>"
    ToolsDetectiveTraceDependents
    ToolsDetectiveRemoveDependents
    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsRemoveAllTraces

    Call  hNewDocument
    DocumentCalc.Typekeys "<Right>=A1<Return><Up>"
    ToolsDetectiveTracePrecedents
    DocumentCalc.Typekeys "<Right>=B1<Return><Up><Left>"
    ToolsDetectiveTraceDependents
    ToolsDetectiveRemoveAllTraces
    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
' a marked formula is required
testcase tToolsTraceError

    Call  hNewDocument
    Kontext
    DocumentCalc.Typekeys "=A2/A3<Return><Up>"
    ToolsDetectiveTraceError
    ToolsDetectiveRemoveAllTraces
    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsDetectiveMarkInvalidData

      Call  hNewDocument
      ToolsDetectiveMarkInvalidData
      ToolsDetectiveRemoveAllTraces
      Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsDetectiveFuellModus

    Call  hNewDocument
    ToolsDetectiveFillMode
    DocumentCalc.Typekeys "<Right>"
    ToolsDetectiveFillMode
    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsGoalSeek

    Call  hNewDocument
    ToolsGoalSeek
    Kontext "Zielwertsuche"
    DialogTest ( Zielwertsuche )
    Zielwertsuche.Cancel
    Call hCloseDocument

endcase
'
'------------------------------------------------------------
'
testcase tToolsScenarios

    Call  hNewDocument
    DocumentCalc.Typekeys "1<Return>2<Return><Up><Up>"
    Call ZellenMarkieren ( 2, 1 )
    ToolsScenarios
    Kontext "SzenarioAnlegen"
    DialogTest ( SzenarioAnlegen )
    SzenarioAnlegen.Ok
    Call hCloseDocument

endcase
'
'------------------------------------------------------------
'
testcase tToolsProtectDocumentSheet

    Call  hNewDocument
    ToolsProtectDocumentSheet
    Kontext "TabelleSchuetzen"
    DialogTest2 ( TabelleSchuetzen,1 )
    Passwort.SetText "wwwww"
    Bestaetigung.SetText ""
    TabelleSchuetzen.Ok

    Kontext "Active"
    if Active.Exists then
       DialogTest ( Active )
       Active.OK
    else
        warnlog "There wasn't reported any error by confirming a wrong password!"
    end if

    Kontext "TabelleSchuetzen"
    Bestaetigung.SetText "wwwww"
    TabelleSchuetzen.Ok

    ToolsProtectDocumentSheet
    Kontext "TabelleSchuetzen"
    DialogTest2 ( TabelleSchuetzen,3 )
    Passwort.setText "wwwww"
    TabelleSchuetzen.Ok

    ToolsProtectDocumentSheet
    Kontext "TabelleSchuetzen"
    TabelleSchuetzen.Cancel

    Call hCloseDocument

endcase
'
'------------------------------------------------------------
'
testcase tToolsProtectDocumentDocument

    Call  hNewDocument

    ToolsProtectDocumentDocument
    Kontext "DokumentSchuetzen"
    DialogTest2 ( DokumentSchuetzen,4 ) 'Id gleich tabelle schuetzen
    Passwort.setText "wwwww"
    Bestaetigung.SetText ""
    DokumentSchuetzen.ok

    Kontext "Active"
    if Active.Exists then
       DialogTest ( Active )
       Active.OK
    else
       warnlog "There wasn't reported any error by confirming a wrong password!"
    end if

    Kontext "DokumentSchuetzen"
    Bestaetigung.SetText "wwwww"
    DokumentSchuetzen.ok

    ToolsProtectDocumentDocument
    Kontext "DokumentSchuetzen"
    DialogTest2 ( DokumentSchuetzen,6 )
    Passwort.setText "wwwww"
    DokumentSchuetzen.ok

    ToolsProtectDocumentDocument
    Kontext "DokumentSchuetzen"
    DokumentSchuetzen.Cancel

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsAutomaticCalculate

    Call  hNewDocument
    ToolsCellContentsAutoCalculate
    ToolsCellContentsAutoCalculate
    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsNeuCalculate

    Call  hNewDocument
    ToolsCellContentsAutoCalculate
    Wait 100
    ToolsCellContentsRecalculate
    Wait 100
    ToolsCellContentsAutoCalculate
    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tToolsAutoInput

    Call  hNewDocument
    ToolsCellContentsAutoInput
    ToolsCellContentsAutoInput
    Call hCloseDocument

endcase
'
'------------------------------------------------------------
'
testcase tToolsMacro

    Call hNewDocument
    dim flag as boolean
    flag = true
    ToolsMacro

    Printlog "Testing Macro dialog"
    Kontext "Makro"
    Call DialogTest ( Makro )
    
    try
        Verwalten.Click
    catch
        warnlog "Button Organizer is disabled"
        flag = false
    endcatch

    if flag = true then
        printlog "+ Testing Organizer - Modules Tabpage"
        Kontext
        active.SetPage TabModule
        Kontext "TabModule"
        Call DialogTest ( TabModule )

        printlog "+ Testing Organizer - Libraries Tabpage"
        Kontext
        active.SetPage TabBibliotheken
        Kontext "TabBibliotheken"
        Call DialogTest ( TabBibliotheken )
        try
                Hinzufuegen.Click
        catch
            warnlog "The button 'Append' is disabled."
        endcatch
        try
                printlog "+ Testing Organizer - Libries/Append (File Open dialog should appear)"
                Kontext "OeffnenDlg"
                OeffnenDlg.Cancel
        catch
                warnlog "Looks like the file open dialog didn't came up"
        endcatch
        Kontext "TabBibliotheken"
        TabBibliotheken.close
    end if
    Kontext "Makro"
    Makro.Cancel
    call hCloseDocument

endcase
'
'------------------------------------------------------------

